/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.unidata.io.RandomAccessFile;

public class Grib2IdentificationSection {
    protected int length;
    protected int section;
    protected int center_id;
    protected int subcenter_id;
    protected int master_table_version;
    protected int local_table_version;
    protected int significanceOfRT;
    protected StringBuffer referenceTime = new StringBuffer();
    protected Calendar baseTime;
    protected int productStatus;
    protected int productType;

    public Grib2IdentificationSection(RandomAccessFile raf) throws NoValidGribException, NotSupportedException, IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        this.center_id = GribNumbers.int2(raf);
        this.subcenter_id = GribNumbers.int2(raf);
        this.master_table_version = raf.read();
        this.local_table_version = raf.read();
        this.significanceOfRT = raf.read();
        int year = GribNumbers.int2(raf);
        int month = raf.read() - 1;
        int day = raf.read();
        int hour = raf.read();
        int minute = raf.read();
        int second = raf.read();
        this.referenceTime.append(year);
        this.referenceTime.append(":");
        this.referenceTime.append(month);
        this.referenceTime.append(":");
        this.referenceTime.append(day);
        this.referenceTime.append("T");
        this.referenceTime.append(hour);
        this.referenceTime.append(":");
        this.referenceTime.append(minute);
        this.referenceTime.append(":");
        this.referenceTime.append(second);
        this.baseTime = new GregorianCalendar(year, month, day, hour, minute, second);
        this.baseTime.set(15, 0);
        this.baseTime.set(16, 0);
        this.productStatus = raf.read();
        this.productType = raf.read();
    }

    public int getLength() {
        return this.length;
    }

    public int getSection() {
        return this.section;
    }

    public int getCenter_id() {
        return this.center_id;
    }

    public String getCenter_idName() {
        switch (this.center_id) {
            case 0: {
                return "WMO Secretariat";
            }
            case 1: 
            case 2: {
                return "Melbourne";
            }
            case 4: 
            case 5: {
                return "Moscow";
            }
            case 7: {
                return "US National Weather Service (NCEP)";
            }
            case 8: {
                return "US National Weather Service (NWSTG)";
            }
            case 9: {
                return "US National Weather Service (other)";
            }
            case 10: {
                return "Cairo (RSMC/RAFC)";
            }
            case 12: {
                return "Dakar (RSMC/RAFC)";
            }
            case 14: {
                return "Nairobi (RSMC/RAFC)";
            }
            case 18: {
                return "Tunis Casablanca (RSMC)";
            }
            case 20: {
                return "Las Palmas (RAFC)";
            }
            case 21: {
                return "Algiers (RSMC)";
            }
            case 24: {
                return "Pretoria (RSMC)";
            }
            case 25: {
                return "La R?union (RSMC)";
            }
            case 26: {
                return "Khabarovsk (RSMC)";
            }
            case 28: {
                return "New Delhi (RSMC/RAFC)";
            }
            case 30: {
                return "Novosibirsk (RSMC)";
            }
            case 32: {
                return "Tashkent (RSMC)";
            }
            case 33: {
                return "eddah (RSMC)";
            }
            case 34: {
                return "Tokyo (RSMC), Japan Meteorological Agency";
            }
            case 36: {
                return "Bangkok";
            }
            case 37: {
                return "Ulan Bator";
            }
            case 38: {
                return "Beijing (RSMC)";
            }
            case 40: {
                return "Seoul";
            }
            case 41: {
                return "Buenos Aires (RSMC/RAFC)";
            }
            case 43: {
                return "Brasilia (RSMC/RAFC)";
            }
            case 45: {
                return "Santiago";
            }
            case 46: {
                return "Brazilian Space Agency ? INPE";
            }
            case 51: {
                return "Miami (RSMC/RAFC)";
            }
            case 52: {
                return "Miami RSMC, National Hurricane Center";
            }
            case 53: {
                return "Montreal (RSMC)";
            }
            case 55: {
                return "San Francisco";
            }
            case 57: {
                return "U.S. Air Force Air Force Global Weather Central";
            }
            case 58: {
                return "Fleet Numerical Meteorology and Oceanography Center";
            }
            case 59: {
                return "The NOAA Forecast Systems Laboratory";
            }
            case 60: {
                return "United States National Centre for Atmospheric Research (NCAR)";
            }
            case 64: {
                return "Honolulu";
            }
            case 65: {
                return "Darwin (RSMC)";
            }
            case 67: {
                return "Melbourne (RSMC)";
            }
            case 69: {
                return "Wellington (RSMC/RAFC)";
            }
            case 71: {
                return "Nadi (RSMC)";
            }
            case 74: {
                return "UK Meteorological Office Bracknell (RSMC)";
            }
            case 76: {
                return "Moscow (RSMC/RAFC)";
            }
            case 78: {
                return "Offenbach (RSMC)";
            }
            case 80: {
                return "Rome (RSMC)";
            }
            case 82: {
                return "Norrk?ping";
            }
            case 85: {
                return "Toulouse (RSMC)";
            }
            case 86: {
                return "Helsinki";
            }
            case 87: {
                return "Belgrade";
            }
            case 88: {
                return "Oslo";
            }
            case 89: {
                return "Prague";
            }
            case 90: {
                return "Episkopi";
            }
            case 91: {
                return "Ankara";
            }
            case 92: {
                return "Frankfurt/Main (RAFC)";
            }
            case 93: {
                return "London (WAFC)";
            }
            case 94: {
                return "Copenhagen";
            }
            case 95: {
                return "Rota";
            }
            case 96: {
                return "Athens";
            }
            case 97: {
                return "European Space Agency (ESA)";
            }
            case 98: {
                return "ECMWF, RSMC";
            }
            case 99: {
                return "De Bilt";
            }
            case 110: {
                return "Hong-Kong";
            }
            case 210: {
                return "Frascati (ESA/ESRIN)";
            }
            case 211: {
                return "Lanion";
            }
            case 212: {
                return "Lisboa";
            }
            case 213: {
                return "Reykjavik";
            }
            case 254: {
                return "EUMETSAT Operation Centre";
            }
        }
        return "Unknown";
    }

    public int getSubcenter_id() {
        return this.subcenter_id;
    }

    public int getMaster_table_version() {
        return this.master_table_version;
    }

    public int getLocal_table_version() {
        return this.local_table_version;
    }

    public int getSignificanceOfRT() {
        return this.significanceOfRT;
    }

    public String getSignificanceOfRTName() {
        switch (this.significanceOfRT) {
            case 0: {
                return "Analysis";
            }
            case 1: {
                return "Start of forecast";
            }
            case 2: {
                return "Verifying time of forecast";
            }
            case 3: {
                return "Observation time";
            }
        }
        return "Unknown";
    }

    public String getReferenceTime() {
        return this.referenceTime.toString();
    }

    public Calendar getBaseTime() {
        return this.baseTime;
    }

    public int getProductStatus() {
        return this.productStatus;
    }

    public String getProductStatusName() {
        switch (this.productStatus) {
            case 0: {
                return "Operational products";
            }
            case 1: {
                return "Operational test products";
            }
            case 2: {
                return "Research products";
            }
            case 3: {
                return "Re-analysis products";
            }
        }
        return "Unknown";
    }

    public int getProductType() {
        return this.productType;
    }

    public String getProductTypeName() {
        switch (this.productType) {
            case 0: {
                return "Analysis products";
            }
            case 1: {
                return "Forecast products";
            }
            case 2: {
                return "Analysis and forecast products";
            }
            case 3: {
                return "Control forecast products";
            }
            case 4: {
                return "Perturbed forecast products";
            }
            case 5: {
                return "Control and Perturbed forecast products";
            }
            case 6: {
                return "Processed satellite observations";
            }
            case 7: {
                return "Processed radar observations";
            }
        }
        return "Unknown";
    }
}

