/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import java.util.zip.CRC32;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.unidata.io.RandomAccessFile;

public class Grib2GridDefinitionSection {
    protected int length;
    protected int section;
    protected int source;
    protected int numberPoints;
    protected int olon;
    protected int iolon;
    protected int gdtn;
    protected String name;
    protected int shape;
    protected float earthRadius;
    protected float majorAxis;
    protected float minorAxis;
    protected int nx;
    protected int ny;
    protected int angle;
    protected int subdivisionsangle;
    protected int la1;
    protected int lo1;
    protected int resolution;
    protected int la2;
    protected int lo2;
    protected int lad;
    protected int lov;
    protected float dx;
    protected float dy;
    protected int projectionCenter;
    protected int scanMode;
    protected int latin1;
    protected int latin2;
    protected int spLat;
    protected int spLon;
    protected float rotationangle;
    protected int poleLat;
    protected int poleLon;
    protected int lonofcenter;
    protected int factor;
    protected int n;
    protected float j;
    protected float k;
    protected float m;
    protected int method;
    protected int mode;
    protected int lap;
    protected int lop;
    protected int xp;
    protected int yp;
    protected int xo;
    protected int yo;
    protected int altitude;
    protected int n2;
    protected int n3;
    protected int ni;
    protected int nd;
    protected int position;
    protected int order;
    protected float nb;
    protected float nr;
    protected float dstart;
    protected String checksum = "";

    public Grib2GridDefinitionSection(RandomAccessFile raf, boolean doCheckSum) throws NoValidGribException, IOException {
        int scalefactorradius = 0;
        int scaledvalueradius = 0;
        int scalefactormajor = 0;
        int scaledvaluemajor = 0;
        int scalefactorminor = 0;
        int scaledvalueminor = 0;
        this.length = GribNumbers.int4(raf);
        if (doCheckSum) {
            long mark = raf.getFilePointer();
            byte[] dst = new byte[this.length - 4];
            raf.read(dst);
            raf.seek(mark);
            CRC32 cs = new CRC32();
            cs.update(dst);
            this.checksum = Long.toString(cs.getValue());
        }
        this.section = raf.read();
        this.source = raf.read();
        this.numberPoints = GribNumbers.int4(raf);
        this.olon = raf.read();
        this.iolon = raf.read();
        this.gdtn = GribNumbers.int2(raf);
        this.name = Grib2GridDefinitionSection.getGridName(this.gdtn);
        switch (this.gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.angle = GribNumbers.int4(raf);
                this.subdivisionsangle = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.la2 = GribNumbers.int4(raf);
                this.lo2 = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                this.scanMode = raf.read();
                if (this.gdtn == 1) {
                    this.name = "Rotated Latitude/longitude";
                    this.spLat = GribNumbers.int4(raf);
                    this.spLon = GribNumbers.int4(raf);
                    this.rotationangle = raf.readFloat();
                    break;
                }
                if (this.gdtn == 2) {
                    this.name = "Stretched Latitude/longitude";
                    this.poleLat = GribNumbers.int4(raf);
                    this.poleLon = GribNumbers.int4(raf);
                    this.factor = GribNumbers.int4(raf);
                    break;
                }
                if (this.gdtn != 3) break;
                this.name = "Stretched and Rotated Latitude/longitude";
                this.spLat = GribNumbers.int4(raf);
                this.spLon = GribNumbers.int4(raf);
                this.rotationangle = raf.readFloat();
                this.poleLat = GribNumbers.int4(raf);
                this.poleLon = GribNumbers.int4(raf);
                this.factor = GribNumbers.int4(raf);
                break;
            }
            case 10: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.lad = GribNumbers.int4(raf);
                this.la2 = GribNumbers.int4(raf);
                this.lo2 = GribNumbers.int4(raf);
                this.scanMode = raf.read();
                this.angle = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                break;
            }
            case 20: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.lad = GribNumbers.int4(raf);
                this.lov = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                break;
            }
            case 30: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.lad = GribNumbers.int4(raf);
                this.lov = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                this.latin1 = GribNumbers.int4(raf);
                this.latin2 = GribNumbers.int4(raf);
                this.spLat = GribNumbers.int4(raf);
                this.spLon = GribNumbers.int4(raf);
                break;
            }
            case 31: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.lad = GribNumbers.int4(raf);
                this.lov = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                this.latin1 = GribNumbers.int4(raf);
                this.latin2 = GribNumbers.int4(raf);
                this.spLat = GribNumbers.int4(raf);
                this.spLon = GribNumbers.int4(raf);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.angle = GribNumbers.int4(raf);
                this.subdivisionsangle = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.la2 = GribNumbers.int4(raf);
                this.lo2 = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.n = raf.read();
                this.scanMode = raf.read();
                if (this.gdtn == 41) {
                    this.spLat = GribNumbers.int4(raf);
                    this.spLon = GribNumbers.int4(raf);
                    this.rotationangle = raf.readFloat();
                    break;
                }
                if (this.gdtn == 42) {
                    this.poleLat = GribNumbers.int4(raf);
                    this.poleLon = GribNumbers.int4(raf);
                    this.factor = GribNumbers.int4(raf);
                    break;
                }
                if (this.gdtn != 43) break;
                this.spLat = GribNumbers.int4(raf);
                this.spLon = GribNumbers.int4(raf);
                this.rotationangle = raf.readFloat();
                this.poleLat = GribNumbers.int4(raf);
                this.poleLon = GribNumbers.int4(raf);
                this.factor = GribNumbers.int4(raf);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.j = raf.readFloat();
                this.k = raf.readFloat();
                this.m = raf.readFloat();
                this.method = raf.read();
                this.mode = raf.read();
                if (this.gdtn == 51) {
                    this.spLat = GribNumbers.int4(raf);
                    this.spLon = GribNumbers.int4(raf);
                    this.rotationangle = raf.readFloat();
                    break;
                }
                if (this.gdtn == 52) {
                    this.poleLat = GribNumbers.int4(raf);
                    this.poleLon = GribNumbers.int4(raf);
                    this.factor = GribNumbers.int4(raf);
                    break;
                }
                if (this.gdtn != 53) break;
                this.spLat = GribNumbers.int4(raf);
                this.spLon = GribNumbers.int4(raf);
                this.rotationangle = raf.readFloat();
                this.poleLat = GribNumbers.int4(raf);
                this.poleLon = GribNumbers.int4(raf);
                this.factor = GribNumbers.int4(raf);
                break;
            }
            case 90: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.lap = GribNumbers.int4(raf);
                this.lop = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                this.xp = GribNumbers.int4(raf);
                this.yp = GribNumbers.int4(raf);
                this.scanMode = raf.read();
                this.angle = GribNumbers.int4(raf);
                this.altitude = GribNumbers.int4(raf);
                this.xo = GribNumbers.int4(raf);
                this.yo = GribNumbers.int4(raf);
                break;
            }
            case 100: {
                this.n2 = raf.read();
                this.n3 = raf.read();
                this.ni = GribNumbers.int2(raf);
                this.nd = raf.read();
                this.poleLat = GribNumbers.int4(raf);
                this.poleLon = GribNumbers.int4(raf);
                this.lonofcenter = GribNumbers.int4(raf);
                this.position = raf.read();
                this.order = raf.read();
                this.scanMode = raf.read();
                this.n = GribNumbers.int4(raf);
                break;
            }
            case 110: {
                this.shape = raf.read();
                scalefactorradius = raf.read();
                scaledvalueradius = GribNumbers.int4(raf);
                scalefactormajor = raf.read();
                scaledvaluemajor = GribNumbers.int4(raf);
                scalefactorminor = raf.read();
                scaledvalueminor = GribNumbers.int4(raf);
                this.nx = GribNumbers.int4(raf);
                this.ny = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.resolution = raf.read();
                this.dx = GribNumbers.int4(raf);
                this.dy = GribNumbers.int4(raf);
                this.projectionCenter = raf.read();
                this.scanMode = raf.read();
                break;
            }
            case 120: {
                this.nb = GribNumbers.int4(raf);
                this.nr = GribNumbers.int4(raf);
                this.la1 = GribNumbers.int4(raf);
                this.lo1 = GribNumbers.int4(raf);
                this.dx = GribNumbers.int4(raf);
                this.dstart = raf.readFloat();
                this.scanMode = raf.read();
                int i = 0;
                while ((float)i < this.nr) {
                    ++i;
                }
                System.out.println("need code to get azi and adelta");
                break;
            }
            default: {
                System.out.println("Unknown Grid Type");
            }
        }
        if (this.gdtn < 44 || this.gdtn == 90 || this.gdtn == 110) {
            if (this.shape == 1) {
                this.earthRadius = scaledvalueradius;
                if (scalefactorradius != 0) {
                    this.earthRadius = (float)((double)this.earthRadius / Math.pow(10.0, scalefactorradius));
                }
            } else if (this.shape == 3) {
                this.majorAxis = scalefactormajor;
                if (scaledvaluemajor != 0) {
                    this.majorAxis = (float)((double)this.majorAxis / Math.pow(10.0, scaledvaluemajor));
                }
                this.minorAxis = scalefactorminor;
                if (scaledvalueminor != 0) {
                    this.minorAxis = (float)((double)this.minorAxis / Math.pow(10.0, scaledvalueminor));
                }
            }
        }
    }

    public static String getGridName(int gdtn) {
        switch (gdtn) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "Latitude/Longitude";
            }
            case 10: {
                return "Mercator";
            }
            case 20: {
                return "Polar stereographic";
            }
            case 30: {
                return "Lambert Conformal";
            }
            case 31: {
                return "Albers Equal Area";
            }
            case 40: {
                return "Gaussian latitude/longitude";
            }
            case 41: {
                return "Rotated Gaussian Latitude/longitude";
            }
            case 42: {
                return "Stretched Gaussian Latitude/longitude";
            }
            case 43: {
                return "Stretched and Rotated Gaussian Latitude/longitude";
            }
            case 50: {
                return "Spherical harmonic coefficients";
            }
            case 51: {
                return "Rotated Spherical harmonic coefficients";
            }
            case 52: {
                return "Stretched Spherical harmonic coefficients";
            }
            case 53: {
                return "Stretched and Rotated Spherical harmonic coefficients";
            }
            case 90: {
                return "Space View Perspective or Orthographic";
            }
            case 100: {
                return "Triangular Grid Based on an Icosahedron";
            }
            case 110: {
                return "Equatorial Azimuthal Equidistant";
            }
            case 120: {
                return "Azimuth-Range";
            }
        }
        return "Unknown";
    }

    public int getLength() {
        return this.length;
    }

    public int getSection() {
        return this.section;
    }

    public int getSource() {
        return this.source;
    }

    public int getNumberPoints() {
        return this.numberPoints;
    }

    public int getOlon() {
        return this.olon;
    }

    public int getIolon() {
        return this.iolon;
    }

    public int getGdtn() {
        return this.gdtn;
    }

    public String getName() {
        return this.name;
    }

    public int getShape() {
        return this.shape;
    }

    public String getShapeName() {
        return Grib2GridDefinitionSection.getShapeName(this.shape);
    }

    public static String getShapeName(int shape) {
        switch (shape) {
            case 0: {
                return "Earth spherical with radius = 6367.47 km";
            }
            case 1: {
                return "Earth spherical with radius specified by producer";
            }
            case 2: {
                return "Earth oblate spherical with axes specified by producer";
            }
            case 6: {
                return "Earth assumed spherical with radius of 6,371,229.0 m";
            }
        }
        return "Unknown";
    }

    public float getEarthRadius() {
        return this.earthRadius;
    }

    public float getMajorAxis() {
        return this.majorAxis;
    }

    public float getMinorAxis() {
        return this.minorAxis;
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public int getAngle() {
        return this.angle;
    }

    public int getSubdivisionsangle() {
        return this.subdivisionsangle;
    }

    public float getLa1() {
        return (float)((double)this.la1 / 1000000.0);
    }

    public float getLo1() {
        return (float)((double)this.lo1 / 1000000.0);
    }

    public int getResolution() {
        return this.resolution;
    }

    public float getLa2() {
        return (float)((double)this.la2 / 1000000.0);
    }

    public float getLo2() {
        return (float)((double)this.lo2 / 1000000.0);
    }

    public float getLad() {
        return (float)((double)this.lad / 1000000.0);
    }

    public float getLov() {
        return (float)((double)this.lov / 1000000.0);
    }

    public float getDx() {
        return (float)((double)this.dx / 1000.0);
    }

    public float getDy() {
        return (float)((double)this.dy / 1000.0);
    }

    public int getProjectionCenter() {
        return this.projectionCenter;
    }

    public int getScanMode() {
        return this.scanMode;
    }

    public float getLatin1() {
        return (float)((double)this.latin1 / 1000000.0);
    }

    public float getLatin2() {
        return (float)((double)this.latin2 / 1000000.0);
    }

    public float getSpLat() {
        return (float)((double)this.spLat / 1000000.0);
    }

    public float getSpLon() {
        return (float)((double)this.spLon / 1000000.0);
    }

    public float getRotationangle() {
        return this.rotationangle;
    }

    public float getPoleLat() {
        return (float)((double)this.poleLat / 1000000.0);
    }

    public float getPoleLon() {
        return (float)((double)this.poleLon / 1000000.0);
    }

    public float getFactor() {
        return (float)((double)this.factor / 1000000.0);
    }

    public int getN() {
        return this.n;
    }

    public float getJ() {
        return this.j;
    }

    public float getK() {
        return this.k;
    }

    public float getM() {
        return this.m;
    }

    public int getMethod() {
        return this.method;
    }

    public int getMode() {
        return this.mode;
    }

    public float getLap() {
        return (float)((double)this.lap / 1000000.0);
    }

    public float getLop() {
        return (float)((double)this.lop / 1000000.0);
    }

    public float getXp() {
        return (float)((double)this.xp / 1000.0);
    }

    public float getYp() {
        return (float)((double)this.yp / 1000.0);
    }

    public float getXo() {
        return (float)((double)this.xo / 1000000.0);
    }

    public float getYo() {
        return (float)((double)this.yo / 1000000.0);
    }

    public float getAltitude() {
        return (float)((double)this.altitude / 1000000.0);
    }

    public int getN2() {
        return this.n2;
    }

    public int getN3() {
        return this.n3;
    }

    public int getNi() {
        return this.ni;
    }

    public int getNd() {
        return this.nd;
    }

    public int getPosition() {
        return this.position;
    }

    public int getOrder() {
        return this.order;
    }

    public float getNb() {
        return this.nb;
    }

    public float getNr() {
        return this.nr;
    }

    public float getDstart() {
        return this.dstart;
    }

    public String getCheckSum() {
        return this.checksum;
    }

    public String toString() {
        String str = "    GDS section:\n      ";
        str = str + "  (" + this.nx + "x" + this.ny + ")\n      ";
        str = str + "  (dx " + this.dx + ")\n      ";
        str = str + "  (dy " + this.dy + ")";
        return str;
    }
}

