/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import jj2000.j2k.decoder.Grib2JpegDecoder;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib2DataSection {
    protected int length;
    protected int section;
    protected int bitMapIndicator;
    protected float[] data;
    protected int bitBuf = 0;
    protected int bitPos = 0;
    protected int index = 0;
    protected int scanMode;
    protected int count;
    protected int Xlength;

    public Grib2DataSection(boolean getData, RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs) throws NoValidGribException, NotSupportedException, IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        if (!getData) {
            if (this.length > 0 && (long)this.length < raf.length()) {
                raf.skipBytes(this.length - 5);
            } else {
                this.length = 5;
            }
            return;
        }
        int dtn = drs.getDataTemplateNumber();
        if (dtn == 2 || dtn == 3) {
            this.complexUnpacking(raf, gds, drs);
        } else if (dtn == 40 || dtn == 40000) {
            this.jpeg2000Unpacking(raf, gds, drs);
        }
    }

    private void complexUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs) throws IOException {
        int X2;
        int j;
        float pmv = drs.getPrimaryMissingValue();
        int NG = drs.getNumberOfGroups();
        int dtn = drs.getDataTemplateNumber();
        if (dtn == 3) {
            int os = drs.getOrderSpatial();
            int ds = drs.getDescriptorSpatial();
            if (os != 1) {
                if (os == 2) {
                    int h1 = GribNumbers.int2(raf);
                    int h2 = GribNumbers.int2(raf);
                    float hMin = this.Grib2Short2Float(raf, ds);
                } else {
                    System.out.println("DS error os=" + os + " ds =" + ds);
                }
            }
        }
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            X1[i] = this.bits2UInt(nb, raf);
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            NB[i] = this.bits2UInt(nb, raf);
        }
        int[] L = new int[NG];
        int countL = 0;
        int ref = drs.getReferenceGroupLength();
        int len_inc = drs.getLengthIncrement();
        nb = drs.getBitsScaledGroupLength();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG; ++i) {
            L[i] = ref + this.bits2UInt(nb, raf) * len_inc;
            countL += L[i];
        }
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        this.data = new float[countL];
        this.scanMode = gds.getScanMode();
        this.count = 0;
        this.Xlength = gds.getNx();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i = 0; i < NG - 1; ++i) {
            for (j = 0; j < L[i]; ++j) {
                if (NB[i] == 0) {
                    this.data[this.calculateIndex()] = pmv;
                    continue;
                }
                X2 = this.bits2UInt(NB[i], raf);
                this.data[this.calculateIndex()] = (R + (float)(X1[i] + X2) * EE) / DD;
            }
        }
        int last = drs.getLengthLastGroup();
        for (j = 0; j < last; ++j) {
            if (NB[NG - 1] == 0) {
                this.data[this.calculateIndex()] = pmv;
                continue;
            }
            X2 = this.bits2UInt(NB[NG - 1], raf);
            this.data[this.calculateIndex()] = (R + (float)(X1[NG - 1] + X2) * EE) / DD;
        }
    }

    private void jpeg2000Unpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs) throws IOException {
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        String[] argv = new String[]{"-rate", Integer.toString(nb), "-verbose", "off"};
        Grib2JpegDecoder g2j = new Grib2JpegDecoder(argv);
        g2j.decode(raf, this.length - 5);
        int numberPoints = gds.getNumberPoints();
        this.data = new float[numberPoints];
        for (int i = 0; i < numberPoints; ++i) {
            this.data[i] = (R + (float)g2j.data[i] * EE) / DD;
        }
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public float Grib2Short2Float(RandomAccessFile raf, int numberBytes) throws IOException {
        int result = 0;
        if (numberBytes == 2) {
            result = GribNumbers.int2(raf);
        } else if (numberBytes == 4) {
            result = GribNumbers.int4(raf);
        }
        Integer theResult = new Integer(result);
        float floatResult = theResult.floatValue();
        return floatResult;
    }

    private int calculateIndex() {
        int index = -1;
        if (this.scanMode == 80) {
            int row = this.count / this.Xlength;
            if (row % 2 == 1) {
                int rowPosition = this.count - row * this.Xlength;
                index = (row + 1) * this.Xlength - rowPosition - 1;
            } else {
                index = this.count;
            }
        } else if (this.scanMode == 0 || this.scanMode == 64) {
            index = this.count;
        }
        ++this.count;
        return index;
    }

    public int getLength() {
        return this.length;
    }

    public int getSection() {
        return this.section;
    }

    public int getBitMapIndicator() {
        return this.bitMapIndicator;
    }

    public float[] getData() {
        return this.data;
    }

    public String toString() {
        return "    DataSection section:\n";
    }
}

