/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.unidata.io.RandomAccessFile;

public class Grib2DataRepresentationSection {
    protected int length;
    protected int section;
    protected int dataPoints;
    protected int dataTemplate;
    protected float referenceValue;
    protected int binaryScaleFactor;
    protected int decimalScaleFactor;
    protected int numberOfBits;
    protected int originalType;
    protected int splittingMethod;
    protected int compressionMethod;
    protected int compressionRatio;
    protected int missingValueManagement;
    protected float primaryMissingValue;
    protected float secondaryMissingValue;
    protected int numberOfGroups;
    protected int referenceGroupWidths;
    protected int bitsGroupWidths;
    protected int referenceGroupLength;
    protected int lengthIncrement;
    protected int lengthLastGroup;
    protected int bitsScaledGroupLength;
    protected int orderSpatial;
    protected int descriptorSpatial;

    public Grib2DataRepresentationSection(RandomAccessFile raf) throws NoValidGribException, NotSupportedException, IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        this.dataPoints = GribNumbers.int4(raf);
        this.dataTemplate = GribNumbers.uint2(raf);
        switch (this.dataTemplate) {
            case 2: 
            case 3: {
                this.referenceValue = raf.readFloat();
                this.binaryScaleFactor = GribNumbers.int2(raf);
                this.decimalScaleFactor = GribNumbers.int2(raf);
                this.numberOfBits = raf.read();
                this.originalType = raf.read();
                this.splittingMethod = raf.read();
                this.missingValueManagement = raf.read();
                this.primaryMissingValue = raf.readFloat();
                this.secondaryMissingValue = raf.readFloat();
                this.numberOfGroups = GribNumbers.int4(raf);
                this.referenceGroupWidths = raf.read();
                this.bitsGroupWidths = raf.read();
                this.referenceGroupLength = GribNumbers.int4(raf);
                this.lengthIncrement = raf.read();
                this.lengthLastGroup = GribNumbers.int4(raf);
                this.bitsScaledGroupLength = raf.read();
                if (this.dataTemplate == 2) break;
                this.orderSpatial = raf.read();
                this.descriptorSpatial = raf.read();
                break;
            }
            case 40: 
            case 40000: {
                this.referenceValue = raf.readFloat();
                this.binaryScaleFactor = GribNumbers.int2(raf);
                this.decimalScaleFactor = GribNumbers.int2(raf);
                this.numberOfBits = raf.read();
                this.originalType = raf.read();
                this.compressionMethod = raf.read();
                this.compressionRatio = raf.read();
                break;
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getDataTemplateNumber() {
        return this.dataTemplate;
    }

    public float getReferenceValue() {
        return this.referenceValue;
    }

    public int getBinaryScaleFactor() {
        return this.binaryScaleFactor;
    }

    public int getDecimalScaleFactor() {
        return this.decimalScaleFactor;
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int getOriginalType() {
        return this.originalType;
    }

    public int getSplittingMethod() {
        return this.splittingMethod;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public int getCompressionRatio() {
        return this.compressionRatio;
    }

    public int getMissingValueManagement() {
        return this.missingValueManagement;
    }

    public float getPrimaryMissingValue() {
        return this.primaryMissingValue;
    }

    public float getSecondaryMissingValue() {
        return this.secondaryMissingValue;
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public int getReferenceGroupWidths() {
        return this.referenceGroupWidths;
    }

    public int getBitsGroupWidths() {
        return this.bitsGroupWidths;
    }

    public int getReferenceGroupLength() {
        return this.referenceGroupLength;
    }

    public int getLengthIncrement() {
        return this.lengthIncrement;
    }

    public int getLengthLastGroup() {
        return this.lengthLastGroup;
    }

    public int getBitsScaledGroupLength() {
        return this.bitsScaledGroupLength;
    }

    public int getOrderSpatial() {
        return this.orderSpatial;
    }

    public int getDescriptorSpatial() {
        return this.descriptorSpatial;
    }

    public String toString() {
        return "DataRepresentationSection section:\n";
    }
}

