/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Data {
    RandomAccessFile raf = null;

    public Grib2Data(String filename) throws NotSupportedException, NoValidGribException, IOException {
        this.raf = new RandomAccessFile(filename, "r");
    }

    public Grib2Data(RandomAccessFile raf) throws NotSupportedException, NoValidGribException, IOException {
        this.raf = raf;
    }

    public float[] getData(long GdsOffset, long PdsOffset) throws NotSupportedException, NoValidGribException, IOException {
        long start = System.currentTimeMillis();
        this.raf.seek(GdsOffset);
        Grib2GridDefinitionSection gds = new Grib2GridDefinitionSection(this.raf, false);
        this.raf.seek(PdsOffset);
        Grib2ProductDefinitionSection pds = new Grib2ProductDefinitionSection(this.raf);
        Grib2DataRepresentationSection drs = new Grib2DataRepresentationSection(this.raf);
        Grib2BitMapSection bms = new Grib2BitMapSection(this.raf);
        Grib2DataSection ds = new Grib2DataSection(true, this.raf, gds, drs);
        return ds.getData();
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public String toString() {
        return "GRIB file ( info)";
    }
}

