/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

public class SmartStringArray {
    int sp = 0;
    private String[] array;
    private int growthSize;
    private static final int START = 64;

    public SmartStringArray() {
        this(64);
    }

    public SmartStringArray(int initialSize) {
        this(initialSize, initialSize / 4);
    }

    public SmartStringArray(int initialSize, int growthSize) {
        this.growthSize = growthSize;
        this.array = new String[initialSize];
    }

    public SmartStringArray(String[] anArr) {
        this.array = anArr;
        this.growthSize = 16;
        this.sp = this.array.length;
    }

    public void reset() {
        this.sp = 0;
    }

    public void add(String str) {
        if (this.sp >= this.array.length) {
            String[] tmpArray = new String[this.array.length + this.growthSize];
            System.arraycopy(this.array, 0, tmpArray, 0, this.array.length);
            this.array = tmpArray;
        }
        this.array[this.sp] = str;
        ++this.sp;
    }

    public String[] toArray() {
        String[] trimmedArray = new String[this.sp];
        System.arraycopy(this.array, 0, trimmedArray, 0, trimmedArray.length);
        return trimmedArray;
    }

    public int size() {
        return this.sp;
    }

    public static String[] split(String token, String string) {
        SmartStringArray ssa = new SmartStringArray();
        int previousLoc = 0;
        int loc = string.indexOf(token, previousLoc);
        if (loc == -1) {
            ssa.add(string);
            return ssa.toArray();
        }
        do {
            ssa.add(string.substring(previousLoc, loc));
        } while ((loc = string.indexOf(token, previousLoc = loc + token.length())) != -1 && previousLoc < string.length());
        ssa.add(string.substring(previousLoc));
        return ssa.toArray();
    }

    public static String[] removeBlanks(String[] inArr) {
        int nonBl = 0;
        for (int i = 0; i < inArr.length; ++i) {
            String inStr = inArr[i].trim();
            if (inStr.length() != 0) {
                ++nonBl;
            }
            inArr[i] = inStr;
        }
        if (nonBl == inArr.length) {
            return inArr;
        }
        String[] outArr = new String[nonBl];
        nonBl = 0;
        for (int i = 0; i < inArr.length; ++i) {
            String inStr = inArr[i].trim();
            if (inStr.length() == 0) continue;
            outArr[nonBl] = inStr;
            ++nonBl;
        }
        return outArr;
    }

    public static String join(String token, String[] strings) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < strings.length; ++x) {
            if (strings[x] != null) {
                sb.append(strings[x]);
            }
            if (x >= strings.length - 1) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    private static void printArr(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            System.out.print(arr[i]);
            if (i == arr.length - 1) continue;
            System.out.print(" . ");
        }
        System.out.println();
    }

    public static void main(String[] argv) {
        String s1 = "aaa.bbb.ccc";
        String s2 = "aaa..";
        String s3 = "...";
        String token = ".";
        SmartStringArray.printArr(SmartStringArray.split(token, s1));
        SmartStringArray.printArr(SmartStringArray.split(token, s2));
        SmartStringArray.printArr(SmartStringArray.split(token, s3));
    }
}

