/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

public class GribTables {
    public static String getLevel(int pds9, int pds10, int pds11) {
        int pds1011 = pds10 << 8 | pds11;
        switch (pds9) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud base level";
            }
            case 3: {
                return "cloud top level";
            }
            case 4: {
                return "0 degree isotherm level";
            }
            case 5: {
                return "condensation level";
            }
            case 6: {
                return "maximum wind speed level";
            }
            case 7: {
                return "tropopause level";
            }
            case 8: {
                return "nominal atmosphere top";
            }
            case 9: {
                return "sea bottom";
            }
            case 100: {
                return pds1011 + " mb";
            }
            case 101: {
                return pds10 + "-" + pds11 + " mb";
            }
            case 102: {
                return "mean sea level";
            }
            case 103: {
                return pds1011 + " m above mean sea level";
            }
            case 104: {
                return pds10 * 100 + "-" + pds11 * 100 + " m above mean sea level";
            }
            case 105: {
                return pds1011 + " m above ground";
            }
            case 106: {
                return pds10 * 100 + "-" + pds11 * 100 + " m above ground";
            }
            case 107: {
                return "sigma=" + (double)pds1011 / 10000.0;
            }
            case 108: {
                return "sigma " + (double)pds10 / 100.0 + "-" + (double)pds11 / 100.0;
            }
            case 109: {
                return "hybrid level " + pds1011;
            }
            case 110: {
                return "hybrid " + pds10 + "-" + pds11;
            }
            case 111: {
                return pds1011 + " cm below ground";
            }
            case 112: {
                return pds10 + "-" + pds11 + " cm down";
            }
            case 113: {
                return pds1011 + " K";
            }
            case 125: {
                return pds1011 + " cm above ground";
            }
            case 160: {
                return pds1011 + " m below sea level";
            }
            case 200: {
                return "entire atmoshere layer";
            }
            case 201: {
                return "entire ocean layer";
            }
        }
        return "";
    }
}

