/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import ucar.grib.Parameter;
import ucar.grib.grib1.SmartStringArray;

public class GribPDSParamTable {
    private static final int NPARAMETERS = 256;
    protected int center_id;
    protected int subcenter_id;
    protected int table_number;
    protected String filename = null;
    protected URL url = null;
    protected Parameter[] parameters = null;
    private static GribPDSParamTable[] paramTables = null;
    private static final String TABLE_DIRECTORY = "tables";
    private static final String TABLE_LIST = "tablelookup.lst";
    static /* synthetic */ Class class$ucar$grib$grib1$GribPDSParamTable;

    private static void readParameterTableLookup(String aGribTabURL, ArrayList aTables) throws IOException {
        GribPDSParamTable.readTableEntries(aGribTabURL, aTables);
    }

    private static void initFromJAR(ArrayList aTables) throws IOException {
        ClassLoader cl = (class$ucar$grib$grib1$GribPDSParamTable == null ? (class$ucar$grib$grib1$GribPDSParamTable = GribPDSParamTable.class$("ucar.grib.grib1.GribPDSParamTable")) : class$ucar$grib$grib1$GribPDSParamTable).getClassLoader();
        URL baseUrl = cl.getResource(TABLE_DIRECTORY);
        if (baseUrl == null) {
            return;
        }
        GribPDSParamTable.readTableEntries(baseUrl.toExternalForm(), aTables);
    }

    private static void initDefaultTableEntries(ArrayList aTables) {
        String[][] defaulttable_ncep_reanal2 = new String[][]{{"var0", "undefined", "undefined"}, {"pres", "Pressure", "Pa"}, {"prmsl", "Pressure reduced to MSL", "Pa"}, {"ptend", "Pressure tendency", "Pa/s"}, {"var4", "undefined", "undefined"}, {"var5", "undefined", "undefined"}, {"gp", "Geopotential", "m^2/s^2"}, {"hgt", "Geopotential height", "gpm"}, {"dist", "Geometric height", "m"}, {"hstdv", "Std dev of height", "m"}, {"hvar", "Varianance of height", "m^2"}, {"tmp", "Temperature", "K"}, {"vtmp", "Virtual temperature", "K"}, {"pot", "Potential temperature", "K"}, {"epot", "Pseudo-adiabatic pot. temperature", "K"}, {"tmax", "Max. temperature", "K"}, {"tmin", "Min. temperature", "K"}, {"dpt", "Dew point temperature", "K"}, {"depr", "Dew point depression", "K"}, {"lapr", "Lapse rate", "K/m"}, {"visib", "Visibility", "m"}, {"rdsp1", "Radar spectra (1)", ""}, {"rdsp2", "Radar spectra (2)", ""}, {"rdsp3", "Radar spectra (3)", ""}, {"var24", "undefined", "undefined"}, {"tmpa", "Temperature anomaly", "K"}, {"presa", "Pressure anomaly", "Pa"}, {"gpa", "Geopotential height anomaly", "gpm"}, {"wvsp1", "Wave spectra (1)", ""}, {"wvsp2", "Wave spectra (2)", ""}, {"wvsp3", "Wave spectra (3)", ""}, {"wdir", "Wind direction", "deg"}, {"wind", "Wind speed", "m/s"}, {"ugrd", "u wind", "m/s"}, {"vgrd", "v wind", "m/s"}, {"strm", "Stream function", "m^2/s"}, {"vpot", "Velocity potential", "m^2/s"}, {"mntsf", "Montgomery stream function", "m^2/s^2"}, {"sgcvv", "Sigma coord. vertical velocity", "/s"}, {"vvel", "Pressure vertical velocity", "Pa/s"}, {"dzdt", "Geometric vertical velocity", "m/s"}, {"absv", "Absolute vorticity", "/s"}, {"absd", "Absolute divergence", "/s"}, {"relv", "Relative vorticity", "/s"}, {"reld", "Relative divergence", "/s"}, {"vucsh", "Vertical u shear", "/s"}, {"vvcsh", "Vertical v shear", "/s"}, {"dirc", "Direction of current", "deg"}, {"spc", "Speed of current", "m/s"}, {"uogrd", "u of current", "m/s"}, {"vogrd", "v of current", "m/s"}, {"spfh", "Specific humidity", "kg/kg"}, {"rh", "Relative humidity", "%"}, {"mixr", "Humidity mixing ratio", "kg/kg"}, {"pwat", "Precipitable water", "kg/m^2"}, {"vapp", "Vapor pressure", "Pa"}, {"satd", "Saturation deficit", "Pa"}, {"evp", "Evaporation", "kg/m^2"}, {"cice", "Cloud Ice", "kg/m^2"}, {"prate", "Precipitation rate", "kg/m^2/s"}, {"tstm", "Thunderstorm probability", "%"}, {"apcp", "Total precipitation", "kg/m^2"}, {"ncpcp", "Large scale precipitation", "kg/m^2"}, {"acpcp", "Convective precipitation", "kg/m^2"}, {"srweq", "Snowfall rate water equiv.", "kg/m^2/s"}, {"weasd", "Accum. snow", "kg/m^2"}, {"snod", "Snow depth", "m"}, {"mixht", "Mixed layer depth", "m"}, {"tthdp", "Transient thermocline depth", "m"}, {"mthd", "Main thermocline depth", "m"}, {"mtha", "Main thermocline anomaly", "m"}, {"tcdc", "Total cloud cover", "%"}, {"cdcon", "Convective cloud cover", "%"}, {"lcdc", "Low level cloud cover", "%"}, {"mcdc", "Mid level cloud cover", "%"}, {"hcdc", "High level cloud cover", "%"}, {"cwat", "Cloud water", "kg/m^2"}, {"var77", "undefined", "undefined"}, {"snoc", "Convective snow", "kg/m^2"}, {"snol", "Large scale snow", "kg/m^2"}, {"wtmp", "Water temperature", "K"}, {"land", "Land cover (land=1;sea=0)", "fraction"}, {"dslm", "Deviation of sea level from mean", "m"}, {"sfcr", "Surface roughness", "m"}, {"albdo", "Albedo", "%"}, {"tsoil", "Soil temperature", "K"}, {"soilm", "Soil moisture content", "kg/m^2"}, {"veg", "Vegetation", "%"}, {"salty", "Salinity", "kg/kg"}, {"den", "Density", "kg/m^3"}, {"runof", "Runoff", "kg/m^2"}, {"icec", "Ice concentration (ice=1;no ice=0)", "fraction"}, {"icetk", "Ice thickness", "m"}, {"diced", "Direction of ice drift", "deg"}, {"siced", "Speed of ice drift", "m/s"}, {"uice", "u of ice drift", "m/s"}, {"vice", "v of ice drift", "m/s"}, {"iceg", "Ice growth rate", "m/s"}, {"iced", "Ice divergence", "/s"}, {"snom", "Snow melt", "kg/m^2"}, {"htsgw", "Sig height of wind waves and swell", "m"}, {"wvdir", "Direction of wind waves", "deg"}, {"wvhgt", "Sig height of wind waves", "m"}, {"wvper", "Mean period of wind waves", "s"}, {"swdir", "Direction of swell waves", "deg"}, {"swell", "Sig height of swell waves", "m"}, {"swper", "Mean period of swell waves", "s"}, {"dirpw", "Primary wave direction", "deg"}, {"perpw", "Primary wave mean period", "s"}, {"dirsw", "Secondary wave direction", "deg"}, {"persw", "Secondary wave mean period", "s"}, {"nswrs", "Net short wave (surface)", "W/m^2"}, {"nlwrs", "Net long wave (surface)", "W/m^2"}, {"nswrt", "Net short wave (top)", "W/m^2"}, {"nlwrt", "Net long wave (top)", "W/m^2"}, {"lwavr", "Long wave", "W/m^2"}, {"swavr", "Short wave", "W/m^2"}, {"grad", "Global radiation", "W/m^2"}, {"var118", "undefined", "undefined"}, {"var119", "undefined", "undefined"}, {"var120", "undefined", "undefined"}, {"lhtfl", "Latent heat flux", "W/m^2"}, {"shtfl", "Sensible heat flux", "W/m^2"}, {"blydp", "Boundary layer dissipation", "W/m^2"}, {"uflx", "Zonal momentum flux", "N/m^2"}, {"vflx", "Meridional momentum flux", "N/m^2"}, {"wmixe", "Wind mixing energy", "J"}, {"imgd", "Image data", ""}, {"mslsa", "Mean sea level pressure (Std Atm)", "Pa"}, {"mslma", "Mean sea level pressure (MAPS)", "Pa"}, {"mslet", "Mean sea level pressure (ETA model)", "Pa"}, {"lftx", "Surface lifted index", "K"}, {"4lftx", "Best (4-layer) lifted index", "K"}, {"kx", "K index", "K"}, {"sx", "Sweat index", "K"}, {"mconv", "Horizontal moisture divergence", "kg/kg/s"}, {"vssh", "Vertical speed shear", "1/s"}, {"tslsa", "3-hr pressure tendency (Std Atmos Red)", "Pa/s"}, {"bvf2", "Brunt-Vaisala frequency^2", "1/s^2"}, {"pvmw", "Potential vorticity (mass-weighted)", "1/s/m"}, {"crain", "Categorical rain", "yes=1;no=0"}, {"cfrzr", "Categorical freezing rain", "yes=1;no=0"}, {"cicep", "Categorical ice pellets", "yes=1;no=0"}, {"csnow", "Categorical snow", "yes=1;no=0"}, {"soilw", "Volumetric soil moisture", "fraction"}, {"pevpr", "Potential evaporation rate", "W/m^2"}, {"cwork", "Cloud work function", "J/kg"}, {"u-gwd", "Zonal gravity wave stress", "N/m^2"}, {"v-gwd", "Meridional gravity wave stress", "N/m^2"}, {"pvort", "Potential vorticity", "m^2/s/kg"}, {"var150", "undefined", "undefined"}, {"var151", "undefined", "undefined"}, {"var152", "undefined", "undefined"}, {"mfxdv", "Moisture flux divergence", "gr/gr*m/s/m"}, {"vqr154", "undefined", "undefined"}, {"gflux", "Ground heat flux", "W/m^2"}, {"cin", "Convective inhibition", "J/kg"}, {"cape", "Convective Avail. Pot. Energy", "J/kg"}, {"tke", "Turbulent kinetic energy", "J/kg"}, {"condp", "Lifted parcel condensation pressure", "Pa"}, {"csusf", "Clear sky upward solar flux", "W/m^2"}, {"csdsf", "Clear sky downward solar flux", "W/m^2"}, {"csulf", "Clear sky upward long wave flux", "W/m^2"}, {"csdlf", "Clear sky downward long wave flux", "W/m^2"}, {"cfnsf", "Cloud forcing net solar flux", "W/m^2"}, {"cfnlf", "Cloud forcing net long wave flux", "W/m^2"}, {"vbdsf", "Visible beam downward solar flux", "W/m^2"}, {"vddsf", "Visible diffuse downward solar flux", "W/m^2"}, {"nbdsf", "Near IR beam downward solar flux", "W/m^2"}, {"nddsf", "Near IR diffuse downward solar flux", "W/m^2"}, {"ustr", "U wind stress", "N/m^2"}, {"vstr", "V wind stress", "N/m^2"}, {"mflx", "Momentum flux", "N/m^2"}, {"lmh", "Mass point model surface", ""}, {"lmv", "Velocity point model surface", ""}, {"sglyr", "Neraby model level", ""}, {"nlat", "Latitude", "deg"}, {"nlon", "Longitude", "deg"}, {"umas", "Mass weighted u", "gm/m*K*s"}, {"vmas", "Mass weigtted v", "gm/m*K*s"}, {"var180", "undefined", "undefined"}, {"lpsx", "x-gradient of log pressure", "1/m"}, {"lpsy", "y-gradient of log pressure", "1/m"}, {"hgtx", "x-gradient of height", "m/m"}, {"hgty", "y-gradient of height", "m/m"}, {"stdz", "Standard deviation of Geop. hgt.", "m"}, {"stdu", "Standard deviation of zonal wind", "m/s"}, {"stdv", "Standard deviation of meridional wind", "m/s"}, {"stdq", "Standard deviation of spec. hum.", "gm/gm"}, {"stdt", "Standard deviation of temperature", "K"}, {"cbuw", "Covariance between u and omega", "m/s*Pa/s"}, {"cbvw", "Covariance between v and omega", "m/s*Pa/s"}, {"cbuq", "Covariance between u and specific hum", "m/s*gm/gm"}, {"cbvq", "Covariance between v and specific hum", "m/s*gm/gm"}, {"cbtw", "Covariance between T and omega", "K*Pa/s"}, {"cbqw", "Covariance between spec. hum and omeg", "gm/gm*Pa/s"}, {"cbmzw", "Covariance between v and u", "m^2/si^2"}, {"cbtzw", "Covariance between u and T", "K*m/s"}, {"cbtmw", "Covariance between v and T", "K*m/s"}, {"stdrh", "Standard deviation of Rel. Hum.", "%"}, {"sdtz", "Std dev of time tend of geop. hgt", "m"}, {"icwat", "Ice-free water surface", "%"}, {"sdtu", "Std dev of time tend of zonal wind", "m/s"}, {"sdtv", "Std dev of time tend of merid wind", "m/s"}, {"dswrf", "Downward solar radiation flux", "W/m^2"}, {"dlwrf", "Downward long wave radiation flux", "W/m^2"}, {"sdtq", "Std dev of time tend of spec. hum", "gm/gm"}, {"mstav", "Moisture availability", "%"}, {"sfexc", "Exchange coefficient", "(kg/m^3)(m/s)"}, {"mixly", "No. of mixed layers next to surface", "integer"}, {"sdtt", "Std dev of time tend of temperature", "K"}, {"uswrf", "Upward short wave flux", "W/m^2"}, {"ulwrf", "Upward long wave flux", "W/m^2"}, {"cdlyr", "Non-convective cloud", "%"}, {"cprat", "Convective precip. rate", "kg/m^2/s"}, {"ttdia", "Temperature tendency by all physics", "K/s"}, {"ttrad", "Temperature tendency by all radiation", "K/s"}, {"ttphy", "Temperature tendency by non-radiation physics", "K/s"}, {"preix", "Precip index (0.0-1.00)", "fraction"}, {"tsd1d", "Std. dev. of IR T over 1x1 deg area", "K"}, {"nlgsp", "Natural log of surface pressure", "ln(kPa)"}, {"sdtrh", "Std dev of time tend of rel humt", "%"}, {"5wavh", "5-wave geopotential height", "gpm"}, {"cwat", "Plant canopy surface water", "kg/m^2"}, {"pltrs", "Maximum stomato plant resistance", "s/m"}, {"rhcld", "RH-type cloud cover", "%"}, {"bmixl", "Blackadar's mixing length scale", "m"}, {"amixl", "Asymptotic mixing length scale", "m"}, {"pevap", "Potential evaporation", "kg^2"}, {"snohf", "Snow melt heat flux", "W/m^2"}, {"snoev", "Snow sublimation heat flux", "W/m^2"}, {"mflux", "Convective cloud mass flux", "Pa/s"}, {"dtrf", "Downward total radiation flux", "W/m^2"}, {"utrf", "Upward total radiation flux", "W/m^2"}, {"bgrun", "Baseflow-groundwater runoff", "kg/m^2"}, {"ssrun", "Storm surface runoff", "kg/m^2"}, {"var236", "undefined", "undefined"}, {"ozone", "Total column ozone concentration", "Dobson"}, {"snoc", "Snow cover", "%"}, {"snot", "Snow temperature", "K"}, {"glcr", "Permanent snow points", "mask"}, {"lrghr", "Large scale condensation heating rate", "K/s"}, {"cnvhr", "Deep convective heating rate", "K/s"}, {"cnvmr", "Deep convective moistening rate", "kg/kg/s"}, {"shahr", "Shallow convective heating rate", "K/s"}, {"shamr", "Shallow convective moistening rate", "kg/kg/s"}, {"vdfhr", "Vertical diffusion heating rate", "K/s"}, {"vdfua", "Vertical diffusion zonal accel", "m/s/s"}, {"vdfva", "Vertical diffusion meridional accel", "m/s/s"}, {"vdfmr", "Vertical diffusion moistening rate", "kg/kg/s"}, {"swhr", "Solar radiative heating rate", "K/s"}, {"lwhr", "Longwave radiative heating rate", "K/s"}, {"cd", "Drag coefficient", ""}, {"fricv", "Friction velocity", "m/s"}, {"ri", "Richardson number", ""}, {"var255", "undefined", "undifined"}};
        int npar = defaulttable_ncep_reanal2.length;
        Parameter[] parameters = new Parameter[npar];
        for (int n = 0; n < npar; ++n) {
            String pname = defaulttable_ncep_reanal2[n][0];
            String pdesc = defaulttable_ncep_reanal2[n][1];
            String punit = defaulttable_ncep_reanal2[n][2];
            parameters[n] = new Parameter(n, pname, pdesc, punit);
        }
        aTables.add(new GribPDSParamTable("ncep_reanal2.1", 7, -1, 1, parameters));
        aTables.add(new GribPDSParamTable("ncep_reanal2.2", 7, -1, 2, parameters));
        aTables.add(new GribPDSParamTable("ncep_reanal2.3", 7, -1, 3, parameters));
        aTables.add(new GribPDSParamTable("ncep_reanal2.4", 81, -1, 3, parameters));
        aTables.add(new GribPDSParamTable("ncep_reanal2.5", 88, -1, 2, parameters));
    }

    private GribPDSParamTable() {
    }

    private GribPDSParamTable(String name, int cen, int sub, int tab, Parameter[] par) {
        this.filename = name;
        this.center_id = cen;
        this.subcenter_id = sub;
        this.table_number = tab;
        this.url = null;
        this.parameters = par;
    }

    private static void readTableEntries(String aBaseUrl, ArrayList aTables) throws IOException {
        String line;
        InputStream is = new URL(aBaseUrl + "/" + TABLE_LIST).openStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null && line.length() != 0) {
            GribPDSParamTable table = new GribPDSParamTable();
            String[] tableDefArr = SmartStringArray.split(":", line);
            table.center_id = Integer.parseInt(tableDefArr[0].trim());
            table.subcenter_id = Integer.parseInt(tableDefArr[1].trim());
            table.table_number = Integer.parseInt(tableDefArr[2].trim());
            table.filename = tableDefArr[3].trim();
            table.url = new URL(aBaseUrl + "/" + table.filename);
            aTables.add(table);
        }
        is.close();
    }

    public static GribPDSParamTable getParameterTable(int center, int subcenter, int number) {
        for (int i = 0; i < paramTables.length; ++i) {
            GribPDSParamTable table = paramTables[i];
            if (center != table.center_id || table.subcenter_id != -1 && subcenter != table.subcenter_id || number != table.table_number) continue;
            if (table.parameters == null) {
                table.parameters = new Parameter[256];
                table.readParameterTable();
            }
            return table;
        }
        System.out.println("cent, sub, tab: " + center + " " + subcenter + " " + number);
        return null;
    }

    public Parameter getParameter(int id) {
        return this.parameters[id];
    }

    public String getParameterTag(int id) {
        return this.parameters[id].getName();
    }

    public String getParameterDescription(int id) {
        return this.parameters[id].getDescription();
    }

    public String getParameterUnit(int id) {
        return this.parameters[id].getUnit();
    }

    private void readParameterTable() {
        try {
            BufferedReader br;
            if (this.url != null) {
                InputStream is = this.url.openStream();
                InputStreamReader isr = new InputStreamReader(is);
                br = new BufferedReader(isr);
            } else {
                br = new BufferedReader(new FileReader("tables\\" + this.filename));
            }
            String line = br.readLine();
            String[] tableDefArr = SmartStringArray.split(":", line);
            int center = Integer.parseInt(tableDefArr[1].trim());
            int subcenter = Integer.parseInt(tableDefArr[2].trim());
            int number = Integer.parseInt(tableDefArr[3].trim());
            if (center != this.center_id && subcenter != this.subcenter_id && number != this.table_number) {
                throw new IOException("parameter table header values do not  match values in GRIB file.  Possible error in lookup table.");
            }
            int i = 0;
            while ((line = br.readLine()) != null && line.length() != 0) {
                Parameter parameter = new Parameter();
                tableDefArr = SmartStringArray.split(":", line);
                parameter.setNumber(Integer.parseInt(tableDefArr[0].trim()));
                parameter.setName(tableDefArr[1].trim());
                if (tableDefArr[2].indexOf(91) == -1) {
                    parameter.setDescription(tableDefArr[2].trim());
                    parameter.setUnit(tableDefArr[2].trim());
                } else {
                    String[] arr2 = SmartStringArray.split("[", tableDefArr[2]);
                    parameter.setDescription(arr2[0].trim());
                    parameter.setUnit(arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim());
                }
                this.parameters[i++] = parameter;
            }
        }
        catch (IOException ioError) {
            System.err.println("An error occurred in GribPDSParamTable while trying to open the parameter table " + this.filename + " : " + ioError);
        }
    }

    public String toString() {
        String str = "-1:" + this.center_id + ":" + this.subcenter_id + ":" + this.table_number + "\n";
        for (int i = 0; i < this.parameters.length; ++i) {
            str = str + this.parameters[i].toString();
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ArrayList tables = new ArrayList();
            GribPDSParamTable.initDefaultTableEntries(tables);
            GribPDSParamTable.initFromJAR(tables);
            if (tables.size() == 0) {
                String gribtab = System.getProperty("GribTabURL");
                System.out.println("GribTabURL=" + gribtab);
                if (gribtab != null) {
                    try {
                        GribPDSParamTable.readParameterTableLookup(gribtab, tables);
                    }
                    catch (IOException e) {
                        System.err.println(e);
                    }
                }
            }
            paramTables = tables.toArray(new GribPDSParamTable[tables.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

