/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

public class GribPDSLevel {
    private int index;
    private String name = null;
    private float value1;
    private float value2;
    private String level = "";
    private String description = "";
    private String units = "";
    private boolean isSingleLayer = true;
    private boolean isIncreasingUp = true;
    private boolean isNumeric = false;

    public GribPDSLevel(int pds10, int pds11, int pds12) {
        int pds1112 = pds11 << 8 | pds12;
        this.index = pds10;
        switch (this.index) {
            case 1: {
                this.level = "surface";
                this.description = "surface";
                this.name = "surface";
                break;
            }
            case 2: {
                this.level = "cloud base level";
                this.description = "cloud base level";
                this.name = "cloud base level";
                break;
            }
            case 3: {
                this.level = "cloud top level";
                this.description = "cloud top level";
                this.name = "cloud top level";
                break;
            }
            case 4: {
                this.level = "0 degree isotherm level";
                this.description = "0 degree isotherm level";
                this.name = "0 degree isotherm level";
                break;
            }
            case 5: {
                this.level = "condensation level";
                this.description = "condensation level";
                this.name = "condensation level";
                break;
            }
            case 6: {
                this.level = "maximum wind level";
                this.description = "maximum wind level";
                this.name = "maximum wind level";
                break;
            }
            case 7: {
                this.level = "tropopause level";
                this.description = "tropopause level";
                this.name = "tropopause level";
                break;
            }
            case 8: {
                this.level = "nominal atmosphere top";
                this.description = "nominal atmosphere top";
                this.name = "nominal atmosphere top";
                break;
            }
            case 9: {
                this.level = "sea bottom";
                this.description = "sea bottom";
                this.name = "sea bottom";
                break;
            }
            case 20: {
                this.name = "Isothermal level";
                this.value1 = pds1112;
                this.units = "K";
                this.isNumeric = true;
                this.level = this.value1 + " K";
                this.description = "Isothermal level at " + this.value1 / 100.0f + this.units;
                break;
            }
            case 100: {
                this.name = "isobaric";
                this.value1 = pds1112;
                this.units = "hPa";
                this.isNumeric = true;
                this.isIncreasingUp = false;
                this.isSingleLayer = false;
                this.level = pds1112 + " " + this.units;
                this.description = "pressure at " + this.value1 + " " + this.units;
                break;
            }
            case 101: {
                this.name = "layer between two isobaric levels";
                this.value1 = pds11 * 10;
                this.value2 = pds12 * 10;
                this.units = "hPa";
                this.level = this.value1 + " - " + this.value2 + " " + this.units;
                this.description = "layer between " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 102: {
                this.level = "mean sea level";
                this.description = "mean sea level";
                this.name = "mean sea level";
                break;
            }
            case 103: {
                this.name = "Altitude above MSL";
                this.value1 = pds1112;
                this.units = "m";
                this.isNumeric = true;
                this.isSingleLayer = false;
                this.level = pds1112 + " " + this.units;
                this.description = this.value1 + " m above mean sea level";
                break;
            }
            case 104: {
                this.name = "Layer between two altitudes above MSL";
                this.value1 = pds11 * 100;
                this.value2 = pds12 * 100;
                this.units = "m";
                this.level = this.value1 + "-" + this.value2 + " " + this.units;
                this.description = "Layer between " + pds11 + " and " + pds12 + " m above mean sea level";
                break;
            }
            case 105: {
                this.name = "fixed height above ground";
                this.value1 = pds1112;
                this.units = "m";
                this.isNumeric = true;
                this.isSingleLayer = false;
                this.level = this.value1 + this.units;
                this.description = this.value1 + " m above ground";
                break;
            }
            case 106: {
                this.name = "layer between two height levels";
                this.value1 = pds11 * 100;
                this.value2 = pds12 * 100;
                this.units = "m";
                this.isNumeric = true;
                this.level = this.value1 + "-" + this.value2 + " m";
                this.description = "Layer between " + this.value1 + " and " + this.value2 + " m above ground";
                break;
            }
            case 107: {
                this.name = "Sigma level";
                this.value1 = (float)pds1112 / 10000.0f;
                this.level = "sigma=" + this.value1;
                this.units = "sigma";
                this.isNumeric = true;
                this.isSingleLayer = false;
                this.isIncreasingUp = false;
                this.description = "sigma = " + this.value1 + " " + this.units;
                break;
            }
            case 108: {
                this.name = "Layer between two sigma layers";
                this.value1 = (float)pds11 / 100.0f;
                this.value2 = (float)pds12 / 100.0f;
                this.isNumeric = true;
                this.level = "sigma " + this.value1 + "-" + this.value2;
                this.description = "Layer between sigma levels " + this.value1 + " and " + this.value2;
                break;
            }
            case 109: {
                this.name = "hybrid level";
                this.value1 = pds1112;
                this.isNumeric = true;
                this.level = "hybrid level " + this.value1;
                this.description = "hybrid level " + this.value1;
                break;
            }
            case 110: {
                this.name = "Layer between two hybrid levels";
                this.value1 = pds11;
                this.value2 = pds12;
                this.isNumeric = true;
                this.level = "hybrid " + this.value1 + "-" + this.value2;
                this.description = "Layer between hybrid levels " + this.value1 + " and " + this.value2;
                break;
            }
            case 111: {
                this.name = "Depth below land surface";
                this.value1 = pds1112;
                this.units = "cm";
                this.isNumeric = true;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units;
                break;
            }
            case 112: {
                this.name = "Layer between two levels below land surface";
                this.value1 = pds11;
                this.value2 = pds12;
                this.units = "cm";
                this.isNumeric = true;
                this.level = this.value1 + " - " + this.value2 + " " + this.units;
                this.description = "Layer between " + this.value1 + " and " + this.value2 + " cm below land surface";
                break;
            }
            case 113: {
                this.name = "Isentropic (theta) level";
                this.value1 = pds1112;
                this.units = "K";
                this.isNumeric = true;
                this.isSingleLayer = false;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units;
                break;
            }
            case 114: {
                this.name = "Layer between two isentropic layers";
                this.value1 = pds11 + 475;
                this.value2 = pds12 + 475;
                this.units = "K";
                this.isNumeric = true;
                this.description = "Layer between " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 115: {
                this.name = "level at specified pressure difference from ground to level";
                this.value1 = pds1112;
                this.units = "hPa";
                this.isNumeric = true;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units;
                break;
            }
            case 116: {
                this.name = "Layer between pressure differences from ground to levels";
                this.value1 = pds11;
                this.value2 = pds12;
                this.units = "hPa";
                this.isNumeric = true;
                this.level = this.value1 + this.units + " - " + this.value2 + this.units;
                this.description = "Layer between pressure differences from ground: " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 117: {
                this.name = "potential vorticity(pv) surface";
                this.value1 = pds1112;
                this.units = "10-6Km2/kgs";
                this.isNumeric = true;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units + " surface";
                break;
            }
            case 119: {
                this.name = "Eta level";
                this.value1 = pds1112;
                this.units = "";
                this.isNumeric = true;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units;
                break;
            }
            case 120: {
                this.name = "layer between two Eta levels";
                this.value1 = pds11;
                this.value2 = pds12;
                this.units = "";
                this.isNumeric = true;
                this.level = this.value1 + this.units + " - " + this.value2 + this.units;
                this.description = "layer between two Eta levels : " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 121: {
                this.name = "layer between two isobaric surfaces";
                this.value1 = pds11;
                this.value2 = pds12;
                this.units = "hPa";
                this.isNumeric = true;
                this.level = this.value1 + this.units + " - " + this.value2 + this.units;
                this.description = "layer between two isobaric surfaces : " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 125: {
                this.name = "Height above ground (high precision)";
                this.value1 = pds1112;
                this.units = "cm";
                this.isNumeric = true;
                this.isSingleLayer = false;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units + " above ground";
                break;
            }
            case 126: {
                this.name = "isobaric level";
                this.value1 = pds1112;
                this.units = "Pa";
                this.isNumeric = true;
                this.isSingleLayer = false;
                this.level = this.value1 + " " + this.units;
                this.description = this.value1 + " " + this.units + " above surface";
                break;
            }
            case 128: {
                this.name = "layer between two sigma levels";
                this.value1 = pds11;
                this.value2 = pds12;
                this.units = "sigma";
                this.isNumeric = true;
                this.level = this.value1 + this.units + " - " + this.value2 + this.units;
                this.description = "layer between two sigma levels : " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 141: {
                this.name = "layer between two isobaric surfaces";
                this.value1 = pds11;
                this.value2 = pds12;
                this.units = "hPa";
                this.isNumeric = true;
                this.level = this.value1 + this.units + " - " + this.value2 + this.units;
                this.description = "layer between two isobaric surfaces : " + this.value1 + " and " + this.value2 + " " + this.units;
                break;
            }
            case 160: {
                this.name = "Depth below sea level";
                this.value1 = pds1112;
                this.units = "m";
                this.isNumeric = true;
                this.level = this.value1 + " m below sea level";
                this.description = pds1112 + " m below sea level";
                break;
            }
            case 200: {
                this.level = "entire atmosphere layer";
                this.description = "entire atmosphere layer";
                this.name = "entire atmosphere layer";
                break;
            }
            case 201: {
                this.level = "entire ocean layer";
                this.description = "entire ocean layer";
                this.name = "entire ocean layer";
                break;
            }
            case 204: {
                this.level = "Highest tropospheric freezing level";
                this.description = "Highest tropospheric freezing level";
                this.name = "Highest tropospheric freezing level";
                break;
            }
            case 206: {
                this.level = "Grid scale cloud bottom level";
                this.description = "Grid scale cloud bottom level";
                this.name = "Grid scale cloud bottom level";
                break;
            }
            case 207: {
                this.level = "Grid scale cloud top level";
                this.description = "Grid scale cloud top level";
                this.name = "Grid scale cloud top level";
                break;
            }
            case 209: {
                this.level = "Boundary layer cloud bottom level";
                this.description = "Boundary layer cloud bottom level";
                this.name = "Boundary layer cloud bottom level";
                break;
            }
            case 210: {
                this.level = "Boundary layer cloud top level";
                this.description = "Boundary layer cloud top level";
                this.name = "Boundary layer cloud top level";
                break;
            }
            case 211: {
                this.level = "Boundary layer cloud layer";
                this.description = "Boundary layer cloud layer";
                this.name = "Boundary layer cloud layer";
                break;
            }
            case 212: {
                this.level = "Low cloud bottom level";
                this.description = "Low cloud bottom level";
                this.name = "Low cloud bottom level";
                break;
            }
            case 213: {
                this.level = "Low cloud top level";
                this.description = "Low cloud top level";
                this.name = "Low cloud top level";
                break;
            }
            case 214: {
                this.level = "Low Cloud Layer";
                this.description = "Low Cloud Layer";
                this.name = "Low Cloud Layer";
                break;
            }
            case 222: {
                this.level = "Middle cloud bottom level";
                this.description = "Middle cloud bottom level";
                this.name = "Middle cloud bottom level";
                break;
            }
            case 223: {
                this.level = "Middle cloud top level";
                this.description = "Middle cloud top level";
                this.name = "Middle cloud top level";
                break;
            }
            case 224: {
                this.level = "Middle Cloud Layer";
                this.description = "Middle Cloud Layer";
                this.name = "Middle Cloud Layer";
                break;
            }
            case 232: {
                this.level = "High cloud bottom level";
                this.description = "High cloud bottom level";
                this.name = "High cloud bottom level";
                break;
            }
            case 233: {
                this.level = "High cloud top level";
                this.description = "High cloud top level";
                this.name = "High cloud top level";
                break;
            }
            case 234: {
                this.level = "High Cloud Layer";
                this.description = "High Cloud Layer";
                this.name = "High Cloud Layer";
                break;
            }
            case 242: {
                this.level = "Convective cloud bottom level";
                this.description = "Convective cloud bottom level";
                this.name = "Convective cloud bottom level";
                break;
            }
            case 243: {
                this.level = "Convective cloud top level";
                this.description = "Convective cloud top level";
                this.name = "Convective cloud top level";
                break;
            }
            case 244: {
                this.level = "Convective cloud layer";
                this.description = "Convective cloud layer";
                this.name = "Convective cloud layer";
                break;
            }
            case 245: {
                this.level = "Lowest level of the wet bulb zero";
                this.description = "Lowest level of the wet bulb zero";
                this.name = "Lowest level of the wet bulb zero";
                break;
            }
            case 246: {
                this.level = "Maximum equivalent potential temperature level";
                this.description = "Maximum equivalent potential temperature level";
                this.name = "Maximum equivalent potential temperature level";
                break;
            }
            case 247: {
                this.level = "Equilibrium level";
                this.description = "Equilibrium level";
                this.name = "Equilibrium level";
                break;
            }
            case 248: {
                this.level = "Shallow convective cloud bottom level";
                this.description = "Shallow convective cloud bottom level";
                this.name = "Shallow convective cloud bottom level";
                break;
            }
            case 249: {
                this.level = "Shallow convective cloud top level";
                this.description = "Shallow convective cloud top level";
                this.name = "Shallow convective cloud top level";
                break;
            }
            case 251: {
                this.level = "Deep convective cloud bottom level";
                this.description = "Deep convective cloud bottom level";
                this.name = "Deep convective cloud bottom level";
                break;
            }
            case 252: {
                this.level = "Deep convective cloud top level";
                this.description = "Deep convective cloud top level";
                this.name = "Deep convective cloud top level";
                break;
            }
            default: {
                this.description = "undefined level";
                this.name = "undefined level";
                this.units = "undefined units";
                System.out.println("GribPDSLevel: Table 3 level " + this.index + " is not implemented yet");
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static String getNameShort(int id) {
        switch (id) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "isobaric";
            }
            case 101: {
                return "layer_between_two_isobaric";
            }
            case 102: {
                return "msl";
            }
            case 103: {
                return "altitude_above_msl";
            }
            case 104: {
                return "layer_between_two_altitudes_above_msl";
            }
            case 105: {
                return "height_above_ground";
            }
            case 106: {
                return "layer_between_two_heights_above_ground";
            }
            case 107: {
                return "sigma";
            }
            case 108: {
                return "layer_between_two_sigmas";
            }
            case 109: {
                return "hybrid";
            }
            case 110: {
                return "layer_between_two_hybrids";
            }
            case 111: {
                return "depth_below_surface";
            }
            case 112: {
                return "layer_between_two_depths_below_surface";
            }
            case 113: {
                return "isentrope";
            }
            case 114: {
                return "layer_between_two_isentrope";
            }
            case 115: {
                return "pressure_difference";
            }
            case 116: {
                return "layer_between_two_pressure_difference_from_ground";
            }
            case 117: {
                return "potential_vorticity_surface";
            }
            case 119: {
                return "eta";
            }
            case 120: {
                return "layer_between_two_eta";
            }
            case 121: {
                return "layer_between_two_isobaric_surfaces";
            }
            case 125: {
                return "height_above_ground";
            }
            case 126: {
                return "isobaric";
            }
            case 128: {
                return "layer_between_two_sigmas";
            }
            case 141: {
                return "layer_between_two_isobaric_surfaces";
            }
            case 160: {
                return "depth_below_sea";
            }
            case 200: {
                return "entire_atmosphere";
            }
            case 201: {
                return "entire_ocean";
            }
            case 255: {
                return "";
            }
        }
        return "Unknown" + id;
    }

    public String getLevel() {
        return this.level;
    }

    public String getDesc() {
        return this.description;
    }

    public String getUnits() {
        return this.units;
    }

    public static String getUnits(int id) {
        switch (id) {
            case 20: 
            case 113: 
            case 114: {
                return "K";
            }
            case 100: 
            case 101: 
            case 115: 
            case 116: 
            case 121: 
            case 141: {
                return "hPa";
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 160: {
                return "m";
            }
            case 107: 
            case 108: 
            case 128: {
                return "sigma";
            }
            case 111: 
            case 112: 
            case 125: {
                return "cm";
            }
            case 117: {
                return "10-6Km2/kgs";
            }
            case 126: {
                return "Pa";
            }
        }
        return "";
    }

    public float getValue1() {
        return this.value1;
    }

    public float getValue2() {
        return this.value2;
    }

    public boolean getIsNumeric() {
        return this.isNumeric;
    }

    public boolean getIsIncreasingUp() {
        return this.isIncreasingUp;
    }

    public boolean getIsSingleLayer() {
        return this.isSingleLayer;
    }

    public String toString() {
        return "  Parameter:\n        parameter id: " + this.index + "\n" + "        name: " + this.name + "\n" + "        description: " + this.description + "\n" + "        units: " + this.units + "\n" + "        short descr: " + this.level + "\n" + "        increasing up?: " + this.isIncreasingUp + "\n" + "        single layer?: " + this.isSingleLayer + "\n" + "        value1: " + this.value1 + "\n" + "        value2: " + this.value2 + "\n";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GribPDSLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GribPDSLevel lvl = (GribPDSLevel)obj;
        if (this.index != lvl.getIndex()) {
            return false;
        }
        if (this.value1 != lvl.getValue1()) {
            return false;
        }
        return this.value2 == lvl.getValue2();
    }

    public int compare(GribPDSLevel level) {
        if (this.equals(level)) {
            return 0;
        }
        if (this.index > level.getIndex()) {
            return -1;
        }
        if (this.value1 > level.getValue1()) {
            return -1;
        }
        if (this.value2 > level.getValue2()) {
            return -1;
        }
        return 1;
    }
}

