/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.Parameter;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.unidata.io.RandomAccessFile;

public class Grib1ProductDefinitionSection {
    protected int length;
    protected int decscale;
    protected int grid_id;
    protected boolean gds_exists;
    protected boolean bms_exists;
    protected Parameter parameter;
    protected int parameterNumber;
    protected GribPDSLevel level;
    protected Calendar baseTime;
    protected StringBuffer referenceTime = new StringBuffer();
    protected int forecastTime1;
    protected int forecastTime2;
    protected String timeRange = null;
    protected String connector = null;
    protected int timeRangeValue;
    protected String tUnit = null;
    private int table_version;
    private int center_id;
    private int subcenter_id;
    private int process_id;
    private GribPDSParamTable parameter_table;

    public Grib1ProductDefinitionSection(RandomAccessFile raf) throws NoValidGribException, NotSupportedException, IOException {
        this.length = GribNumbers.uint3(raf);
        this.table_version = raf.read();
        this.center_id = raf.read();
        this.process_id = raf.read();
        this.grid_id = raf.read();
        int exists = raf.read();
        this.gds_exists = (exists & 0x80) == 128;
        this.bms_exists = (exists & 0x40) == 64;
        this.parameterNumber = raf.read();
        int levelType = raf.read();
        int levelValue1 = raf.read();
        int levelValue2 = raf.read();
        this.level = new GribPDSLevel(levelType, levelValue1, levelValue2);
        int year = raf.read();
        int month = raf.read();
        int day = raf.read();
        int hour = raf.read();
        int minute = raf.read();
        int fUnit = raf.read();
        int p1 = raf.read();
        int p2 = raf.read();
        switch (fUnit) {
            case 1: {
                this.tUnit = "1hour";
            }
            case 10: {
                this.forecastTime1 = p1;
                this.forecastTime2 = p2;
                this.tUnit = "3hours";
                break;
            }
            case 11: {
                this.forecastTime1 = p1;
                this.forecastTime2 = p2;
                this.tUnit = "6hours";
                break;
            }
            case 12: {
                this.forecastTime1 = p1;
                this.forecastTime2 = p2;
                this.tUnit = "12hours";
            }
        }
        this.timeRangeValue = raf.read();
        switch (this.timeRangeValue) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.timeRange = "product valid from ";
                this.connector = " to ";
                break;
            }
            case 3: {
                this.timeRange = "product is an average between ";
                this.connector = " and ";
                break;
            }
            case 4: {
                this.timeRange = "product is an accumulation from ";
                this.connector = " to ";
                break;
            }
            case 5: {
                this.timeRange = "product is the difference of ";
                this.connector = " minus ";
                break;
            }
            case 6: {
                this.timeRange = "product is an average from ";
                this.connector = " to ";
                break;
            }
            case 7: {
                this.timeRange = "product is an average from ";
                this.connector = " to ";
                break;
            }
            case 10: {
                break;
            }
            default: {
                System.err.println("PDS: Time Range Indicator " + this.timeRange + " is not yet supported - continuing, but time " + "of data is not valid");
            }
        }
        int avgInclude = GribNumbers.int2(raf);
        int avgMissing = raf.read();
        int century = raf.read() - 1;
        this.subcenter_id = raf.read();
        this.decscale = GribNumbers.int2(raf);
        this.baseTime = new GregorianCalendar(century * 100 + year, month - 1, day, hour, minute);
        this.referenceTime.append(this.baseTime.get(1));
        this.referenceTime.append("-");
        this.referenceTime.append(this.baseTime.get(2) + 1);
        this.referenceTime.append("-");
        this.referenceTime.append(this.baseTime.get(5));
        this.referenceTime.append("T");
        this.referenceTime.append(this.baseTime.get(11));
        this.referenceTime.append(":");
        this.referenceTime.append(this.baseTime.get(12));
        this.referenceTime.append(":00Z");
        this.parameter_table = GribPDSParamTable.getParameterTable(this.center_id, this.subcenter_id, this.table_version);
        this.parameter = this.parameter_table.getParameter(this.parameterNumber);
    }

    public int getLength() {
        return this.length;
    }

    public boolean gdsExists() {
        return this.gds_exists;
    }

    public boolean bmsExists() {
        return this.bms_exists;
    }

    public int getCenter() {
        return this.center_id;
    }

    public int getProcess_Id() {
        return this.process_id;
    }

    public int getGrid_Id() {
        return this.grid_id;
    }

    public String getCenter_idName() {
        switch (this.center_id) {
            case 0: {
                return "WMO Secretariat";
            }
            case 1: 
            case 2: {
                return "Melbourne";
            }
            case 4: 
            case 5: {
                return "Moscow";
            }
            case 7: {
                return "US National Weather Service (NCEP)";
            }
            case 8: {
                return "US National Weather Service (NWSTG)";
            }
            case 9: {
                return "US National Weather Service (other)";
            }
            case 10: {
                return "Cairo (RSMC/RAFC)";
            }
            case 12: {
                return "Dakar (RSMC/RAFC)";
            }
            case 14: {
                return "Nairobi (RSMC/RAFC)";
            }
            case 16: {
                return "Atananarivo (RSMC)";
            }
            case 18: {
                return "Tunis Casablanca (RSMC)";
            }
            case 20: {
                return "Las Palmas (RAFC)";
            }
            case 21: {
                return "Algiers (RSMC)";
            }
            case 22: {
                return "Lagos (RSMC)";
            }
            case 24: {
                return "Pretoria (RSMC)";
            }
            case 25: {
                return "La R?union (RSMC)";
            }
            case 26: {
                return "Khabarovsk (RSMC)";
            }
            case 28: {
                return "New Delhi (RSMC/RAFC)";
            }
            case 30: {
                return "Novosibirsk (RSMC)";
            }
            case 32: {
                return "Tashkent (RSMC)";
            }
            case 33: {
                return "Jeddah (RSMC)";
            }
            case 34: {
                return "Tokyo (RSMC), Japan Meteorological Agency";
            }
            case 36: {
                return "Bangkok";
            }
            case 37: {
                return "Ulan Bator";
            }
            case 38: {
                return "Beijing (RSMC)";
            }
            case 40: {
                return "Seoul";
            }
            case 41: {
                return "Buenos Aires (RSMC/RAFC)";
            }
            case 43: {
                return "Brasilia (RSMC/RAFC)";
            }
            case 45: {
                return "Santiago";
            }
            case 46: {
                return "Brazilian Space Agency ? INPE";
            }
            case 51: {
                return "Miami (RSMC/RAFC)";
            }
            case 52: {
                return "Miami RSMC, National Hurricane Center";
            }
            case 53: 
            case 54: {
                return "Montreal (RSMC)";
            }
            case 55: {
                return "San Francisco";
            }
            case 57: {
                return "U.S. Air Force Air Force Global Weather Central";
            }
            case 58: {
                return "Fleet Numerical Meteorology and Oceanography Center";
            }
            case 59: {
                return "The NOAA Forecast Systems Laboratory";
            }
            case 60: {
                return "United States National Centre for Atmospheric Research (NCAR)";
            }
            case 64: {
                return "Honolulu";
            }
            case 65: {
                return "Darwin (RSMC)";
            }
            case 67: {
                return "Melbourne (RSMC)";
            }
            case 69: {
                return "Wellington (RSMC/RAFC)";
            }
            case 71: {
                return "Nadi (RSMC)";
            }
            case 74: {
                return "UK Meteorological Office Bracknell (RSMC)";
            }
            case 76: {
                return "Moscow (RSMC/RAFC)";
            }
            case 78: {
                return "Offenbach (RSMC)";
            }
            case 80: {
                return "Rome (RSMC)";
            }
            case 82: {
                return "Norrkoping";
            }
            case 85: {
                return "Toulouse (RSMC)";
            }
            case 86: {
                return "Helsinki";
            }
            case 87: {
                return "Belgrade";
            }
            case 88: {
                return "Oslo";
            }
            case 89: {
                return "Prague";
            }
            case 90: {
                return "Episkopi";
            }
            case 91: {
                return "Ankara";
            }
            case 92: {
                return "Frankfurt/Main (RAFC)";
            }
            case 93: {
                return "London (WAFC)";
            }
            case 94: {
                return "Copenhagen";
            }
            case 95: {
                return "Rota";
            }
            case 96: {
                return "Athens";
            }
            case 97: {
                return "European Space Agency (ESA)";
            }
            case 98: {
                return "ECMWF, RSMC";
            }
            case 99: {
                return "De Bilt";
            }
            case 110: {
                return "Hong-Kong";
            }
            case 210: {
                return "Frascati (ESA/ESRIN)";
            }
            case 211: {
                return "Lanion";
            }
            case 212: {
                return "Lisboa";
            }
            case 213: {
                return "Reykjavik";
            }
            case 254: {
                return "EUMETSAT Operation Centre";
            }
        }
        return "Unknown";
    }

    public int getSubCenter() {
        return this.subcenter_id;
    }

    public int getTableVersion() {
        return this.table_version;
    }

    public int getDecimalScale() {
        return this.decscale;
    }

    public int getParameterNumber() {
        return this.parameterNumber;
    }

    public String getType() {
        return this.parameter.getName();
    }

    public String getDescription() {
        return this.parameter.getDescription();
    }

    public String getUnit() {
        return this.parameter.getUnit();
    }

    public String getLevel() {
        return this.level.getLevel();
    }

    public String getLevelName() {
        return this.level.getName();
    }

    public String getLevelDesc() {
        return this.level.getDesc();
    }

    public String getLevelUnits() {
        return this.level.getUnits();
    }

    public int getLevelType() {
        return this.level.getIndex();
    }

    public int getLevelValue1() {
        return (int)this.level.getValue1();
    }

    public int getLevelValue2() {
        return (int)this.level.getValue2();
    }

    public GribPDSLevel getPDSLevel() {
        return this.level;
    }

    public GribPDSParamTable getParamTable() {
        return this.parameter_table;
    }

    public Calendar getBaseTime() {
        return this.baseTime;
    }

    public String getReferenceTime() {
        return this.referenceTime.toString();
    }

    public int getForecastTime1() {
        return this.forecastTime1;
    }

    public int getForecastTime2() {
        return this.forecastTime2;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String getTimeUnit() {
        return this.tUnit;
    }

    public int getProductDefinition() {
        return this.timeRangeValue;
    }

    public static String getProductDefinitionName(int type) {
        switch (type) {
            case 0: {
                return "Forecast/Uninitialized Analysis/Image Product";
            }
            case 1: {
                return "Initialized analysis product";
            }
            case 2: {
                return "Product with a valid time between P1 and P2";
            }
            case 3: 
            case 6: 
            case 7: {
                return "Average";
            }
            case 4: {
                return "Accumulation";
            }
            case 5: {
                return "Difference";
            }
            case 10: {
                return "product valid at reference time P1";
            }
            case 51: {
                return "Climatological Mean Value";
            }
            case 113: 
            case 115: 
            case 117: {
                return "Average of N forecasts";
            }
            case 114: 
            case 116: {
                return "Accumulation of N forecasts";
            }
            case 118: {
                return "Temporal variance";
            }
            case 119: 
            case 125: {
                return "Standard deviation of N forecasts";
            }
            case 123: {
                return "Average of N uninitialized analyses";
            }
            case 124: {
                return "Accumulation of N uninitialized analyses";
            }
            case 128: {
                return "Average of daily forecast accumulations";
            }
            case 129: {
                return "Average of successive forecast accumulations";
            }
            case 130: {
                return "Average of daily forecast averages";
            }
            case 131: {
                return "Average of successive forecast averages";
            }
            case 132: {
                return "Climatological Average of N analyses";
            }
            case 133: {
                return "Climatological Average of N forecasts";
            }
            case 134: {
                return "Climatological Root Mean Square difference between N forecasts and their verifying analyses";
            }
            case 135: {
                return "Climatological Standard Deviation of N forecasts from the mean of the same N forecasts";
            }
            case 136: {
                return "Climatological Standard Deviation of N analyses from the mean of the same N analyses";
            }
        }
        return "Unknown";
    }

    public int getTimeRange() {
        return this.timeRangeValue;
    }

    public String toString() {
        return this.headerToString() + "        center: " + this.center_id + "\n" + "        subcenter: " + this.subcenter_id + "\n" + "        process id: " + this.process_id + "\n" + "        table: " + this.table_version + "\n" + "        table version: " + this.table_version + "\n" + "        " + this.level + "        dec.scale: " + this.decscale + (this.gds_exists ? "\n        GDS exists" : "") + (this.bms_exists ? "\n        BMS exists" : "");
    }

    public String headerToString() {
        String timeStr = this.timeRange == null ? "forecast time: " + this.forecastTime1 : this.timeRange + this.forecastTime1 + this.connector + this.forecastTime2;
        return "    PDS header:\n        center: " + this.center_id + "\n" + "        subcenter: " + this.subcenter_id + "\n" + "        table: " + this.table_version + "\n" + "        grid_id: " + this.grid_id + "\n" + "        " + timeStr + " (hours) \n";
    }
}

