/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.util.Date;
import ucar.grib.Index;
import ucar.grib.Parameter;
import ucar.grib.TableLookup;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.GribPDSLevel;
import ucar.grib.grib1.GribPDSParamTable;

public class Grib1Lookup
implements TableLookup {
    private Grib1ProductDefinitionSection firstPDS;
    private Grib1IndicatorSection firstID;

    public Grib1Lookup(Grib1Product firstProduct) {
        this.firstPDS = firstProduct.getPDS();
    }

    public String getGridName(Index.GdsRecord gds) {
        return Grib1GridDefinitionSection.getName(gds.grid_type);
    }

    public String getShapeName(Index.GdsRecord gds) {
        return Grib1GridDefinitionSection.getShapeName(gds.grid_shape_code);
    }

    public Parameter getParameter(Index.GribRecord gr) {
        GribPDSParamTable parameter_table = GribPDSParamTable.getParameterTable(this.firstPDS.getCenter(), this.firstPDS.getSubCenter(), this.firstPDS.getTableVersion());
        Parameter p = parameter_table.getParameter(gr.paramNumber);
        return new Parameter(gr.paramNumber, p.getName(), p.getDescription(), p.getUnit());
    }

    public String getDisciplineName(Index.GribRecord gr) {
        return "Meteorological Products";
    }

    public String getCategoryName(Index.GribRecord gr) {
        return "Meteorological Parameters";
    }

    public String getProductDefinitionName(Index.GribRecord gr) {
        return Grib1ProductDefinitionSection.getProductDefinitionName(gr.productType);
    }

    public String getLevelName(Index.GribRecord gr) {
        return GribPDSLevel.getNameShort(gr.levelType1);
    }

    public String getLevelNameShort(Index.GribRecord gr) {
        return GribPDSLevel.getNameShort(gr.levelType1);
    }

    public String getLevelUnit(Index.GribRecord gr) {
        return GribPDSLevel.getUnits(gr.levelType1);
    }

    public String getFirstTimeRangeUnitName() {
        return this.firstPDS.getTimeUnit();
    }

    public String getFirstCenterName() {
        return this.firstPDS.getCenter_idName();
    }

    public int getFirstSubcenterId() {
        return this.firstPDS.getSubCenter();
    }

    public String getFirstProductStatusName() {
        return "Operational Products";
    }

    public String getFirstProductTypeName() {
        return Grib1ProductDefinitionSection.getProductDefinitionName(this.firstPDS.getTimeRange());
    }

    public String getFirstSignificanceOfRTName() {
        return "Start of forecast";
    }

    public Date getFirstBaseTime() {
        return this.firstPDS.getBaseTime().getTime();
    }

    public boolean isLatLon(Index.GdsRecord gds) {
        return gds.grid_type == 0;
    }

    public int getProjectionType(Index.GdsRecord gds) {
        switch (gds.grid_type) {
            case 3: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public boolean isVerticalCoordinate(Index.GribRecord gr) {
        if (gr.levelType1 == 20) {
            return true;
        }
        if (gr.levelType1 == 100) {
            return true;
        }
        if (gr.levelType1 == 103) {
            return true;
        }
        if (gr.levelType1 == 107) {
            return true;
        }
        if (gr.levelType1 == 109) {
            return true;
        }
        if (gr.levelType1 == 116) {
            return true;
        }
        if (gr.levelType1 == 125) {
            return true;
        }
        return gr.levelType1 == 160;
    }

    public boolean isPositiveUp(Index.GribRecord gr) {
        if (gr.levelType1 == 105) {
            return true;
        }
        if (gr.levelType1 == 125) {
            return true;
        }
        return gr.levelType1 == 160;
    }

    public float getFirstMissingValue() {
        return -9999.0f;
    }
}

