/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1EndSection;
import ucar.grib.grib1.Grib1Grid;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Input {
    protected RandomAccessFile raf = null;
    protected long offset = 0L;
    protected int count = 0;
    protected String header = "GRIB";
    protected ArrayList records = new ArrayList();
    protected ArrayList products = new ArrayList();
    protected HashMap gdsHM = new HashMap();

    public Grib1Input(RandomAccessFile raf) throws NotSupportedException, NoValidGribException, IOException {
        this.raf = raf;
    }

    public boolean scan(boolean getData, boolean getProducts, boolean oneRecord) throws NotSupportedException, NoValidGribException, IOException {
        long start = System.currentTimeMillis();
        Grib1ProductDefinitionSection pds = null;
        Grib1GridDefinitionSection gds = null;
        while (this.raf.getFilePointer() < this.raf.length()) {
            if (!this.seekHeader(this.raf, this.raf.length())) continue;
            this.count -= 4;
            this.offset += (long)this.count;
            Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
            this.offset += (long)is.getLength();
            long totalBytes = is.getGribLength();
            totalBytes -= (long)is.getLength();
            pds = new Grib1ProductDefinitionSection(this.raf);
            this.offset += (long)pds.getLength();
            totalBytes -= (long)pds.getLength();
            if (pds.gdsExists()) {
                gds = new Grib1GridDefinitionSection(this.raf);
                this.offset += (long)gds.getLength();
                totalBytes -= (long)gds.getLength();
            } else {
                gds = new Grib1Grid(pds);
            }
            long dataOffset = this.offset;
            this.offset += totalBytes - 4L;
            this.raf.skipBytes((int)totalBytes - 4);
            Grib1EndSection es = new Grib1EndSection(this.raf);
            this.offset += (long)es.getLength();
            if (es.getLength() > 4) {
                System.out.println("Data Section is possibly corrupt by " + es.getLength() + " bytes");
            }
            if (!es.getEndFound()) continue;
            if (getProducts) {
                Grib1Product gp = new Grib1Product(this.header, is, pds, this.getGDSkey(gds), dataOffset, totalBytes);
                this.products.add(gp);
            } else {
                Grib1Record gr = new Grib1Record(this.header, is, pds, gds, dataOffset, totalBytes);
                this.records.add(gr);
            }
            if (!oneRecord) continue;
            return true;
        }
        return true;
    }

    public int getEdition() throws IOException, NoValidGribException, NotSupportedException {
        long length;
        boolean check = false;
        long l = length = this.raf.length() < 4000L ? this.raf.length() : 4000L;
        if (!this.seekHeader(this.raf, length)) {
            return 0;
        }
        Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
        return is.getGribEdition();
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException, EOFException {
        this.count = 0;
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            char c = (char)raf.read();
            ++this.count;
            hdr.append(c);
            if (c == 'G') {
                match = 1;
                continue;
            }
            if (c == 'R' && match == 1) {
                match = 2;
                continue;
            }
            if (c == 'I' && match == 2) {
                match = 3;
                continue;
            }
            if (c == 'B' && match == 3) {
                match = 4;
                if (hdr.length() > 25) {
                    char chr = hdr.charAt(hdr.length() - 25);
                    this.header = chr == '\n' || chr == '\r' ? hdr.substring(hdr.length() - 24, hdr.length() - 5) : hdr.substring(hdr.length() - 25, hdr.length() - 6);
                }
                return true;
            }
            match = 0;
        }
        return false;
    }

    private String getGDSkey(Grib1GridDefinitionSection gds) {
        String key = gds.getCheckSum();
        if (!this.gdsHM.containsKey(key)) {
            this.gdsHM.put(key, gds);
        }
        return key;
    }

    public ArrayList getProducts() {
        return this.products;
    }

    public ArrayList getRecords() {
        return this.records;
    }

    public HashMap getGDSs() {
        return this.gdsHM;
    }

    public String toString() {
        return "GRIB file ( info)";
    }
}

