/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.unidata.io.RandomAccessFile;

public class Grib1IndicatorSection {
    protected long gribLength;
    protected int length;
    protected int discipline;
    protected int edition;

    public Grib1IndicatorSection(RandomAccessFile raf) throws NoValidGribException, NotSupportedException, IOException {
        int[] data = new int[3];
        for (int i = 0; i < 3; ++i) {
            data[i] = raf.read();
        }
        this.edition = raf.read();
        if (this.edition == 1) {
            this.gribLength = GribNumbers.uint3(data[0], data[1], data[2]);
            this.length = 8;
        } else if (this.edition == 2) {
            this.discipline = data[2];
            this.gribLength = raf.readLong();
            this.length = 16;
        } else {
            throw new NotSupportedException("GRIB edition " + this.edition + " is not yet supported");
        }
    }

    public long getGribLength() {
        return this.gribLength;
    }

    public int getLength() {
        return this.length;
    }

    public int getDiscipline() {
        return this.discipline;
    }

    public String getDisciplineName() {
        switch (this.discipline) {
            case 0: {
                return "Meteorological products";
            }
            case 1: {
                return "Hydrological products";
            }
            case 2: {
                return "Land surface products";
            }
            case 3: {
                return "Space products";
            }
            case 10: {
                return "Oceanographic products";
            }
        }
        return "Unknown";
    }

    public int getGribEdition() {
        return this.edition;
    }

    public String toString() {
        return "    IS section:\n        Grib Edition " + this.edition + '\n' + "        length: " + this.gribLength + " bytes";
    }
}

