/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import ucar.grib.Index;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Indexer {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Index writeFileIndex(RandomAccessFile inputRaf, PrintStream ps, boolean makeIndex) throws IOException {
        Date now = Calendar.getInstance().getTime();
        long start = System.currentTimeMillis();
        int count = 0;
        Index index = makeIndex ? new Index() : null;
        try {
            inputRaf.seek(0L);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(false, true, false);
            ps.println("index_version = " + Index.current_index_version);
            ps.println("grid_edition = 1");
            ps.println("location = " + inputRaf.getLocation());
            ps.println("created = " + dateFormat.format(now));
            ps.println("version = 1.0");
            if (makeIndex) {
                index.addGlobalAttribute("location", inputRaf.getLocation());
                index.addGlobalAttribute("created", dateFormat.format(now));
                index.addGlobalAttribute("version", "1.0");
            }
            ArrayList products = g1i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = (Grib1Product)products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                if (i == 0) {
                    ps.println("center = " + pds.getCenter());
                    ps.println("sub_center = " + pds.getSubCenter());
                    ps.println("table_version = " + pds.getTableVersion());
                    ps.println("--------------------------------------------------------------------");
                }
                ps.println(pds.getProductDefinition() + " " + product.getDiscipline() + " " + product.getCategory() + " " + pds.getParameter().getNumber() + " " + pds.getLevelType() + " " + pds.getLevelValue1() + " " + "255 " + pds.getLevelValue2() + " " + pds.getReferenceTime() + " " + pds.getForecastTime1() + " " + product.getGDSkey() + " " + product.getDataOffset() + " " + product.getDataSize() + " " + pds.getDecimalScale() + " " + pds.bmsExists());
                if (makeIndex) {
                    index.addGribRecord(this.makeGribRecord(product));
                }
                ++count;
            }
            HashMap gdsHM = g1i.getGDSs();
            Iterator it = gdsHM.keySet().iterator();
            while (it.hasNext()) {
                ps.println("--------------------------------------------------------------------");
                String key = (String)it.next();
                ps.println("GDSkey = " + key);
                Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key);
                Grib1Indexer.printGDS(gds, ps);
                if (!makeIndex) continue;
                index.addHorizCoordSys(this.makeGdsRecord(gds));
            }
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        ps.close();
        System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        return index;
    }

    private Index.GribRecord makeGribRecord(Grib1Product product) {
        Index.GribRecord gr = new Index.GribRecord();
        Grib1ProductDefinitionSection pds = product.getPDS();
        gr.productType = pds.getProductDefinition();
        gr.discipline = product.getDiscipline();
        gr.category = -1;
        gr.paramNumber = pds.getParameterNumber();
        gr.levelType1 = pds.getLevelType();
        gr.levelValue1 = pds.getLevelValue1();
        gr.levelType2 = 255;
        gr.levelValue2 = pds.getLevelValue2();
        gr.refTime = pds.getReferenceTime();
        gr.forecastTime = pds.getForecastTime1();
        gr.gdsKey = product.getGDSkey().trim();
        gr.offset1 = product.getDataOffset();
        gr.offset2 = -1L;
        gr.decimalScale = pds.getDecimalScale();
        gr.bmsExists = pds.bmsExists();
        return gr;
    }

    private Index.GdsRecord makeGdsRecord(Grib1GridDefinitionSection gds) {
        Index.GdsRecord igds = new Index.GdsRecord();
        igds.gdsKey = gds.getCheckSum();
        igds.grid_shape_code = gds.getShape();
        igds.grid_type = gds.getGdtn();
        if (gds.getShape() == 0) {
            igds.radius_spherical_earth = gds.getShapeRadius();
        } else if (gds.getShape() == 1) {
            igds.major_axis_earth = gds.getShapeMajorAxis();
            igds.minor_axis_earth = gds.getShapeMinorAxis();
        }
        igds.nx = gds.getNx();
        igds.ny = gds.getNy();
        igds.La1 = gds.getLa1();
        igds.Lo1 = gds.getLo1();
        igds.nx = gds.getResolution();
        igds.LaD = gds.getLad();
        igds.LoV = gds.getLov();
        igds.dx = gds.getDx();
        igds.dy = gds.getDy();
        igds.resolution = gds.getResolution();
        igds.latin1 = gds.getLatin1();
        igds.latin2 = gds.getLatin2();
        return igds;
    }

    public static void printGDS(Grib1GridDefinitionSection gds, PrintStream ps) {
        ps.println("grid_type = " + gds.getGdtn());
        ps.println("grid_name = " + gds.getName());
        if (gds.getGdtn() != 50) {
            ps.println("grid_shape_code = " + gds.getShape());
            ps.println("grid_shape = " + gds.getShapeName());
            if (gds.getShape() == 0) {
                ps.println("grid_radius_spherical_earth = " + gds.getShapeRadius());
            } else {
                ps.println("grid_major_axis_earth = " + gds.getShapeMajorAxis());
                ps.println("grid_minor_axis_earth = " + gds.getShapeMinorAxis());
            }
            ps.println("Nx = " + gds.getNx());
            ps.println("Ny = " + gds.getNy());
            ps.println("La1 = " + gds.getLa1());
            ps.println("Lo1 = " + gds.getLo1());
            ps.println("ResCompFlag = " + gds.getResolution());
        }
        switch (gds.getGdtn()) {
            case 0: 
            case 40: 
            case 201: 
            case 202: {
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            case 1: {
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Latin = " + gds.getLatin());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                break;
            }
            case 3: {
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Latin1 = " + gds.getLatin1());
                ps.println("Latin2 = " + gds.getLatin2());
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                break;
            }
            case 5: {
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            default: {
                ps.println("Unknown Grid Type");
            }
        }
    }

    public static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans for index");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1Indexer indexer = new Grib1Indexer();
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib1Indexer.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        if (args.length == 2) {
            String outfile = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            ps = new PrintStream(new FilterOutputStream(new FileOutputStream(outfile, false)));
        } else if (args.length == 1) {
            ps = System.out;
        }
        indexer.writeFileIndex(raf, ps, false);
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

