/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.util.zip.CRC32;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.unidata.io.RandomAccessFile;

public class Grib1GridDefinitionSection {
    protected int length;
    protected int type;
    protected String name = "";
    protected int nx;
    protected int ny;
    protected double lat1;
    protected double lon1;
    protected double lat2;
    protected double lon2;
    protected double lov;
    protected double lad;
    protected int resolution;
    protected double dx;
    protected double dy;
    protected int scan;
    protected int proj_center;
    protected double latin1;
    protected double latin2;
    protected double latsp;
    protected double lonsp;
    protected String checksum = "";

    public Grib1GridDefinitionSection() {
    }

    public Grib1GridDefinitionSection(RandomAccessFile raf) throws IOException, NoValidGribException {
        this.length = GribNumbers.uint3(raf);
        long mark = raf.getFilePointer();
        byte[] dst = new byte[this.length - 3];
        raf.read(dst);
        raf.seek(mark);
        CRC32 cs = new CRC32();
        cs.update(dst);
        this.checksum = Long.toString(cs.getValue());
        short o4_5 = raf.readShort();
        this.type = raf.read();
        this.name = Grib1GridDefinitionSection.getName(this.type);
        if (this.type != 50) {
            this.nx = raf.readShort();
            this.ny = raf.readShort();
            this.lat1 = (double)GribNumbers.int3(raf) / 1000.0;
            this.lon1 = (double)GribNumbers.int3(raf) / 1000.0;
            this.resolution = raf.read();
        }
        switch (this.type) {
            case 0: 
            case 40: 
            case 201: 
            case 202: {
                this.lat2 = (double)GribNumbers.int3(raf) / 1000.0;
                this.lon2 = (double)GribNumbers.int3(raf) / 1000.0;
                this.dx = (double)raf.readShort() / 1000.0;
                this.dy = (double)raf.readShort() / 1000.0;
                this.scan = raf.read();
                int reserved = GribNumbers.int3(raf);
                break;
            }
            case 1: {
                this.lat2 = (double)GribNumbers.int3(raf) / 1000.0;
                this.lon2 = (double)GribNumbers.int3(raf) / 1000.0;
                this.latin1 = GribNumbers.int3(raf);
                int reserved = raf.read();
                this.scan = raf.read();
                this.dx = GribNumbers.int3(raf);
                this.dy = GribNumbers.int3(raf);
                reserved = GribNumbers.int3(raf);
                reserved = GribNumbers.int3(raf);
                reserved = raf.read();
                reserved = raf.read();
                break;
            }
            case 3: {
                this.lov = (double)GribNumbers.int3(raf) / 1000.0;
                this.dx = GribNumbers.int3(raf);
                this.dy = GribNumbers.int3(raf);
                this.proj_center = raf.read();
                this.scan = raf.read();
                this.latin1 = (double)GribNumbers.int3(raf) / 1000.0;
                this.latin2 = (double)GribNumbers.int3(raf) / 1000.0;
                this.latsp = (double)GribNumbers.int3(raf) / 1000.0;
                this.lonsp = (double)GribNumbers.int3(raf) / 1000.0;
                short reserved = raf.readShort();
                break;
            }
            case 5: {
                this.lov = (double)GribNumbers.int3(raf) / 1000.0;
                this.dx = GribNumbers.int3(raf);
                this.dy = GribNumbers.int3(raf);
                this.proj_center = raf.read();
                this.scan = raf.read();
                int reserved = GribNumbers.int4(raf);
                break;
            }
            default: {
                System.out.println("Unknown Grid Type");
            }
        }
        if ((this.scan & 0x3F) != 0) {
            throw new NoValidGribException("GDS: This scanning mode (" + this.scan + ") is not supported.");
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getGridType() {
        return this.type;
    }

    public int getGdtn() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static String getName(int type) {
        switch (type) {
            case 0: {
                return "Latitude/Longitude Grid";
            }
            case 1: {
                return "Mercator Projection Grid";
            }
            case 2: {
                return "Gnomonic Projection Grid";
            }
            case 3: {
                return "Lambert Conformal";
            }
            case 4: {
                return "Gaussian Latitude/Longitude";
            }
            case 5: {
                return "Polar Stereographic projection Grid";
            }
            case 6: {
                return "Universal Transverse Mercator";
            }
            case 7: {
                return "Simple polyconic projection";
            }
            case 8: {
                return "Albers equal-area, secant or tangent, conic or bi-polar, projection";
            }
            case 9: {
                return "Miller's cylindrical projection";
            }
            case 10: {
                return "Rotated latitude/longitude grid";
            }
            case 13: {
                return "Oblique Lambert conformal, secant or tangent, conical or bipolar, projection";
            }
            case 14: {
                return "Rotated Gaussian latitude/longitude grid";
            }
            case 20: {
                return "Stretched latitude/longitude grid";
            }
            case 24: {
                return "Stretched Gaussian latitude/longitude grid";
            }
            case 30: {
                return "Stretched and rotated latitude/longitude grids";
            }
            case 34: {
                return "Stretched and rotated Gaussian latitude/longitude grids";
            }
            case 50: {
                return "Spherical Harmonic Coefficients";
            }
            case 60: {
                return "Rotated spherical harmonic coefficients";
            }
            case 70: {
                return "Stretched spherical harmonics";
            }
            case 80: {
                return "Stretched and rotated spherical harmonic coefficients";
            }
            case 90: {
                return "Space view perspective or orthographic";
            }
            case 201: {
                return "Arakawa semi-staggered E-grid on rotated latitude/longitude grid-point array";
            }
            case 202: {
                return "Arakawa filled E-grid on rotated latitude/longitude grid-point array";
            }
        }
        return "Unknown";
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public double getLa1() {
        return this.lat1;
    }

    public double getLo1() {
        return this.lon1;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getShape() {
        int res = this.resolution >> 6;
        if (res == 1 || res == 3) {
            return 1;
        }
        return 0;
    }

    public String getShapeName() {
        return Grib1GridDefinitionSection.getShapeName(this.getShape());
    }

    public static String getShapeName(int code) {
        if (code == 1) {
            return "oblate spheroid";
        }
        return "spherical";
    }

    public double getShapeRadius() {
        return 6367.47;
    }

    public double getShapeMajorAxis() {
        return 6378.16;
    }

    public double getShapeMinorAxis() {
        return 6356.775;
    }

    public double getLa2() {
        return this.lat2;
    }

    public double getLo2() {
        return this.lon2;
    }

    public double getLov() {
        return this.lov;
    }

    public double getLad() {
        return this.lad;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public int getScanMode() {
        return this.scan;
    }

    public double getProjectionCenter() {
        return this.proj_center;
    }

    public double getLatin() {
        return this.latin1;
    }

    public double getLatin1() {
        return this.latin1;
    }

    public double getLatin2() {
        return this.latin2;
    }

    public double getSpLat() {
        return this.latsp;
    }

    public double getSpLon() {
        return this.lonsp;
    }

    public String getCheckSum() {
        return this.checksum;
    }

    public String toString() {
        String str = "    GDS section:\n      ";
        if (this.type == 0) {
            str = str + "  LatLon Grid";
        }
        if (this.type == 3) {
            str = str + "  Lambert Conformal Grid";
        }
        if (this.type == 10) {
            str = str + "  Rotated LatLon Grid";
        }
        str = str + "  (" + this.nx + "x" + this.ny + ")\n      ";
        str = str + "  lon: " + this.lon1 + " to " + this.lon2;
        str = str + "  (dx " + this.dx + ")\n      ";
        str = str + "  lat: " + this.lat1 + " to " + this.lat2;
        str = str + "  (dy " + this.dy + ")";
        return str;
    }
}

