/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Dump {
    public void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans file");
        System.out.println("<output file> file to store results");
        System.out.println("<true or false> whether to read/display data too");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <output file> <true or false>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1Dump func = new Grib1Dump();
        if (args.length < 1) {
            Class<?> cl = func.getClass();
            func.usage(cl.getName());
        }
        boolean displayData = false;
        Date now = Calendar.getInstance().getTime();
        try {
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            if (args.length == 3) {
                raf = new RandomAccessFile(args[0], "r");
                ps = new PrintStream(new FilterOutputStream(new FileOutputStream(args[1], false)));
                displayData = args[2].equalsIgnoreCase("true");
            } else if (args.length == 2) {
                raf = new RandomAccessFile(args[0], "r");
                if (args[1].equalsIgnoreCase("true") || args[1].equalsIgnoreCase("false")) {
                    displayData = args[1].equalsIgnoreCase("true");
                } else {
                    ps = new PrintStream(new FilterOutputStream(new FileOutputStream(args[1], false)));
                }
            } else if (args.length == 1) {
                raf = new RandomAccessFile(args[0], "r");
            } else {
                System.exit(0);
            }
            raf.order(0);
            Grib1Input g1i = new Grib1Input(raf);
            g1i.scan(false, false, false);
            ArrayList records = g1i.getRecords();
            for (int i = 0; i < records.size(); ++i) {
                Grib1Record record = (Grib1Record)records.get(i);
                Grib1IndicatorSection is = record.getIs();
                Grib1ProductDefinitionSection pds = record.getPDS();
                Grib1GridDefinitionSection gds = record.getGDS();
                ps.println("--------------------------------------------------------------------");
                ps.println("                        Header : " + record.getHeader());
                ps.println(is.toString());
                ps.println();
                ps.println(pds.toString());
                ps.println();
                ps.println(gds.toString());
                ps.println();
                if (!displayData) continue;
                float[] data = null;
                ps.println("--------------------------------------------------------------------");
                Grib1Data gd = new Grib1Data(raf);
                data = gd.getData(record.getDataOffset(), pds.getDecimalScale(), pds.bmsExists());
                if (data == null) break;
                int numberPts = 6045;
                for (int j = 0; j < numberPts; ++j) {
                    ps.println("data[ " + j + " ]=" + data[j]);
                }
                break;
            }
            raf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        now = Calendar.getInstance().getTime();
    }
}

