/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1BinaryDataSection;
import ucar.grib.grib1.Grib1BitMapSection;
import ucar.grib.grib1.Grib1EndSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib1Data {
    RandomAccessFile raf = null;

    public Grib1Data(String filename) throws NotSupportedException, NoValidGribException, IOException {
        this.raf = new RandomAccessFile(filename, "r");
    }

    public Grib1Data(RandomAccessFile raf) throws NotSupportedException, NoValidGribException, IOException {
        this.raf = raf;
    }

    public float[] getData(long offset, int decimalScale, boolean bmsExists) throws NotSupportedException, NoValidGribException, IOException {
        long start = System.currentTimeMillis();
        this.raf.seek(offset);
        Grib1BitMapSection bms = null;
        if (bmsExists) {
            bms = new Grib1BitMapSection(this.raf);
        }
        Grib1BinaryDataSection bds = new Grib1BinaryDataSection(this.raf, decimalScale, bms);
        Grib1EndSection es = new Grib1EndSection(this.raf);
        if (es.getEndFound()) {
            return bds.getValues();
        }
        return null;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public String toString() {
        return "GRIB file ( info)";
    }
}

