/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.unidata.io.RandomAccessFile;

public class Grib1BitMapSection {
    protected int length;
    protected boolean[] bitmap;

    public Grib1BitMapSection(RandomAccessFile raf) throws IOException, NoValidGribException {
        int[] bitmask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        this.length = GribNumbers.uint3(raf);
        int unused = raf.read();
        short bm = raf.readShort();
        if (bm != 0) {
            System.out.println("BMS pre-defined BM provided by center");
            if (this.length - 6 == 0) {
                return;
            }
            byte[] data = new byte[this.length - 6];
            raf.read(data);
            return;
        }
        byte[] data = new byte[this.length - 6];
        raf.read(data);
        this.bitmap = new boolean[(this.length - 6) * 8 - unused];
        for (int i = 0; i < this.bitmap.length; ++i) {
            this.bitmap[i] = (data[i / 8] & bitmask[i % 8]) != 0;
        }
    }

    public int getLength() {
        return this.length;
    }

    public boolean[] getBitmap() {
        return this.bitmap;
    }

    public String toString() {
        return "    BMS section:\n        bitmap length: " + this.bitmap.length;
    }
}

