/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1BitMapSection;
import ucar.unidata.io.RandomAccessFile;

public class Grib1BinaryDataSection {
    public static final float UNDEFINED = -9999.0f;
    protected int length;
    protected int binscale;
    protected float refvalue;
    protected int numbits;
    protected int bitBuf = 0;
    protected int bitPos = 0;
    protected float[] values;
    protected float minvalue = Float.MAX_VALUE;
    protected float maxvalue = -3.4028235E38f;
    protected boolean isConstant = false;

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale) throws IOException, NoValidGribException, NotSupportedException {
        this(raf, decimalscale, null);
    }

    public Grib1BinaryDataSection(RandomAccessFile raf, int decimalscale, Grib1BitMapSection bms) throws IOException, NotSupportedException {
        this.length = GribNumbers.uint3(raf);
        int unusedbits = raf.read();
        if ((unusedbits & 0xC0) != 0) {
            throw new NotSupportedException("BDS: (octet 4, 1st half) not grid point data and simple packing ");
        }
        unusedbits &= 0xF;
        this.binscale = GribNumbers.int2(raf);
        this.refvalue = GribNumbers.float4(raf);
        this.numbits = raf.read();
        if (this.numbits == 0) {
            this.isConstant = true;
        }
        float ref = (float)(Math.pow(10.0, -decimalscale) * (double)this.refvalue);
        float scale = (float)(Math.pow(10.0, -decimalscale) * Math.pow(2.0, this.binscale));
        if (bms != null) {
            boolean[] bitmap = bms.getBitmap();
            this.values = new float[bitmap.length];
            for (int i = 0; i < bitmap.length; ++i) {
                if (bitmap[i]) {
                    if (!this.isConstant) {
                        this.values[i] = ref + scale * (float)this.bits2UInt(this.numbits, raf);
                        if (this.values[i] > this.maxvalue) {
                            this.maxvalue = this.values[i];
                        }
                        if (!(this.values[i] < this.minvalue)) continue;
                        this.minvalue = this.values[i];
                        continue;
                    }
                    this.values[i] = ref;
                    continue;
                }
                this.values[i] = -9999.0f;
            }
        } else if (!this.isConstant) {
            this.values = new float[((this.length - 11) * 8 - unusedbits) / this.numbits];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ref + scale * (float)this.bits2UInt(this.numbits, raf);
                if (this.values[i] > this.maxvalue) {
                    this.maxvalue = this.values[i];
                }
                if (!(this.values[i] < this.minvalue)) continue;
                this.minvalue = this.values[i];
            }
        } else {
            this.maxvalue = ref;
            this.minvalue = ref;
        }
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    public int getLength() {
        return this.length;
    }

    public int getBinaryScale() {
        return this.binscale;
    }

    public boolean getIsConstant() {
        return this.isConstant;
    }

    public float getReferenceValue() {
        return this.refvalue;
    }

    public int getNumBits() {
        return this.numbits;
    }

    public float[] getValues() {
        return this.values;
    }

    public float getValue(int index) throws NoValidGribException {
        if (index >= 0 && index < this.values.length) {
            return this.values[index];
        }
        throw new NoValidGribException("  Grib1BinaryDataSection: Array index out of bounds");
    }

    public float getMinValue() {
        return this.minvalue;
    }

    public float getMaxValue() {
        return this.maxvalue;
    }

    public float getMissingValue() {
        return -9999.0f;
    }

    public String toString() {
        return "    BDS section:\n        min/max value: " + this.minvalue + " " + this.maxvalue + "\n" + "        ref. value: " + this.refvalue + "\n" + "        is a constant: " + this.isConstant + "\n" + "        bin. scale: " + this.binscale + "\n" + "        num bits: " + this.numbits;
    }
}

