/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Index {
    private static boolean debugTiming = false;
    private static boolean debugParse = false;
    public static String current_index_version = "1.1";
    private ArrayList index = new ArrayList();
    private ArrayList gcs = new ArrayList();
    private HashMap atts = new HashMap();
    static String testName = "C:/data/grib2/200409240000.ngrid.gbx";
    static String testName2 = "C:/data/grib2/eta2.wmo.gbx";

    public boolean open(String location) throws IOException {
        InputStream ios = null;
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return this.open(location, ios);
    }

    public boolean open(String location, InputStream ios) throws IOException {
        String line;
        String line2;
        long start = System.currentTimeMillis();
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        boolean versionOk = false;
        while ((line2 = dataIS.readLine()) != null && !line2.startsWith("--")) {
            int pos = line2.indexOf(" = ");
            if (pos <= 0) continue;
            String key = line2.substring(0, pos);
            String value = line2.substring(pos + 3);
            this.atts.put(key, value);
            if (!key.equals("index_version")) continue;
            versionOk = value.equalsIgnoreCase(current_index_version);
        }
        if (!versionOk) {
            return false;
        }
        while ((line2 = dataIS.readLine()) != null && !line2.startsWith("--")) {
            StringTokenizer stoke = new StringTokenizer(line2);
            String productType = stoke.nextToken();
            String discipline = stoke.nextToken();
            String category = stoke.nextToken();
            String param = stoke.nextToken();
            String levelType1 = stoke.nextToken();
            String levelValue1 = stoke.nextToken();
            String levelType2 = stoke.nextToken();
            String levelValue2 = stoke.nextToken();
            String refTime = stoke.nextToken();
            String foreTime = stoke.nextToken();
            String gdsKey = stoke.nextToken();
            String offset1 = stoke.nextToken();
            String offset2 = stoke.nextToken();
            String decimalScale = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            String bmsExists = stoke.hasMoreTokens() ? stoke.nextToken() : null;
            GribRecord s = new GribRecord(productType, discipline, category, param, levelType1, levelValue1, levelType2, levelValue2, refTime, foreTime, gdsKey, offset1, offset2, decimalScale, bmsExists);
            this.index.add(s);
            if (!debugParse) continue;
            System.out.println(s);
        }
        GdsRecord gds = new GdsRecord();
        this.gcs.add(gds);
        while ((line = dataIS.readLine()) != null) {
            if (line.startsWith("--")) {
                gds.finish();
                gds = new GdsRecord();
                this.gcs.add(gds);
                continue;
            }
            int pos = line.indexOf(" = ");
            if (pos <= 0) continue;
            gds.addParam(line.substring(0, pos), line.substring(pos + 3));
        }
        gds.finish();
        dataIS.close();
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" Index read " + location + " count=" + this.index.size() + " took=" + took + " msec ");
        }
        return true;
    }

    public HashMap getGlobalAttributes() {
        return this.atts;
    }

    public ArrayList getGribRecords() {
        return this.index;
    }

    public ArrayList getHorizCoordSys() {
        return this.gcs;
    }

    public void addGribRecord(GribRecord gr) {
        this.index.add(gr);
    }

    public void addHorizCoordSys(GdsRecord gds) {
        this.gcs.add(gds);
    }

    public void addGlobalAttribute(String name, String value) {
        this.atts.put(name, value);
    }

    public static void main(String[] args) throws IOException {
        new Index().open(testName);
    }

    public static class GdsRecord {
        HashMap params = new HashMap();
        public String gdsKey;
        public int grid_type;
        public int nx;
        public int ny;
        public int resolution;
        public double dx;
        public double dy;
        public double latin1;
        public double latin2;
        public double La1;
        public double Lo1;
        public double LaD;
        public double LoV;
        public int grid_shape_code;
        public double radius_spherical_earth;
        public double major_axis_earth;
        public double minor_axis_earth;

        public String getValue(String name) {
            return (String)this.params.get(name);
        }

        void addParam(String key, String value) {
            if (debugParse) {
                System.out.println(" adding " + key + " = " + value);
            }
            this.params.put(key.trim(), value);
        }

        void finish() {
            try {
                this.gdsKey = ((String)this.params.get("GDSkey")).trim();
                this.grid_type = Integer.parseInt((String)this.params.get("grid_type"));
                this.grid_shape_code = Integer.parseInt((String)this.params.get("grid_shape_code"));
                this.nx = Integer.parseInt((String)this.params.get("Nx"));
                this.ny = Integer.parseInt((String)this.params.get("Ny"));
                this.dx = this.readDouble("Dx");
                this.dy = this.readDouble("Dy");
                this.latin1 = this.readDouble("Latin1");
                this.latin2 = this.readDouble("Latin2");
                this.La1 = this.readDouble("La1");
                this.Lo1 = this.readDouble("Lo1");
                this.LaD = this.readDouble("LaD");
                this.LoV = this.readDouble("LoV");
                this.radius_spherical_earth = this.readDouble("radius_spherical_earth");
                this.major_axis_earth = this.readDouble("major_axis_earth");
                this.minor_axis_earth = this.readDouble("minor_axis_earth");
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        private double readDouble(String name) {
            String s = (String)this.params.get(name);
            if (s == null) {
                return 0.0;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0.0;
            }
        }
    }

    public static class GribRecord {
        public int productType;
        public int discipline;
        public int category;
        public int paramNumber;
        public int levelType1;
        public int levelType2;
        public float levelValue1;
        public float levelValue2;
        public String gdsKey;
        public long offset1;
        public long offset2;
        public String refTime;
        public int forecastTime;
        public int decimalScale = 0;
        public boolean bmsExists = true;

        public GribRecord() {
        }

        GribRecord(String productTypeS, String disciplineS, String categoryS, String paramS, String levelType1S, String levelValue1S, String levelType2S, String levelValue2S, String refTime, String foreTimeS, String gdsKeyS, String offset1S, String offset2S, String decimalScaleS, String bmsExistsS) {
            this.refTime = refTime;
            this.gdsKey = gdsKeyS.trim();
            try {
                this.productType = Integer.parseInt(productTypeS);
                this.discipline = Integer.parseInt(disciplineS);
                this.category = Integer.parseInt(categoryS);
                this.paramNumber = Integer.parseInt(paramS);
                this.levelType1 = Integer.parseInt(levelType1S);
                this.levelValue1 = Float.parseFloat(levelValue1S);
                this.levelType2 = Integer.parseInt(levelType2S);
                this.levelValue2 = Float.parseFloat(levelValue2S);
                this.forecastTime = Integer.parseInt(foreTimeS);
                this.offset1 = Long.parseLong(offset1S);
                this.offset2 = Long.parseLong(offset2S);
                if (decimalScaleS != null) {
                    this.decimalScale = Integer.parseInt(decimalScaleS);
                }
                if (bmsExistsS != null) {
                    this.bmsExists = bmsExistsS.equals("true");
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }
}

