/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import ucar.grib.Diff;
import ucar.grib.GribChecker;
import ucar.grib.grib1.Grib1Dump;
import ucar.grib.grib1.Grib1GetData;
import ucar.grib.grib1.Grib1Indexer;
import ucar.grib.grib2.Grib2Dump;
import ucar.grib.grib2.Grib2GetData;
import ucar.grib.grib2.Grib2Indexer;
import ucar.unidata.io.RandomAccessFile;

public class GribTest
extends TestCase {
    protected int fValue1;
    protected int fValue2;
    protected String dataPath;
    protected String testPath;
    static /* synthetic */ Class class$ucar$grib$GribTest;

    protected void setUp() {
        this.fValue1 = 2;
        this.fValue2 = 3;
        this.dataPath = "/data/ldm/thredds/grib/data/";
        this.testPath = "/data/ldm/thredds/grib/test/";
    }

    public static Test suite() {
        return new TestSuite(class$ucar$grib$GribTest == null ? (class$ucar$grib$GribTest = GribTest.class$("ucar.grib.GribTest")) : class$ucar$grib$GribTest);
    }

    public void testData() throws IOException {
        String[] args = new String[]{this.dataPath + "RUC.wmo", "110", "1", "true", "RucData"};
        Grib1GetData.main(args);
        Diff d = new Diff();
        d.doDiff(this.testPath + "RucData.test", "RucData");
        String[] arg = new String[]{this.dataPath + "ndfd.wmo", "498193", "498274", "NdfdData"};
        Grib2GetData.main(arg);
        d.doDiff(this.testPath + "NdfdData.test", "NdfdData");
    }

    public void testIndex() throws IOException {
        String[] args = new String[]{this.dataPath + "RUC.wmo", "RucIndex"};
        Grib1Indexer.main(args);
        Diff d = new Diff();
        d.doDiff(this.testPath + "RucIndex.gbx.test", "RucIndex.gbx");
        args[0] = this.dataPath + "ndfd.wmo";
        args[1] = "NdfdIndex";
        Grib2Indexer.main(args);
        d.doDiff(this.testPath + "NdfdIndex.gbx.test", "NdfdIndex.gbx");
    }

    public void testDump() throws IOException {
        String[] args = new String[]{this.dataPath + "RUC.wmo", "RucDump"};
        Grib1Dump.main(args);
        Diff d = new Diff();
        d.doDiff(this.testPath + "RucDump.test", "RucDump");
        args[0] = this.dataPath + "ndfd.wmo";
        args[1] = "NdfdDump";
        Grib2Dump.main(args);
        d.doDiff(this.testPath + "NdfdDump.test", "NdfdDump");
    }

    public void testEdition() throws IOException {
        int edition = 0;
        RandomAccessFile raf = new RandomAccessFile(this.dataPath + "ndfd.wmo", "r");
        edition = GribChecker.getEdition(raf);
        GribTest.assertEquals((String)"ndfd.wmo edition", (int)2, (int)edition);
        raf = new RandomAccessFile(this.dataPath + "RUC.wmo", "r");
        edition = GribChecker.getEdition(raf);
        GribTest.assertEquals((String)"RUC.wmo edition", (int)1, (int)edition);
        raf = new RandomAccessFile(this.dataPath + "junk.wmo", "r");
        edition = GribChecker.getEdition(raf);
        GribTest.assertEquals((String)"junk.wmo edition", (int)0, (int)edition);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GribTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

