/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.IOException;
import java.io.PrintStream;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2Input;
import ucar.unidata.io.RandomAccessFile;

public class GribChecker {
    public void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> checks for validity");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead>");
        System.exit(0);
    }

    public static void main(String[] args) {
        GribChecker func = new GribChecker();
        if (args.length < 1) {
            Class<?> cl = func.getClass();
            func.usage(cl.getName());
        }
        try {
            RandomAccessFile raf = null;
            PrintStream ps = System.out;
            String outfile = args[0];
            if (args.length == 1) {
                raf = new RandomAccessFile(outfile, "r");
            } else {
                ps.println("no file name given");
                System.exit(0);
            }
            int result = GribChecker.getEdition(raf);
            if (result == 2) {
                ps.println("Valid Grib Edition 2 File");
            } else if (result == 1) {
                ps.println("Valid Grib Edition 1 File");
            } else {
                ps.println("Not a Grib File");
            }
        }
        catch (IOException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
    }

    public static int getEdition(RandomAccessFile raf) {
        int check = 0;
        Grib2Input g2i = null;
        try {
            g2i = new Grib2Input(raf);
            check = g2i.getEdition();
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        return check;
    }
}

