/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.io.IOException;
import ucar.grib.fileInfo;
import ucar.grib.node;

public class Diff {
    final int UNREAL = Integer.MAX_VALUE;
    fileInfo oldinfo;
    fileInfo newinfo;
    int[] blocklen;
    public static final int idle = 0;
    public static final int delete = 1;
    public static final int insert = 2;
    public static final int movenew = 3;
    public static final int moveold = 4;
    public static final int same = 5;
    public static final int change = 6;
    int printstatus;
    boolean anyprinted;
    int printoldline;
    int printnewline;

    public static void main(String[] argstrings) {
        if (argstrings.length != 2) {
            System.err.println("Usage: diff oldfile newfile");
            System.exit(1);
        }
        Diff d = new Diff();
        d.doDiff(argstrings[0], argstrings[1]);
    }

    Diff() {
    }

    public void doDiff(String oldFile, String newFile) {
        this.oldinfo = new fileInfo(oldFile);
        this.newinfo = new fileInfo(newFile);
        try {
            this.inputscan(this.oldinfo);
            this.inputscan(this.newinfo);
        }
        catch (IOException e) {
            System.err.println("Read error: " + e);
        }
        this.blocklen = new int[(this.oldinfo.maxLine > this.newinfo.maxLine ? this.oldinfo.maxLine : this.newinfo.maxLine) + 2];
        this.oldinfo.alloc();
        this.newinfo.alloc();
        this.transform();
        this.printout();
    }

    void inputscan(fileInfo pinfo) throws IOException {
        String linebuffer;
        pinfo.maxLine = 0;
        while ((linebuffer = pinfo.file.readLine()) != null) {
            this.storeline(linebuffer, pinfo);
        }
    }

    void storeline(String linebuffer, fileInfo pinfo) {
        int linenum;
        if ((linenum = ++pinfo.maxLine) > 50000) {
            System.err.println("MAXLINECOUNT exceeded, must stop.");
            System.exit(1);
        }
        pinfo.symbol[linenum] = node.addSymbol(linebuffer, pinfo == this.oldinfo, linenum);
    }

    void transform() {
        int oldmax = this.oldinfo.maxLine + 2;
        int newmax = this.newinfo.maxLine + 2;
        for (int oldline = 0; oldline < oldmax; ++oldline) {
            this.oldinfo.other[oldline] = -1;
        }
        for (int newline = 0; newline < newmax; ++newline) {
            this.newinfo.other[newline] = -1;
        }
        this.scanunique();
        this.scanafter();
        this.scanbefore();
        this.scanblocks();
    }

    void scanunique() {
        for (int newline = 1; newline <= this.newinfo.maxLine; ++newline) {
            int oldline;
            node psymbol = this.newinfo.symbol[newline];
            if (!psymbol.symbolIsUnique()) continue;
            this.newinfo.other[newline] = oldline = psymbol.linenum;
            this.oldinfo.other[oldline] = newline;
        }
        this.newinfo.other[0] = 0;
        this.oldinfo.other[0] = 0;
        this.newinfo.other[this.newinfo.maxLine + 1] = this.oldinfo.maxLine + 1;
        this.oldinfo.other[this.oldinfo.maxLine + 1] = this.newinfo.maxLine + 1;
    }

    void scanafter() {
        for (int newline = 0; newline <= this.newinfo.maxLine; ++newline) {
            int oldline = this.newinfo.other[newline];
            if (oldline < 0) continue;
            while (++oldline <= this.oldinfo.maxLine && this.oldinfo.other[oldline] < 0 && ++newline <= this.newinfo.maxLine && this.newinfo.other[newline] < 0 && this.newinfo.symbol[newline] == this.oldinfo.symbol[oldline]) {
                this.newinfo.other[newline] = oldline;
                this.oldinfo.other[oldline] = newline;
            }
        }
    }

    void scanbefore() {
        for (int newline = this.newinfo.maxLine + 1; newline > 0; --newline) {
            int oldline = this.newinfo.other[newline];
            if (oldline < 0) continue;
            while (--oldline > 0 && this.oldinfo.other[oldline] < 0 && --newline > 0 && this.newinfo.other[newline] < 0 && this.newinfo.symbol[newline] == this.oldinfo.symbol[oldline]) {
                this.newinfo.other[newline] = oldline;
                this.oldinfo.other[oldline] = newline;
            }
        }
    }

    void scanblocks() {
        int oldline;
        int oldfront = 0;
        int newlast = -1;
        for (oldline = 1; oldline <= this.oldinfo.maxLine; ++oldline) {
            this.blocklen[oldline] = 0;
        }
        this.blocklen[this.oldinfo.maxLine + 1] = Integer.MAX_VALUE;
        for (oldline = 1; oldline <= this.oldinfo.maxLine; ++oldline) {
            int newline = this.oldinfo.other[oldline];
            if (newline < 0) {
                oldfront = 0;
            } else {
                if (oldfront == 0) {
                    oldfront = oldline;
                }
                if (newline != newlast + 1) {
                    oldfront = oldline;
                }
                int n = oldfront;
                this.blocklen[n] = this.blocklen[n] + 1;
            }
            newlast = newline;
        }
    }

    void printout() {
        this.printstatus = 0;
        this.anyprinted = false;
        this.printnewline = 1;
        this.printoldline = 1;
        while (true) {
            if (this.printoldline > this.oldinfo.maxLine) {
                this.newconsume();
                break;
            }
            if (this.printnewline > this.newinfo.maxLine) {
                this.oldconsume();
                break;
            }
            if (this.newinfo.other[this.printnewline] < 0) {
                if (this.oldinfo.other[this.printoldline] < 0) {
                    this.showchange();
                    continue;
                }
                this.showinsert();
                continue;
            }
            if (this.oldinfo.other[this.printoldline] < 0) {
                this.showdelete();
                continue;
            }
            if (this.blocklen[this.printoldline] < 0) {
                this.skipold();
                continue;
            }
            if (this.oldinfo.other[this.printoldline] == this.printnewline) {
                this.showsame();
                continue;
            }
            this.showmove();
        }
        if (this.anyprinted) {
            this.println(">>>> End of differences.");
        } else {
            this.println(">>>> Files are identical.");
        }
    }

    void newconsume() {
        while (this.printnewline <= this.newinfo.maxLine) {
            if (this.newinfo.other[this.printnewline] < 0) {
                this.showinsert();
                continue;
            }
            this.showmove();
        }
    }

    void oldconsume() {
        while (this.printoldline <= this.oldinfo.maxLine) {
            this.printnewline = this.oldinfo.other[this.printoldline];
            if (this.printnewline < 0) {
                this.showdelete();
                continue;
            }
            if (this.blocklen[this.printoldline] < 0) {
                this.skipold();
                continue;
            }
            this.showmove();
        }
    }

    void showdelete() {
        if (this.printstatus != 1) {
            this.println(">>>> DELETE AT " + this.printoldline);
        }
        this.printstatus = 1;
        this.oldinfo.symbol[this.printoldline].showSymbol();
        this.anyprinted = true;
        ++this.printoldline;
    }

    void showinsert() {
        if (this.printstatus == 6) {
            this.println(">>>>     CHANGED TO");
        } else if (this.printstatus != 2) {
            this.println(">>>> INSERT BEFORE " + this.printoldline);
        }
        this.printstatus = 2;
        this.newinfo.symbol[this.printnewline].showSymbol();
        this.anyprinted = true;
        ++this.printnewline;
    }

    void showchange() {
        if (this.printstatus != 6) {
            this.println(">>>> " + this.printoldline + " CHANGED FROM");
        }
        this.printstatus = 6;
        this.oldinfo.symbol[this.printoldline].showSymbol();
        this.anyprinted = true;
        ++this.printoldline;
    }

    void skipold() {
        this.printstatus = 0;
        while (++this.printoldline <= this.oldinfo.maxLine && this.oldinfo.other[this.printoldline] >= 0 && this.blocklen[this.printoldline] == 0) {
        }
    }

    void skipnew() {
        int oldline;
        this.printstatus = 0;
        while (++this.printnewline <= this.newinfo.maxLine && (oldline = this.newinfo.other[this.printnewline]) >= 0 && this.blocklen[oldline] == 0) {
        }
    }

    void showsame() {
        this.printstatus = 0;
        if (this.newinfo.other[this.printnewline] != this.printoldline) {
            System.err.println("BUG IN LINE REFERENCING");
            System.exit(1);
        }
        int count = this.blocklen[this.printoldline];
        this.printoldline += count;
        this.printnewline += count;
    }

    void showmove() {
        int oldblock = this.blocklen[this.printoldline];
        int newother = this.newinfo.other[this.printnewline];
        int newblock = this.blocklen[newother];
        if (newblock < 0) {
            this.skipnew();
        } else if (oldblock >= newblock) {
            this.blocklen[newother] = -1;
            this.println(">>>> " + newother + " THRU " + (newother + newblock - 1) + " MOVED TO BEFORE " + this.printoldline);
            while (newblock > 0) {
                this.newinfo.symbol[this.printnewline].showSymbol();
                --newblock;
                ++this.printnewline;
            }
            this.anyprinted = true;
            this.printstatus = 0;
        } else {
            this.skipold();
        }
    }

    public void println(String s) {
        System.out.println(s);
    }
}

