/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.ConversionException;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.DerivedUnitImpl;
import ucar.units.MultiplyException;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.Unit;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

public final class ScaledUnit
extends UnitImpl
implements DerivableUnit {
    private final double _scale;
    private final Unit _unit;

    public ScaledUnit(double scale) {
        this(scale, (Unit)DerivedUnitImpl.DIMENSIONLESS);
    }

    public ScaledUnit(double scale, Unit unit) {
        this(scale, unit, null);
    }

    public ScaledUnit(double scale, Unit unit, UnitName id) {
        super(id);
        if (!(unit instanceof ScaledUnit)) {
            this._unit = unit;
            this._scale = scale;
        } else {
            this._unit = ((ScaledUnit)unit)._unit;
            this._scale = ((ScaledUnit)unit)._scale * scale;
        }
    }

    public double getScale() {
        return this._scale;
    }

    public Unit getUnit() {
        return this._unit;
    }

    public Unit clone(UnitName id) {
        return new ScaledUnit(this._scale, this.getUnit(), id);
    }

    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        return that instanceof ScaledUnit ? new ScaledUnit(this.getScale() * ((ScaledUnit)that).getScale(), this.getUnit().multiplyBy(((ScaledUnit)that).getUnit())) : new ScaledUnit(this.getScale(), this.getUnit().multiplyBy(that));
    }

    protected Unit myDivideBy(Unit that) throws OperationException {
        return that instanceof ScaledUnit ? new ScaledUnit(this.getScale() / ((ScaledUnit)that).getScale(), this.getUnit().divideBy(((ScaledUnit)that).getUnit())) : new ScaledUnit(this.getScale(), this.getUnit().divideBy(that));
    }

    protected Unit myDivideInto(Unit that) throws OperationException {
        return that instanceof ScaledUnit ? new ScaledUnit(((ScaledUnit)that).getScale() / this.getScale(), this.getUnit().divideInto(((ScaledUnit)that).getUnit())) : new ScaledUnit(1.0 / this.getScale(), this.getUnit().divideInto(that));
    }

    protected Unit myRaiseTo(int power) throws RaiseException {
        return new ScaledUnit(Math.pow(this.getScale(), power), this.getUnit().raiseTo(power));
    }

    public DerivedUnit getDerivedUnit() {
        return this.getUnit().getDerivedUnit();
    }

    public float toDerivedUnit(float amount) throws ConversionException {
        return (float)this.toDerivedUnit((double)amount);
    }

    public double toDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException((Unit)this, (Unit)this.getDerivedUnit());
        }
        return ((DerivableUnit)this._unit).toDerivedUnit(amount * this.getScale());
    }

    public float[] toDerivedUnit(float[] input, float[] output) throws ConversionException {
        float scale = (float)this.getScale();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] * scale;
        }
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException((Unit)this, (Unit)this.getDerivedUnit());
        }
        return ((DerivableUnit)this.getUnit()).toDerivedUnit(output, output);
    }

    public double[] toDerivedUnit(double[] input, double[] output) throws ConversionException {
        double scale = this.getScale();
        int i = input.length;
        while (--i >= 0) {
            output[i] = input[i] * scale;
        }
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException((Unit)this, (Unit)this.getDerivedUnit());
        }
        return ((DerivableUnit)this.getUnit()).toDerivedUnit(output, output);
    }

    public float fromDerivedUnit(float amount) throws ConversionException {
        return (float)this.fromDerivedUnit((double)amount);
    }

    public double fromDerivedUnit(double amount) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException((Unit)this.getDerivedUnit(), (Unit)this);
        }
        return ((DerivableUnit)this.getUnit()).fromDerivedUnit(amount) / this.getScale();
    }

    public float[] fromDerivedUnit(float[] input, float[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException((Unit)this.getDerivedUnit(), (Unit)this);
        }
        ((DerivableUnit)this.getUnit()).fromDerivedUnit(input, output);
        float scale = (float)this.getScale();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] / scale;
        }
        return output;
    }

    public double[] fromDerivedUnit(double[] input, double[] output) throws ConversionException {
        if (!(this._unit instanceof DerivableUnit)) {
            throw new ConversionException((Unit)this.getDerivedUnit(), (Unit)this);
        }
        ((DerivableUnit)this.getUnit()).fromDerivedUnit(input, output);
        double scale = this.getScale();
        int i = input.length;
        while (--i >= 0) {
            int n = i;
            output[n] = output[n] / scale;
        }
        return output;
    }

    public boolean equals(Object object) {
        return object instanceof ScaledUnit ? super.equals(object) && this.getScale() == ((ScaledUnit)object).getScale() && this.getUnit().equals(((ScaledUnit)object).getUnit()) : this.getScale() == 1.0 && this.getUnit().equals(object);
    }

    public boolean isDimensionless() {
        return this.getUnit().isDimensionless();
    }

    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    public String getCanonicalString() {
        return Double.toString(this.getScale()) + " " + this.getUnit().toString();
    }

    public static void main(String[] args) throws Exception {
        BaseUnit meter = BaseUnit.getOrCreate((UnitName)UnitName.newUnitName((String)"meter", null, (String)"m"), (BaseQuantity)BaseQuantity.LENGTH);
        ScaledUnit nauticalMile = new ScaledUnit(1852.0, (Unit)meter);
        System.out.println("nauticalMile.getUnit().equals(meter)=" + nauticalMile.getUnit().equals(meter));
        ScaledUnit nauticalMileMeter = (ScaledUnit)nauticalMile.multiplyBy((Unit)meter);
        System.out.println("nauticalMileMeter.divideBy(nauticalMile)=" + nauticalMileMeter.divideBy(nauticalMile));
        System.out.println("meter.divideBy(nauticalMile)=" + meter.divideBy((Unit)nauticalMile));
        System.out.println("nauticalMile.raiseTo(2)=" + nauticalMile.raiseTo(2));
        System.out.println("nauticalMile.toDerivedUnit(1.)=" + nauticalMile.toDerivedUnit(1.0));
        System.out.println("nauticalMile.toDerivedUnit(new float[]{1,2,3}, new float[3])[1]=" + nauticalMile.toDerivedUnit(new float[]{1.0f, 2.0f, 3.0f}, new float[3])[1]);
        System.out.println("nauticalMile.fromDerivedUnit(1852.)=" + nauticalMile.fromDerivedUnit(1852.0));
        System.out.println("nauticalMile.fromDerivedUnit(new float[]{1852},new float[1])[0]=" + nauticalMile.fromDerivedUnit(new float[]{1852.0f}, new float[1])[0]);
        System.out.println("nauticalMile.equals(nauticalMile)=" + nauticalMile.equals(nauticalMile));
        ScaledUnit nautical2Mile = new ScaledUnit(2.0, nauticalMile);
        System.out.println("nauticalMile.equals(nautical2Mile)=" + nauticalMile.equals(nautical2Mile));
        System.out.println("nauticalMile.isDimensionless()=" + nauticalMile.isDimensionless());
        BaseUnit radian = BaseUnit.getOrCreate((UnitName)UnitName.newUnitName((String)"radian", null, (String)"rad"), (BaseQuantity)BaseQuantity.PLANE_ANGLE);
        ScaledUnit degree = new ScaledUnit(0.017453277777777776, (Unit)radian);
        System.out.println("degree.isDimensionless()=" + degree.isDimensionless());
    }
}

