/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

public class StringUtil {
    private static char[] hcontentOut = new char[]{'&', '<', '>', '\n'};
    private static String[] hcontentIn = new String[]{"&amp;", "&lt;", "&gt;", "\n<p>"};
    private static char[] attOut = new char[]{'&', '<', '>', '\'', '\"', '\r', '\n'};
    private static String[] attIn = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "&#13;", "&#10;"};

    public static String collapseWhitespace(String s) {
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                b.append(c);
                continue;
            }
            b.append(' ');
            while (i + 1 < len && Character.isWhitespace(s.charAt(i + 1))) {
                ++i;
            }
        }
        return b.toString();
    }

    public static String removeWhitespace(String s) {
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            b.append(c);
        }
        return b.toString();
    }

    public static String remove(String s, String sub) {
        int pos;
        int len = sub.length();
        while (0 <= (pos = s.indexOf(sub))) {
            s = s.substring(0, pos) + s.substring(pos + len);
        }
        return s;
    }

    public static String remove(String s, int c) {
        if (0 > s.indexOf(c)) {
            return s;
        }
        StringBuffer buff = new StringBuffer(s);
        int i = 0;
        while (i < buff.length()) {
            if (buff.charAt(i) == c) {
                buff.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return buff.toString();
    }

    public static String substitute(String original, String[] match, String[] subst) {
        String s = original;
        for (int i = 0; i < match.length; ++i) {
            int pos;
            while (0 <= (pos = s.indexOf(match[i]))) {
                StringBuffer sb = new StringBuffer(s);
                s = sb.replace(pos, pos + match[i].length(), subst[i]).toString();
            }
        }
        return s;
    }

    public static String substitute(String original, String match, String subst) {
        int pos;
        String s = original;
        while (0 <= (pos = s.indexOf(match))) {
            StringBuffer sb = new StringBuffer(s);
            s = sb.replace(pos, pos + match.length(), subst).toString();
        }
        return s;
    }

    public static void substitute(StringBuffer sbuff, String match, String subst) {
        int pos;
        int fromIndex = 0;
        int substLen = subst.length();
        int matchLen = match.length();
        while (0 <= (pos = sbuff.indexOf(match, fromIndex))) {
            sbuff.replace(pos, pos + matchLen, subst);
            fromIndex = pos + substLen;
        }
    }

    public static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String quoteHtmlContent(String x) {
        return StringUtil.replace(x, hcontentOut, hcontentIn);
    }

    public static String quoteXmlAttribute(String x) {
        return StringUtil.replace(x, attOut, attIn);
    }

    private static String replace(String x, char[] replaceChar, String[] replaceWith) {
        boolean ok = true;
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            ok &= pos < 0;
        }
        if (ok) {
            return x;
        }
        StringBuffer sb = new StringBuffer(x);
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            if (pos < 0) continue;
            StringUtil.replace(sb, replaceChar[i], replaceWith[i]);
        }
        return sb.toString();
    }

    public static void replace(StringBuffer sb, char out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != out) continue;
            sb.replace(i, i + 1, in);
            i += in.length();
        }
    }

    public static String replace(String s, char out, String in) {
        if (s.indexOf(out) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        StringUtil.replace(sb, out, in);
        return sb.toString();
    }

    private static void testMatch() {
        String[] match = new String[]{"$test", "$subst", "barf"};
        String[] subst = new String[]{"TESTING123", "ok", "BARFOLA"};
        System.out.println(StringUtil.substitute("$test $test $test", match, subst));
        System.out.println(StringUtil.substitute("test $test test", match, subst));
        System.out.println(StringUtil.substitute("$subst $SUbST $barf", match, subst));
        System.out.println(StringUtil.substitute("why cant you just $test??", match, subst));
    }

    public static void main(String[] args) {
        System.out.println("<" + StringUtil.remove("startRE:RE:RE:end", "RE:") + "> should be <startend>");
        System.out.println("<" + StringUtil.remove("RE:RE:RE:end", "RE:") + "> should be <end>");
        System.out.println("<" + StringUtil.remove("startRE:RE:RE:", "RE:") + "> should be <start>");
        System.out.println("<" + StringUtil.remove("RE:RE:RE:", ":RE:") + "> should be <RERE:>");
        System.out.println("<" + StringUtil.remove("RE:RE:RE:", "RE") + "> should be <:::>");
        System.out.println("<" + StringUtil.remove("RE:middleRE:", "RE:") + "> should be <middle>");
    }
}

