/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.util.StringTokenizer;
import ucar.nc2.units.SimpleUnit;
import ucar.units.Unit;

public class TimeUnit
extends SimpleUnit {
    private double value;
    private String unitString;
    private SimpleUnit oneUnit = null;
    private volatile int hashCode = 0;

    TimeUnit(String text, Unit uu) {
        super(uu);
        StringTokenizer stoker = new StringTokenizer(text);
        int ntoke = stoker.countTokens();
        if (ntoke == 1) {
            this.value = 1.0;
            this.unitString = stoker.nextToken();
        } else if (ntoke == 2) {
            this.value = Double.parseDouble(stoker.nextToken());
            this.unitString = stoker.nextToken();
        } else {
            throw new IllegalArgumentException("Not TimeUnit = " + text);
        }
    }

    public TimeUnit(String text) throws Exception {
        StringTokenizer stoker = new StringTokenizer(text);
        String valueS = stoker.nextToken();
        this.value = Double.parseDouble(valueS);
        this.unitString = stoker.nextToken();
        SimpleUnit su = SimpleUnit.factoryWithExceptions(this.toString());
        if (!(su instanceof TimeUnit)) {
            throw new ParseException("not udunit time unit", 0);
        }
        this.uu = su.getUnit();
    }

    public TimeUnit(double value, String unitString) throws Exception {
        this.value = value;
        this.unitString = unitString;
        SimpleUnit su = SimpleUnit.factoryWithExceptions(this.toString());
        if (!(su instanceof TimeUnit)) {
            throw new ParseException("not udunit time unit", 0);
        }
        this.uu = su.getUnit();
    }

    public double getValue() {
        return this.value;
    }

    public String getUnitString() {
        return this.unitString;
    }

    public String toString() {
        return this.value + " " + this.unitString;
    }

    public double getSeconds() {
        try {
            double secs = this.uu.convertTo(1.0, timeUnit);
            return secs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public TimeUnit newValue(double secs) throws Exception {
        SimpleUnit secSU = SimpleUnit.factoryWithExceptions(secs + " secs");
        if (this.oneUnit == null) {
            this.oneUnit = SimpleUnit.factory("1.0 " + this.unitString);
        }
        double val = secSU.convertTo(1.0, this.oneUnit);
        return new TimeUnit(val, this.unitString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeUnit)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.unitString.hashCode();
            this.hashCode = result = 37 * result + (int)(1000.0 * this.value);
        }
        return this.hashCode;
    }
}

