/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import ucar.nc2.units.DateUnit;
import ucar.nc2.units.TimeUnit;
import ucar.units.ConversionException;
import ucar.units.OperationException;
import ucar.units.Unit;
import ucar.units.UnitDB;
import ucar.units.UnitDBManager;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;
import ucar.units.UnitName;
import ucar.units.UnknownUnit;

public class SimpleUnit {
    protected static UnitFormat format;
    protected static Unit timeUnit;
    protected static Unit dateUnit;
    protected static boolean debugParse;
    protected Unit uu;

    public static SimpleUnit factory(String name) {
        try {
            return SimpleUnit.factoryWithExceptions(name);
        }
        catch (Exception e) {
            if (debugParse) {
                System.out.println("Parse " + name + " got Exception " + e);
            }
            return null;
        }
    }

    public static SimpleUnit factoryWithExceptions(String name) throws Exception {
        Unit uu = format.parse(name);
        if (SimpleUnit.isDateUnit(uu)) {
            return new DateUnit(uu);
        }
        if (SimpleUnit.isTimeUnit(uu)) {
            return new TimeUnit(name, uu);
        }
        return new SimpleUnit(uu);
    }

    public static boolean isCompatible(String unitString1, String unitString2) {
        Unit uu2;
        Unit uu1;
        try {
            uu1 = format.parse(unitString1);
        }
        catch (Exception e) {
            System.out.println("Parse " + unitString1 + " got Exception1 " + e);
            return false;
        }
        try {
            uu2 = format.parse(unitString2);
        }
        catch (Exception e) {
            System.out.println("Parse " + unitString2 + " got Exception2 " + e);
            return false;
        }
        return uu1.isCompatible(uu2);
    }

    public static boolean isCompatibleWithExceptions(String unitString1, String unitString2) throws Exception {
        Unit uu1 = format.parse(unitString1);
        Unit uu2 = format.parse(unitString2);
        return uu1.isCompatible(uu2);
    }

    public static boolean isDateUnit(Unit uu) {
        boolean ok = uu.isCompatible(dateUnit);
        if (!ok) {
            return false;
        }
        try {
            uu.getConverterTo(dateUnit);
            return true;
        }
        catch (ConversionException e) {
            return false;
        }
    }

    public static boolean isTimeUnit(Unit uu) {
        return uu.isCompatible(timeUnit);
    }

    public static boolean isDateUnit(String unitString) {
        SimpleUnit su = SimpleUnit.factory(unitString);
        if (su == null) {
            return false;
        }
        return SimpleUnit.isDateUnit(su.getUnit());
    }

    public static boolean isTimeUnit(String unitString) {
        SimpleUnit su = SimpleUnit.factory(unitString);
        if (su == null) {
            return false;
        }
        return SimpleUnit.isTimeUnit(su.getUnit());
    }

    protected SimpleUnit() {
    }

    SimpleUnit(Unit uu) {
        this.uu = uu;
    }

    public String getName() {
        return this.uu.toString();
    }

    public String toString() {
        return this.uu.toString();
    }

    public Unit getUnit() {
        return this.uu;
    }

    public double convertTo(double value, SimpleUnit outputUnit) throws ConversionException {
        return this.uu.convertTo(value, outputUnit.getUnit());
    }

    public SimpleUnit divideBy(SimpleUnit denom) throws OperationException {
        return new SimpleUnit(this.uu.divideBy(denom.uu));
    }

    public boolean isUnknownUnit() {
        return this.uu instanceof UnknownUnit;
    }

    private static void tryDivide() throws Exception {
        SimpleUnit t1 = SimpleUnit.factory("3 days");
        SimpleUnit t2 = SimpleUnit.factory("1 minute");
        SimpleUnit t3 = t1.divideBy(t2);
        System.out.println(t1 + " divideBy " + t2 + " = " + t3);
    }

    private static void tryConvert() throws Exception {
        SimpleUnit t1 = SimpleUnit.factory("1 days");
        SimpleUnit t2 = SimpleUnit.factory("1 hour");
        double v = t1.convertTo(1.0, t2);
        System.out.println(t1 + " convertTo " + t2 + " = " + v);
    }

    public static void main(String[] args) throws Exception {
        SimpleUnit tu = SimpleUnit.factory("3 days");
        System.out.println("time.isTimeUnit = " + SimpleUnit.isTimeUnit(tu.getUnit()));
        System.out.println("time.isDateUnit = " + SimpleUnit.isDateUnit(tu.getUnit()));
        String text = "3 days since 1930-07-27 12:00:00-05:00";
        SimpleUnit du = SimpleUnit.factory(text);
        System.out.println(text + " == standard format " + du);
        System.out.println("date.isTimeUnit = " + SimpleUnit.isTimeUnit(du.getUnit()));
        System.out.println("date.isDateUnit = " + SimpleUnit.isDateUnit(du.getUnit()));
        text = "0 hours since 1930-07-29T01:00:00-08:00";
        du = SimpleUnit.factory(text);
        System.out.println(text + " == standard format " + du);
        System.out.println("date.isTimeUnit = " + SimpleUnit.isTimeUnit(du.getUnit()));
        System.out.println("date.isDateUnit = " + SimpleUnit.isDateUnit(du.getUnit()));
        System.out.println(text + " == standard format " + du);
        SimpleUnit.tryDivide();
        SimpleUnit.tryConvert();
    }

    static {
        debugParse = false;
        try {
            format = UnitFormatManager.instance();
            timeUnit = format.parse("1 sec");
            dateUnit = format.parse("secs since 1970-01-01 00:00:00");
            UnitDB unitDB = UnitDBManager.instance();
            Unit u = format.parse("millibar");
            Unit alias = u.clone(UnitName.newUnitName((String)"mb"));
            unitDB.addUnit(alias);
        }
        catch (Exception e) {
            System.out.println("SimpleUnit initialization failed " + e);
            throw new RuntimeException("SimpleUnit initialization failed " + e);
        }
    }
}

