/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import ucar.nc2.units.SimpleUnit;
import ucar.units.ScaledUnit;
import ucar.units.TimeScaleUnit;
import ucar.units.Unit;

public class DateUnit
extends SimpleUnit {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static Date getStandardDate(String unitString) {
        Unit uu = null;
        try {
            uu = format.parse(unitString);
        }
        catch (Exception e) {
            return null;
        }
        if (!(uu instanceof TimeScaleUnit)) {
            return null;
        }
        TimeScaleUnit tsu = (TimeScaleUnit)uu;
        Date origin = tsu.getOrigin();
        if (!(tsu.getUnit() instanceof ScaledUnit)) {
            return null;
        }
        ScaledUnit offset = (ScaledUnit)tsu.getUnit();
        double value = offset.getScale();
        Date result = new Date(origin.getTime() + (long)(1000.0 * value));
        return result;
    }

    public static String getStandardDateString(Date date) {
        return dateFormat.format(date);
    }

    DateUnit(Unit uu) {
        super(uu);
    }

    public Date getDateOrigin() {
        if (!(this.uu instanceof TimeScaleUnit)) {
            return null;
        }
        TimeScaleUnit tu = (TimeScaleUnit)this.uu;
        return tu.getOrigin();
    }

    public Date getStandardDate(double value) {
        double secs;
        try {
            secs = this.uu.convertTo(value, dateUnit);
            if (debugParse) {
                System.out.println(value + " " + this.getName() + "= " + secs + " secs since the epoch");
            }
        }
        catch (Exception e) {
            if (debugParse) {
                System.out.println("getStandardDateString got Exception " + e);
            }
            return null;
        }
        Date date = new Date();
        date.setTime((long)(1000.0 * secs));
        return date;
    }

    public String getStandardDateString(double value) {
        Date date = this.getStandardDate(value);
        if (date == null) {
            return null;
        }
        return dateFormat.format(date);
    }

    public String toString() {
        return this.getStandardDateString(1.0);
    }

    public static void main(String[] args) throws Exception {
        long msec = 0L;
        Date d = new Date(msec);
        System.out.println(msec + " = " + DateUnit.getStandardDateString(d));
        msec = -62188992000000L;
        d = new Date(msec);
        System.out.println(msec + " = " + DateUnit.getStandardDateString(d));
        msec = Long.MAX_VALUE;
        d = new Date(msec);
        System.out.println(msec + " = " + DateUnit.getStandardDateString(d));
        msec = Long.MIN_VALUE;
        d = new Date(msec);
        System.out.println(msec + " = " + DateUnit.getStandardDateString(d));
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

