/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.PrintStream;
import java.util.ArrayList;

public class Stat {
    private String name;
    private int n = 0;
    private double sum = 0.0;
    private double sumsq = 0.0;
    private ArrayList samples = null;

    public Stat() {
    }

    public Stat(String name, boolean keepSamples) {
        this.name = name;
        if (keepSamples) {
            this.samples = new ArrayList();
        }
    }

    public Stat(String name, int n, double avg, double std, boolean keepSamples) {
        this(name, keepSamples);
        this.n = n;
        this.sum = (double)n * avg;
        this.sumsq = (double)n * (std * std + avg * avg);
    }

    public void sample(int s) {
        this.sum += (double)s;
        this.sumsq += (double)(s * s);
        ++this.n;
        if (this.samples != null) {
            this.samples.add(new Double(s));
        }
    }

    public void sample(double s) {
        this.sum += s;
        this.sumsq += s * s;
        ++this.n;
        if (this.samples != null) {
            this.samples.add(new Double(s));
        }
    }

    public double average() {
        return this.n == 0 ? 0.0 : this.sum / (double)this.n;
    }

    public double std() {
        if (this.n == 0) {
            return 0.0;
        }
        double avg = this.average();
        return Math.sqrt(this.sumsq / (double)this.n - avg * avg);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getN() {
        return this.n;
    }

    public ArrayList getSamples() {
        return this.samples;
    }

    public void setSamples(ArrayList samples) {
        this.samples = samples;
        this.sum = 0.0;
        this.sumsq = 0.0;
        this.n = 0;
        for (int i = 0; i < samples.size(); ++i) {
            double s = (Double)samples.get(i);
            this.sum += s;
            this.sumsq += s * s;
            ++this.n;
        }
    }

    public int[] bin(int nbins, double intv, double min) {
        if (null == this.samples) {
            return null;
        }
        int[] bins = new int[nbins + 1];
        for (int i = 0; i < this.samples.size(); ++i) {
            Double valueObject = (Double)this.samples.get(i);
            int bin = (int)((valueObject - min) / intv);
            if (bin < 0) {
                bins[0] = bins[0] + 1;
                continue;
            }
            if (bin > nbins) {
                int n = nbins;
                bins[n] = bins[n] + 1;
                continue;
            }
            int n = bin;
            bins[n] = bins[n] + 1;
        }
        return bins;
    }

    public void printBins(int nbins, double intv, double min, PrintStream out) {
        int[] bins = this.bin(nbins, intv, min);
        for (int i = 0; i < bins.length - 1; ++i) {
            double edge = (double)(i + 1) * intv + min;
            if (bins[i] <= 0) continue;
            out.println("< " + edge + " == " + bins[i]);
        }
        double edge = (double)nbins * intv + min;
        if (bins[nbins] > 0) {
            out.println("> " + edge + " == " + bins[nbins]);
        }
    }

    public int[] bin(double[] intv) {
        if (null == this.samples) {
            return null;
        }
        int nbins = intv.length;
        int[] bins = new int[nbins + 1];
        for (int i = 0; i < this.samples.size(); ++i) {
            int binno;
            Double valueObject = (Double)this.samples.get(i);
            int n = binno = this.findBin(intv, valueObject);
            bins[n] = bins[n] + 1;
        }
        return bins;
    }

    private int findBin(double[] intv, double value) {
        if (value <= intv[0]) {
            return 0;
        }
        for (int i = 1; i < intv.length; ++i) {
            if (!(value <= intv[i])) continue;
            return i;
        }
        return intv.length;
    }

    public void printBins(double[] intv, boolean showAll, PrintStream out) {
        if (null == this.samples) {
            return;
        }
        int[] bins = this.bin(intv);
        int nbins = bins.length;
        out.println("Stat= " + this.getName());
        if (showAll || bins[0] > 0) {
            out.println(" <= " + intv[0] + " == " + bins[0]);
        }
        for (int i = 1; i < nbins - 1; ++i) {
            if (!showAll && bins[i] <= 0) continue;
            out.println("(" + intv[i - 1] + "," + intv[i] + "] == " + bins[i]);
        }
        if (showAll || bins[nbins - 1] > 0) {
            out.println("> " + intv[nbins - 2] + " == " + bins[nbins - 1]);
        }
    }
}

