/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class IO {
    static boolean showStackTrace = true;
    static boolean debug = false;
    static boolean showResponse = false;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(InputStream in, OutputStream out, int n) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            if ((count += bytesRead) <= n) continue;
            return;
        }
    }

    public static void copyFile(String fileInName, String fileOutName) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileInName));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
        IO.copy(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void copyFile(File fileIn, File fileOut) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileIn));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOut));
        IO.copy(in, out);
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void copyFile(String fileInName, OutputStream out) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileInName));
        IO.copy(in, out);
        ((InputStream)in).close();
    }

    public static void copyToFile(InputStream in, String fileOutName) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileOutName));
        IO.copy(in, out);
        in.close();
        ((OutputStream)out).close();
    }

    public static void copyDirTree(String fromDirName, String toDirName) throws IOException {
        File fromDir = new File(fromDirName);
        File toDir = new File(toDirName);
        if (!fromDir.exists()) {
            throw new IOException(fromDirName + " does not exist");
        }
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        File[] files = fromDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                IO.copyDirTree(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
                continue;
            }
            IO.copyFile(f.getAbsolutePath(), toDir.getAbsolutePath() + "/" + f.getName());
        }
    }

    public static String readURLcontentsWithException(String urlString) throws IOException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            HttpURLConnection httpConnection;
            int responseCode;
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(20000);
            IO.copy(is, bout);
            is.close();
            if (debug) {
                System.out.println("readURLcontentsWithException success on " + urlString);
            }
            return new String(bout.toByteArray());
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
    }

    public static String readURLcontents(String urlString) {
        try {
            return IO.readURLcontentsWithException(urlString);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static String readContents(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000);
        IO.copy(is, bout);
        return new String(bout.toByteArray());
    }

    public static String readFile(String filename) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
        return IO.readContents(in);
    }

    public static Result putToURL(String urlString, String contents) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return new Result(-1, "** MalformedURLException on URL (" + urlString + ")\n" + e.getMessage());
        }
        try {
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            c.setDoOutput(true);
            c.setRequestMethod("PUT");
            BufferedOutputStream out = new BufferedOutputStream(c.getOutputStream());
            IO.copy(new ByteArrayInputStream(contents.getBytes()), out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            int code = c.getResponseCode();
            String mess = c.getResponseMessage();
            return new Result(code, mess);
        }
        catch (ConnectException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return new Result(-2, "** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        catch (IOException e) {
            if (showStackTrace) {
                e.printStackTrace();
            }
            return new Result(-3, "** IOException on URL: (" + urlString + ")\n" + e.getMessage());
        }
    }

    public static void writeContents(String contents, OutputStream os) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(contents.getBytes());
        IO.copy(bin, os);
    }

    public static boolean writeToFile(String contents, File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        IO.copy(new ByteArrayInputStream(contents.getBytes()), out);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        return true;
    }

    public static class Result {
        public int code;
        public String message;

        Result(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}

