/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.DataType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsDefault;
import thredds.servlet.View;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class ViewManager
extends ThreddsDefault {
    private static final boolean showJnlp = true;
    private static HashMap templates = new HashMap();

    private static String getTemplate(String path) {
        String template = (String)templates.get(path);
        try {
            template = IO.readFile(path);
        }
        catch (IOException ioe) {
            return null;
        }
        templates.put(path, template);
        return template;
    }

    public static void doView(String contentPath, String rootPath, String path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String template;
        if (Debug.isSet("showRequest")) {
            System.out.println("**ViewManager req= " + path);
        }
        if ((template = ViewManager.getTemplate(contentPath + path)) == null) {
            template = ViewManager.getTemplate(rootPath + path);
        }
        if (template == null) {
            res.sendError(404);
            return;
        }
        StringBuffer sbuff = new StringBuffer(template);
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            String sname = "{" + name + "}";
            for (int i = 0; i < values.length; ++i) {
                StringUtil.substitute(sbuff, sname, values[i]);
            }
        }
        try {
            res.setContentType("application/x-java-jnlp-file");
            ServletUtil.returnString(sbuff.toString(), res);
            System.out.println(" jnlp=" + sbuff.toString());
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
    }

    public static void showViewers(StringBuffer sbuff, InvDatasetImpl dataset) {
        sbuff.append("<h3>Viewers:</h3>\n<ol>\n");
        ViewManager.checkForIDV(sbuff, dataset);
        ViewManager.checkForTDV(sbuff, dataset);
    }

    private static void checkForIDV(StringBuffer sbuff, InvDatasetImpl dataset) {
        InvAccess access = dataset.getAccess(ServiceType.FILE);
        if (access == null) {
            access = dataset.getAccess(ServiceType.DODS);
        }
        if (access == null) {
            return;
        }
        DataType dt = dataset.getDataType();
        if (dt != DataType.GRID) {
            return;
        }
        sbuff.append(" <li> <a href='views/idv.jnlp?access=" + access.getStandardUrlName() + "'>Integrated Data Viewer (IDV) (webstart)</a>\n");
        ViewManager.showViews(sbuff, dataset, "IDV");
    }

    private static void checkForTDV(StringBuffer sbuff, InvDatasetImpl ds) {
        String id = ds.getID();
        if (id == null || !ds.hasAccess()) {
            return;
        }
        sbuff.append(" <li> <a href='views/tdv.jnlp?" + ds.getSubsetUrl() + "'>THREDDS Data Viewer (webstart)</a>\n");
    }

    private static void showViews(StringBuffer sbuff, InvDatasetImpl dataset, String viewer) {
        List list = View.getViews();
        if (list.size() == 0) {
            return;
        }
        sbuff.append("<ul>\n");
        for (int i = 0; i < list.size(); ++i) {
            View v = (View)list.get(i);
            v.writeHtml(sbuff);
        }
        sbuff.append("\n</ul><p>\n");
    }
}

