/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.servlet.Debug;
import thredds.servlet.DebugHandler;
import thredds.servlet.Log;
import thredds.servlet.ServletUtil;
import thredds.servlet.ViewManager;

public class ThreddsDefault
extends HttpServlet {
    protected static String rootPath;
    protected static String contentPath;
    protected static Log log;

    public void init() {
        ServletUtil.initDebugging(this);
        rootPath = ServletUtil.getRootPath(this);
        ServletUtil.initLogging(this);
        log = new Log(((Object)((Object)this)).getClass().getName(), true);
        log.println("-----ThreddsDefault initialized; rootPath= " + rootPath);
        contentPath = ServletUtil.getContentPath(this);
        String initialContentPath = ServletUtil.getInitialContentPath(this);
        try {
            if (ServletUtil.copyDir(initialContentPath, contentPath)) {
                log.println("ThreddsDefault copy " + initialContentPath + " to " + contentPath);
            }
        }
        catch (IOException ioe) {
            log.error("ThreddsDefault failed to copy " + initialContentPath + " to " + contentPath, ioe);
        }
        this.makeDebugActions();
    }

    public String getRootPath() {
        return rootPath;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String path;
            if (Debug.isSet("showRequest")) {
                System.out.println("**ThreddsDefault req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                ServletUtil.showRequestDetail(this, req, System.out);
            }
            if ((path = ServletUtil.getRequestPath(req)) != null && path.equals("/")) {
                path = "/index.html";
            }
            if (path != null && path.equals("/catalog.html")) {
                RequestDispatcher dispatch = req.getRequestDispatcher("/catalog.html");
                if (dispatch != null) {
                    dispatch.forward((ServletRequest)req, (ServletResponse)res);
                } else {
                    res.sendError(404);
                }
                return;
            }
            if (path != null && path.startsWith("/views/")) {
                ViewManager.doView(contentPath, rootPath, path, req, res);
                return;
            }
            if (path != null && path.equals("/debug")) {
                DebugHandler.getGlobalInstance().doDebug(this, req, res);
                return;
            }
            if (path != null && path.equals("/catalogWait.xml")) {
                System.out.println("sleep 10 secs");
                Thread work = Thread.currentThread();
                Thread.sleep(10000L);
                path = "/catalog.xml";
            }
            boolean useRoot = false;
            boolean useContent = false;
            if (path != null && path.startsWith("/root/")) {
                useRoot = true;
                path = path.substring(5);
            } else if (path.startsWith("/content/")) {
                useContent = true;
                path = path.substring(8);
            }
            if (useRoot) {
                ServletUtil.returnFile(this, rootPath, path, res, null);
            } else if (useContent) {
                ServletUtil.returnFile(this, contentPath, path, res, null);
            } else {
                File file;
                String filename = ServletUtil.formFilename(contentPath, path);
                if (filename != null && (file = new File(filename)).exists()) {
                    ServletUtil.returnFile(this, contentPath, path, res, null);
                    return;
                }
                ServletUtil.returnFile(this, rootPath, path, res, null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ServletUtil.handleException(t, res);
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = ServletUtil.getRequestPath(req);
        log.printIfSet("showRequest", "doPut ThreddsServlet path= " + path);
        if (path != null && ServletUtil.saveFile(this, contentPath, path, req, res)) {
            return;
        }
        res.sendError(404);
    }

    private void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.getGlobalInstance();
        DebugHandler.Action act = new DebugHandler.Action("showFlags", "Show Debugging Flags"){

            public void doAction(DebugHandler.Event e) {
                ThreddsDefault.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("toggleFlag", null){

            public void doAction(DebugHandler.Event e) {
                if (e.nextToken != null) {
                    String flag;
                    Debug.set(flag, !Debug.isSet(flag = e.nextToken));
                } else {
                    e.pw.println(" Must be toggleFlag=<flagName>");
                }
                ThreddsDefault.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRequest", "Show HTTP Request info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showRequestDetail(ThreddsDefault.this, e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showServletInfo", "Show Servlet info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showServletInfo(ThreddsDefault.this, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSession", "Show HTTP Session info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showSession(e.req, e.res, e.pw);
            }
        };
        debugHandler.addAction(act);
    }

    void showFlags(HttpServletRequest req, PrintStream pw) {
        Iterator iter = Debug.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String url = req.getRequestURI() + "?toggleFlag=" + key;
            pw.println("  <a href='" + url + "'>" + key + " = " + Debug.isSet(key) + "</a>");
        }
    }
}

