/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import com.oreilly.servlet.ServletUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import thredds.servlet.Debug;
import thredds.servlet.Log;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class ServletUtil {
    private static Logger logger = Logger.getLogger((String)ServletUtil.class.getName());
    private static boolean debugFileSwitch = false;
    private static boolean isDebugInit = false;
    private static boolean isLogInit = false;
    private static String contentPath = null;

    public static void initDebugging(HttpServlet servlet) {
        if (isDebugInit) {
            return;
        }
        isDebugInit = true;
        ServletContext webapp = servlet.getServletContext();
        String debugOn = webapp.getInitParameter("DebugOn");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set(toker.nextToken(), true);
            }
        }
    }

    public static void initLogging(HttpServlet servlet) {
        if (isLogInit) {
            return;
        }
        isLogInit = true;
        Log.setLogPath(ServletUtil.getContentPath(servlet) + "logs");
        ServletContext servletContext = servlet.getServletContext();
        Level logLevel = Level.OFF;
        Logger.getRootLogger().setLevel(logLevel);
        String logLevelName = servletContext.getInitParameter("logLevelDefault");
        if (logLevelName != null) {
            logLevel = Level.toLevel((String)logLevelName);
        }
        Logger threddsLogger = Logger.getLogger((String)"thredds");
        threddsLogger.setLevel(logLevel);
        String debugOn = servletContext.getInitParameter("logLevelDebug");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Logger curLogger = Logger.getLogger((String)toker.nextToken());
                curLogger.setLevel(Level.DEBUG);
            }
        }
        File logPath = new File(ServletUtil.getContentPath(servlet), "logs");
        String logFileName = servletContext.getInitParameter("logFileDefault");
        if (!logPath.exists() && !logPath.mkdirs()) {
            throw new RuntimeException("Creation of logfile directory failed.");
        }
        PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd HH:mm:ss.SSS} [%10r] %-5p - %c - %m%n");
        File tmpFile = new File(logPath, logFileName);
        RollingFileAppender threddsFileAppender = null;
        try {
            threddsFileAppender = new RollingFileAppender((Layout)layout, tmpFile.toString(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Creation of logfile <" + logFileName + "> failed.");
        }
        threddsLogger.addAppender((Appender)threddsFileAppender);
        String logFilesOptional = servletContext.getInitParameter("logFilesOptional");
        if (logFilesOptional != null) {
            StringTokenizer toker = new StringTokenizer(logFilesOptional);
            String curLoggerName = null;
            Logger curLogger = null;
            String curLogFileName = null;
            File curLogFile = null;
            RollingFileAppender curFileAppender = null;
            while (toker.hasMoreTokens()) {
                curLoggerName = toker.nextToken();
                curLogger = Logger.getLogger((String)curLoggerName);
                curLogFileName = curLoggerName + ".log";
                curLogFile = new File(logPath, curLogFileName);
                try {
                    curFileAppender = new RollingFileAppender((Layout)layout, curLogFile.toString(), false);
                }
                catch (IOException e) {
                    String tmpMsg = "Creation of logfile <" + curLogFileName + "> failed: " + e.getMessage();
                    logger.error((Object)("init(): " + tmpMsg));
                    throw new RuntimeException(tmpMsg, e);
                }
                curLogger.removeAppender((Appender)threddsFileAppender);
                curLogger.addAppender((Appender)curFileAppender);
            }
        }
        logger.debug((Object)("initLogging() Logging initialized; logPath= " + logPath));
    }

    public static String getRootPath(HttpServlet servlet) {
        ServletContext sc = servlet.getServletContext();
        String rootPath = sc.getRealPath("/");
        rootPath = rootPath.replace('\\', '/');
        return rootPath;
    }

    public static String getContentPath(HttpServlet servlet) {
        if (contentPath == null) {
            File cf = new File(ServletUtil.getRootPath(servlet) + "../../content/thredds/");
            try {
                contentPath = cf.getCanonicalPath() + "/";
            }
            catch (IOException ioe) {
                logger.error((Object)(" getContentPath(): " + ioe.getMessage()));
            }
        }
        return contentPath;
    }

    public static String getInitialContentPath(HttpServlet servlet) {
        return ServletUtil.getRootPath(servlet) + "initialContent/";
    }

    public static String formFilename(String contentPath, String path) {
        if (contentPath == null || path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return contentPath.endsWith("/") ? contentPath + path : contentPath + "/" + path;
    }

    public static void returnFile(HttpServlet servlet, String contentPath, String path, HttpServletResponse res, String contentType) throws IOException {
        String filename = ServletUtil.formFilename(contentPath, path);
        boolean debugRequest = Debug.isSet("returnFile");
        if (debugRequest) {
            logger.debug((Object)("returnFile(): ReturnFile wants file = " + filename));
        }
        if (filename == null) {
            res.sendError(404);
            return;
        }
        if (filename.indexOf("..") != -1) {
            res.sendError(403);
            return;
        }
        if (filename.indexOf("WEB-INF") != -1) {
            res.sendError(403);
            return;
        }
        if (filename.indexOf("META-INF") != -1) {
            res.sendError(403);
            return;
        }
        File file = new File(filename);
        if (!file.exists()) {
            res.sendError(404);
            return;
        }
        if (file.isDirectory()) {
            ServletUtil.returnDirectoryListing(servlet, filename, res, path);
            return;
        }
        if (null == contentType) {
            contentType = servlet.getServletContext().getMimeType(filename);
        }
        if (contentType == null) {
            contentType = "text/plain";
        }
        res.setContentType(contentType);
        if (debugRequest) {
            logger.debug((Object)("returnFile(): filename = " + filename + " contentType = " + contentType));
        }
        try {
            ServletOutputStream out = res.getOutputStream();
            ServletUtils.returnFile((String)filename, (OutputStream)out);
            out.flush();
            if (debugRequest) {
                logger.debug((Object)("returnFile(): returnFile ok = " + filename));
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("returnFile(): FileNotFoundException= " + filename));
            res.sendError(404);
        }
        catch (SocketException e) {
            logger.error((Object)("returnFile(): SocketException sending file: " + filename + "\n " + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)("returnFile(): IOException sending file: " + e.getMessage()));
            res.sendError(404, "Problem sending file: " + e.getMessage());
        }
    }

    public static void returnDirectoryListing(HttpServlet servlet, String dirName, HttpServletResponse res, String path) throws IOException {
        int lastSlash;
        boolean debugRequest = Debug.isSet("ReturnFile");
        if (debugRequest) {
            logger.debug((Object)("returnDirectoryListing(): wants dir = " + dirName));
        }
        if (dirName == null) {
            res.sendError(404);
            return;
        }
        if (dirName.indexOf("..") != -1) {
            res.sendError(403);
            return;
        }
        String upper = dirName.toUpperCase();
        if (upper.startsWith("WEB-INF") || upper.startsWith("META-INF")) {
            res.sendError(403);
            return;
        }
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            res.sendError(404);
            return;
        }
        boolean endsWithSlash = dirName.endsWith("/");
        if (!endsWithSlash && (lastSlash = path.lastIndexOf("/")) > 0) {
            path = path.substring(lastSlash + 1);
        }
        res.setContentType("text/html");
        PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
        pw.println("<title>Directory</title>");
        pw.println("<body>");
        pw.println("<h2>Contents of  " + path + ":</h2><ul>\n\n");
        File[] child = dir.listFiles();
        for (int i = 0; i < child.length; ++i) {
            Date lastMod = new Date(child[i].lastModified());
            String childname = child[i].getName();
            if (child[i].isDirectory()) {
                childname = childname + "/";
            }
            if (!endsWithSlash) {
                childname = path + "/" + childname;
            }
            pw.println("<li> " + lastMod + "  <a href='" + childname + "'>" + childname + "</a>");
        }
        pw.println("</ul></body>");
        pw.flush();
        res.setStatus(200);
    }

    public static void returnString(String contents, HttpServletResponse res) throws IOException {
        try {
            ServletOutputStream out = res.getOutputStream();
            IO.copy(new ByteArrayInputStream(contents.getBytes()), (OutputStream)out);
        }
        catch (IOException e) {
            Log.errorG(" IOException sending string: " + e.getMessage());
            res.sendError(404, "Problem sending string: " + e.getMessage());
        }
    }

    public static boolean saveFile(HttpServlet servlet, String contentPath, String path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean debugRequest = Debug.isSet("SaveFile");
        if (debugRequest) {
            logger.debug((Object)(" saveFile(): path= " + path));
        }
        String filename = contentPath + path;
        File want = new File(filename);
        int version = ServletUtil.getBackupVersion(want.getParent(), want.getName());
        String fileSave = filename + "~" + version;
        File file = new File(filename);
        if (file.exists()) {
            try {
                IO.copyFile(filename, fileSave);
            }
            catch (IOException e) {
                logger.error((Object)("saveFile(): Unable to save copy of file " + filename + " to " + fileSave + "\n" + e.getMessage()));
                return false;
            }
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
            IO.copy((InputStream)req.getInputStream(), out);
            ((OutputStream)out).close();
            if (debugRequest) {
                logger.debug((Object)("saveFile(): ok= " + filename));
            }
            res.setStatus(200);
            return true;
        }
        catch (IOException e) {
            logger.error((Object)("saveFile(): Unable to PUT file " + filename + " to " + fileSave + "\n" + e.getMessage()));
            return false;
        }
    }

    private static int getBackupVersion(String dirName, String fileName) {
        int maxN = 0;
        File dir = new File(dirName);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            int pos;
            String name = files[i];
            if (name.indexOf(fileName) < 0 || (pos = name.indexOf(126)) < 0) continue;
            String ver = name.substring(pos + 1);
            int n = 0;
            try {
                n = Integer.parseInt(ver);
            }
            catch (NumberFormatException e) {
                Log.errorG("Format Integer error on backup filename= " + ver);
            }
            maxN = Math.max(n, maxN);
        }
        return maxN + 1;
    }

    public static boolean copyDir(String fromDir, String toDir) throws IOException {
        File contentFile = new File(toDir + ".INIT");
        if (!contentFile.exists()) {
            IO.copyDirTree(fromDir, toDir);
            contentFile.createNewFile();
            return true;
        }
        return false;
    }

    public static void handleException(Throwable t, HttpServletResponse res) {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            t.printStackTrace(ps);
            String message = new String(bs.toByteArray());
            res.sendError(400, message);
        }
        catch (IOException e) {
            logger.error((Object)"handleException(): IOException");
            t.printStackTrace();
        }
    }

    public static void showServletInfo(HttpServlet servlet, PrintStream out) {
        String name;
        out.println("Servlet Info");
        out.println(" getServletName(): " + servlet.getServletName());
        out.println(" getRootPath(): " + ServletUtil.getRootPath(servlet));
        out.println(" Init Parameters:");
        Enumeration enumeration = servlet.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String name2 = (String)enumeration.nextElement();
            out.println("  " + name2 + ": " + servlet.getInitParameter(name2));
        }
        out.println();
        ServletContext context = servlet.getServletContext();
        out.println("Context Info");
        try {
            out.println(" context.getResource('/'): " + context.getResource("/"));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        out.println(" context.getServerInfo(): " + context.getServerInfo());
        out.println("  name: " + ServletUtil.getServerInfoName(context.getServerInfo()));
        out.println("  version: " + ServletUtil.getServerInfoVersion(context.getServerInfo()));
        out.println(" context.getInitParameterNames():");
        enumeration = context.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            out.println("  " + name + ": " + context.getInitParameter(name));
        }
        out.println(" context.getAttributeNames():");
        enumeration = context.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            out.println("  context.getAttribute(\"" + name + "\"): " + context.getAttribute(name));
        }
        out.println();
        Properties sysp = System.getProperties();
        Enumeration<?> e = sysp.propertyNames();
        out.println("System Properties:");
        while (e.hasMoreElements()) {
            String name3 = (String)e.nextElement();
            String value = System.getProperty(name3);
            out.println("  " + name3 + " = " + value);
        }
        out.println();
    }

    public static String getRequestParsed(HttpServletRequest req) {
        return req.getRequestURI() + " = " + req.getContextPath() + "(context), " + req.getServletPath() + "(servletPath), " + req.getPathInfo() + "(pathInfo), " + req.getQueryString() + "(query)";
    }

    public static String getRequestBase(HttpServletRequest req) {
        return "http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI();
    }

    public static String getRequestPath(HttpServletRequest req) {
        StringBuffer buff = new StringBuffer();
        if (req.getServletPath() != null) {
            buff.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            buff.append(req.getPathInfo());
        }
        return buff.toString();
    }

    public static String getRequest(HttpServletRequest req) {
        String query = req.getQueryString();
        return ServletUtil.getRequestBase(req) + (query == null ? "" : "?" + req.getQueryString());
    }

    public static String getFileURL(String filename) {
        filename = filename.replace('\\', '/');
        filename = StringUtil.replace(filename, ' ', "%20");
        return "file:///" + filename;
    }

    public static String getFileURL2(String filename) {
        File f = new File(filename);
        try {
            String s = f.toURL().toString();
            return s;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void showRequestDetail(HttpServlet servlet, HttpServletRequest req, PrintStream out) {
        out.println("Request Info");
        out.println(" req.getServerName(): " + req.getServerName());
        out.println(" req.getServerPort(): " + req.getServerPort());
        out.println(" req.getContextPath:" + req.getContextPath());
        out.println(" req.getServletPath:" + req.getServletPath());
        out.println(" req.getPathInfo:" + req.getPathInfo());
        out.println(" req.getQueryString:" + req.getQueryString());
        out.println(" req.getRequestURI:" + req.getRequestURI());
        out.println(" getRequestBase:" + ServletUtil.getRequestBase(req));
        out.println(" getRequest:" + ServletUtil.getRequest(req));
        out.println(" ------------------");
        out.println(" req.getPathTranslated:" + req.getPathTranslated());
        String path = req.getPathTranslated();
        if (path != null) {
            ServletContext context = servlet.getServletContext();
            out.println(" getMimeType:" + context.getMimeType(path));
        }
        out.println();
        out.println(" req.getScheme:" + req.getScheme());
        out.println(" req.getProtocol:" + req.getProtocol());
        out.println(" req.getMethod:" + req.getMethod());
        out.println();
        out.println(" req.getContentType:" + req.getContentType());
        out.println(" req.getContentLength:" + req.getContentLength());
        out.println(" req.getRemoteAddr():" + req.getRemoteAddr());
        try {
            out.println(" getRemoteHost():" + InetAddress.getByName(req.getRemoteHost()).getHostName());
        }
        catch (UnknownHostException e) {
            out.println(" getRemoteHost():" + e.getMessage());
        }
        out.println(" getRemoteUser():" + req.getRemoteUser());
        out.println();
        out.println("Request Parameters:");
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                out.println("  " + name + "  (" + i + "): " + values[i]);
            }
        }
        out.println();
        out.println("Request Headers:");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                out.println("  " + name + ": " + value);
            }
        }
    }

    public static void showSession(HttpServletRequest req, HttpServletResponse res, PrintStream out) {
        HttpSession session = req.getSession();
        Integer count = (Integer)session.getAttribute("snoop.count");
        count = count == null ? new Integer(1) : new Integer(count + 1);
        session.setAttribute("snoop.count", (Object)count);
        out.println("<HTML><HEAD><TITLE>SessionSnoop</TITLE></HEAD>");
        out.println("<BODY><H1>Session Snoop</H1>");
        out.println("You've visited this page " + count + (count == 1 ? " time." : " times."));
        out.println("<P>");
        out.println("<H3>Here is your saved session data:</H3>");
        Enumeration enumeration = session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            out.println(name + ": " + session.getAttribute(name) + "<BR>");
        }
        out.println("<H3>Here are some vital stats on your session:</H3>");
        out.println("Session id: " + session.getId() + " <I>(keep it secret)</I><BR>");
        out.println("New session: " + session.isNew() + "<BR>");
        out.println("Timeout: " + session.getMaxInactiveInterval());
        out.println("<I>(" + session.getMaxInactiveInterval() / 60 + " minutes)</I><BR>");
        out.println("Creation time: " + session.getCreationTime());
        out.println("<I>(" + new Date(session.getCreationTime()) + ")</I><BR>");
        out.println("Last access time: " + session.getLastAccessedTime());
        out.println("<I>(" + new Date(session.getLastAccessedTime()) + ")</I><BR>");
        out.println("Requested session ID from cookie: " + req.isRequestedSessionIdFromCookie() + "<BR>");
        out.println("Requested session ID from URL: " + req.isRequestedSessionIdFromURL() + "<BR>");
        out.println("Requested session ID valid: " + req.isRequestedSessionIdValid() + "<BR>");
        out.println("<H3>Test URL Rewriting</H3>");
        out.println("Click <A HREF=\"" + res.encodeURL(req.getRequestURI()) + "\">here</A>");
        out.println("to test that session tracking works via URL");
        out.println("rewriting even when cookies aren't supported.");
        out.println("</BODY></HTML>");
    }

    private static String getServerInfoName(String serverInfo) {
        int slash = serverInfo.indexOf(47);
        if (slash == -1) {
            return serverInfo;
        }
        return serverInfo.substring(0, slash);
    }

    private static String getServerInfoVersion(String serverInfo) {
        int slash = serverInfo.indexOf(47);
        if (slash == -1) {
            return null;
        }
        int space = serverInfo.indexOf(32, slash);
        if (space == -1) {
            space = serverInfo.length();
        }
        return serverInfo.substring(slash + 1, space);
    }

    public static void main(String[] args) {
        String s = "C:/Program Files/you";
        System.out.println("FileURL = " + ServletUtil.getFileURL(s));
        System.out.println("FileURL2 = " + ServletUtil.getFileURL2(s));
    }
}

