/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DebugHandler {
    private static DebugHandler dh;
    private LinkedHashMap actions = new LinkedHashMap();

    public static DebugHandler getGlobalInstance() {
        if (dh == null) {
            dh = new DebugHandler();
        }
        return dh;
    }

    public void addAction(Action act) {
        this.actions.put(act.name, act);
    }

    public void doDebug(HttpServlet thisServlet, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods_debug");
        PrintStream pw = new PrintStream((OutputStream)response.getOutputStream());
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title> THREDDS Debug</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<img src='thredds.jpg' >");
        pw.println("<h2>Debug Actions</h2>");
        pw.println("<body><pre>");
        String cmds = request.getQueryString();
        if (cmds == null || cmds.length() == 0) {
            this.showDebugActions(request, response, pw);
        } else {
            StringTokenizer tz = new StringTokenizer(cmds, ";");
            while (tz.hasMoreTokens()) {
                Action action;
                String cmd = tz.nextToken();
                String target = null;
                pw.println("Cmd= " + cmd);
                int pos = cmd.indexOf(61);
                if (pos >= 0) {
                    target = cmd.substring(pos + 1);
                    cmd = cmd.substring(0, pos);
                }
                if ((action = (Action)this.actions.get(cmd)) == null) {
                    pw.println(" Unknown action= <" + cmd + ">");
                    continue;
                }
                action.doAction(new Event(request, response, pw, target));
            }
        }
        pw.println("</pre></body>");
        pw.flush();
        response.setStatus(200);
    }

    private void showDebugActions(HttpServletRequest req, HttpServletResponse res, PrintStream pw) {
        Iterator iter = this.actions.values().iterator();
        while (iter.hasNext()) {
            Action act = (Action)iter.next();
            if (act.desc == null) continue;
            String url = req.getRequestURI() + "?" + act.name;
            pw.println("   <a href='" + url + "'>" + act.desc + "</a>");
        }
    }

    public static class Event {
        public HttpServletRequest req;
        public HttpServletResponse res;
        public PrintStream pw;
        public String nextToken;

        public Event(HttpServletRequest req, HttpServletResponse res, PrintStream pw, String nextToken) {
            this.req = req;
            this.res = res;
            this.pw = pw;
            this.nextToken = nextToken;
        }
    }

    public static abstract class Action {
        public String name;
        public String desc;

        public Action(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public abstract void doAction(Event var1);
    }
}

