/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsDefault;
import thredds.servlet.ViewManager;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class CatalogSubset
extends ThreddsDefault {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String catURL;
            if (Debug.isSet("showRequest")) {
                System.out.println("**CatalogSubset req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                ServletUtil.showRequestDetail(this, req, System.out);
            }
            if ((catURL = req.getParameter("catalog")) == null) {
                String reqBase = ServletUtil.getRequestBase(req);
                URI reqURI = new URI(reqBase);
                URI catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
            }
            log.printIfSet("showCatalog", "CatalogSubset: catalog = " + catURL);
            String datasetID = null;
            datasetID = req.getParameter("dataset");
            if (datasetID == null) {
                log.error("CatalogSubset: must have dataset query parameter" + ServletUtil.getRequest(req));
                res.sendError(400, "must have dataset query parameter");
                return;
            }
            log.printIfSet("showCatalog", "CatalogServices: dataset = " + datasetID);
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
            InvCatalogImpl catalog = null;
            try {
                catalog = catFactory.readXML(catURL);
            }
            catch (Exception e) {
                ServletUtil.handleException(e, res);
                return;
            }
            StringBuffer sb = new StringBuffer();
            if (!catalog.check(sb, false)) {
                PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
                res.setContentType("text/html");
                this.showValidationMesssage(catURL, sb.toString(), pw);
                res.setHeader("Validate", "FAIL");
                pw.flush();
                return;
            }
            System.out.println("validation= " + sb);
            InvDataset dataset = catalog.findDatasetByID(datasetID);
            if (dataset == null) {
                log.error("CatalogSubset: cant find dataset=" + datasetID);
                res.sendError(400, "Cant find dataset=" + datasetID);
                return;
            }
            ServletOutputStream os = res.getOutputStream();
            if (req.getServletPath().equals("/subset.xml")) {
                catalog.subset(dataset);
                res.setContentType("text/xml");
                catalog.writeXML((OutputStream)os);
            } else {
                res.setContentType("text/html");
                StringBuffer sbuff = new StringBuffer(20000);
                sbuff.append("<html>");
                sbuff.append("<head>");
                sbuff.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
                sbuff.append("</head>");
                sbuff.append("<body bgcolor=\"#FFF0FF\">");
                sbuff.append("<img src='thredds.jpg' >");
                sbuff.append("<h1>THREDDS Dataset</h1>");
                InvDatasetImpl.writeHtmlDescription(sbuff, (InvDatasetImpl)dataset, false, false, false);
                ViewManager.showViewers(sbuff, (InvDatasetImpl)dataset);
                sbuff.append("</body></html>");
                os.write(sbuff.toString().getBytes());
            }
            os.flush();
            res.setStatus(200);
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
    }

    private void showValidationMesssage(String catURL, String mess, PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title> Catalog Validation</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<h2> Catalog " + catURL + " has validation errors:</h2>");
        pw.println("<b>");
        pw.println(StringUtil.quoteHtmlContent(mess));
        pw.println("</b>");
        pw.println("<hr><pre>");
        String catString = IO.readURLcontents(catURL);
        pw.println(StringUtil.quoteHtmlContent(catString));
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

