/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDocumentation;
import thredds.catalog.ServiceType;
import thredds.servlet.Debug;
import thredds.servlet.Log;
import thredds.servlet.ServletUtil;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class CatalogHtml
extends HttpServlet {
    private static Log log;

    public void init() {
        ServletUtil.initDebugging(this);
        ServletUtil.initLogging(this);
        log = new Log(((Object)((Object)this)).getClass().getName(), true);
        log.println("-----CatalogHtml initialized");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            boolean validate;
            URI catURI;
            boolean isDefaultCatalog;
            if (Debug.isSet("showRequest")) {
                System.out.println("**CatalogHtml req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                ServletUtil.showRequestDetail(this, req, System.out);
            }
            String path = ServletUtil.getRequestPath(req);
            String reqBase = ServletUtil.getRequestBase(req);
            URI reqURI = new URI(reqBase);
            String catURL = req.getParameter("catalog");
            String internalURL = null;
            boolean bl = isDefaultCatalog = catURL == null || catURL.length() == 0;
            if (isDefaultCatalog) {
                catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
                internalURL = ServletUtil.getFileURL(ServletUtil.getContentPath(this) + "catalog.xml");
                log.printIfSet("showCatalog", "CatalogHtml: Getting default catalog = " + catURL + " internal url = " + internalURL);
            } else {
                log.printIfSet("showCatalog", "CatalogHtml: Getting catalog = " + catURL);
                catURI = new URI(catURL);
                if (!catURI.isAbsolute()) {
                    internalURL = ServletUtil.getFileURL(ServletUtil.getContentPath(this) + catURL);
                    catURI = reqURI.resolve(catURI);
                    catURL = catURI.toString();
                    log.printIfSet("showCatalog", "CatalogHtml: Reletive catalog = " + catURL + " internal = " + internalURL);
                } else {
                    internalURL = catURL;
                }
            }
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
            InvCatalogImpl catalog = null;
            try {
                catalog = catFactory.readXML(internalURL);
            }
            catch (Exception e) {
                ServletUtil.handleException(e, res);
                return;
            }
            if (req.getServletPath().equals("/convert")) {
                this.doConvert(catalog, res);
                return;
            }
            boolean debug = false;
            boolean bl2 = validate = req.getServletPath().equals("/validate") || req.getParameter("validate") != null;
            if (validate && req.getParameter("debug") != null) {
                debug = true;
            }
            StringBuffer validateMess = new StringBuffer();
            catalog.check(validateMess, debug);
            boolean isFatal = catalog.hasFatalError();
            if (isFatal) {
                PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
                res.setContentType("text/html");
                this.showFatalMesssage(catURL, validateMess.toString(), pw);
                res.setHeader("Validate", "FAIL");
                pw.flush();
                return;
            }
            if (validate) {
                res.setHeader("Validate", "OK");
            }
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            res.setContentType("text/html");
            this.writeHTML(reqBase, catURL, catalog, validate ? validateMess.toString() : null, pw);
            pw.flush();
            res.setStatus(200);
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
    }

    private void doConvert(InvCatalogImpl catalog, HttpServletResponse res) {
        catalog.setCatalogConverterToVersion1();
        try {
            ServletOutputStream os = res.getOutputStream();
            res.setContentType("text/xml");
            catalog.writeXML((OutputStream)os);
            res.setStatus(200);
            os.flush();
        }
        catch (IOException ioe) {
            ServletUtil.handleException(ioe, res);
        }
    }

    private void writeHTML(String reqBase, String catURL, InvCatalogImpl catalog, String validateMess, PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head>");
        if (catalog.getName() != null) {
            pw.println("<title>" + this.makeCatalogName(catURL, catalog) + "</title>");
        }
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        if (catURL.length() != 0) {
            pw.println("<base href='" + catURL + "' >");
        }
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<img src='thredds.jpg' >");
        if (validateMess != null) {
            pw.println("<h2> Catalog " + this.makeCatalogName(catURL, catalog) + " is Valid</h2>");
            pw.println("<b>");
            pw.println(StringUtil.quoteHtmlContent(validateMess));
            pw.println("</b>");
        } else {
            pw.println("<h2>" + this.makeCatalogName(catURL, catalog) + "</h2>");
        }
        InvDataset root = catalog.getDataset();
        this.showDataset(reqBase, catURL, root, 0, pw);
        pw.println("</body>");
        pw.println("</html>");
    }

    private String makeCatalogName(String catURL, InvCatalogImpl catalog) {
        if (catalog.getName() != null) {
            return catalog.getName() + " (" + catURL + ")";
        }
        return catURL;
    }

    private void showDataset(String reqBase, String catURL, InvDataset ds, int level, PrintWriter pw) {
        if (ds instanceof InvCatalogRef) {
            InvCatalogRef ref = (InvCatalogRef)ds;
            pw.println("<li>CatalogRef: <b><a href='" + reqBase + "?catalog=" + ref.getXlinkHref() + "'>" + ds.getName() + "</a></b>");
            return;
        }
        pw.print(level == 0 ? "<h3>" : "<li>Dataset ");
        pw.print("<b>" + ds.getName() + "</b> ");
        if (ds.getID() != null) {
            pw.print("<a href='subset.html?catalog=" + catURL + "&dataset=" + ds.getID() + "'> (complete metadata)</a></b>");
        }
        pw.println(" :");
        pw.print(level == 0 ? "</h3>" : "");
        List docs = ds.getDocumentation();
        List accessList = ds.getAccess();
        if (docs.size() > 0 && accessList.size() > 1) {
            this.showDocumentation(pw, docs);
        }
        if (ds.hasAccess()) {
            if (accessList.size() > 1) {
                pw.println("<ol>");
            }
            for (int i = 0; i < accessList.size(); ++i) {
                InvAccessImpl access = (InvAccessImpl)accessList.get(i);
                if (accessList.size() > 1) {
                    pw.println("<li>");
                }
                this.showAccess(pw, ds.getName(), access, access.getService().getServiceType());
            }
            if (accessList.size() > 1) {
                pw.println("</ol>");
            }
        }
        if (docs.size() > 0 && accessList.size() <= 1) {
            this.showDocumentation(pw, docs);
        }
        if (ds.hasNestedDatasets()) {
            pw.println("<ul>");
            List datasets = ds.getDatasets();
            for (int i = 0; i < datasets.size(); ++i) {
                InvDataset cc = (InvDataset)datasets.get(i);
                this.showDataset(reqBase, catURL, cc, level + 1, pw);
            }
            pw.println("</ul><p>");
        }
    }

    private void showAccess(PrintWriter pw, String name, InvAccessImpl access, ServiceType stype) {
        String urlName = access.getUnresolvedUrlName();
        if (ServiceType.DODS == stype) {
            pw.print("<b> " + name + ":</b> ");
            pw.print(" <a href='" + urlName + ".dds'>DDS</a> ");
            pw.print(" <a href='" + urlName + ".das'>DAS</a> ");
            pw.print(" <a href='" + urlName + ".info'>Information</a> ");
            pw.print(" <a href='" + urlName + ".html'>Data Request Form</a> ");
        } else {
            pw.print("<a href='" + urlName + "'>" + name + "</a> (" + stype + ") ");
        }
        pw.println();
    }

    private void showDocumentation(PrintWriter pw, List docs) {
        pw.println("<blockquote>");
        for (int i = 0; i < docs.size(); ++i) {
            if (i > 0) {
                pw.print("<p>");
            }
            this.showOneDoc(pw, (InvDocumentation)docs.get(i));
        }
        pw.println("</blockquote> ");
    }

    private void showOneDoc(PrintWriter pw, InvDocumentation doc) {
        String inline = doc.getInlineContent().trim();
        if (inline != null && inline.length() > 0) {
            pw.println(inline);
        }
        if (doc.hasXlink()) {
            pw.println(" <a href='" + doc.getXlinkHref() + "'>" + doc.getXlinkTitle() + "</a> ");
        }
    }

    private void showFatalMesssage(String catURL, String mess, PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title> Catalog Validation</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<img src='thredds.jpg' >");
        pw.println("<h2> Catalog " + catURL + " has fatal errors:</h2>");
        pw.println("<b>");
        pw.println(StringUtil.quoteHtmlContent(mess));
        pw.println("</b>");
        pw.println("<hr><pre>");
        String catString = IO.readURLcontents(catURL);
        pw.println(StringUtil.quoteHtmlContent(catString));
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

