/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsDefault;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class CatalogDL
extends ThreddsDefault {
    private static String dataDir = "C:/data/adn";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String catURL;
            boolean isDefaultCatalog;
            if (Debug.isSet("showRequest")) {
                System.out.println("**CatalogDL req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                ServletUtil.showRequestDetail(this, req, System.out);
            }
            boolean bl = isDefaultCatalog = (catURL = req.getParameter("catalog")) == null || catURL.length() == 0;
            if (isDefaultCatalog) {
                String reqBase = ServletUtil.getRequestBase(req);
                URI reqURI = new URI(reqBase);
                URI catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
            }
            log.printIfSet("showCatalog", "CatalogServices: catalog = " + catURL);
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
            InvCatalogImpl catalog = null;
            try {
                catalog = catFactory.readXML(catURL);
            }
            catch (Exception e) {
                ServletUtil.handleException(e, res);
                return;
            }
            System.out.println(" cat parse ok");
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            StringBuffer sb = new StringBuffer();
            if (!catalog.check(sb, false)) {
                res.setContentType("text/html");
                this.showValidationMesssage(catURL, sb.toString(), pw);
                res.setHeader("Validate", "FAIL");
                pw.flush();
                return;
            }
            System.out.println(" cat validate ok");
            res.setContentType("text/html");
            pw.println("<html>");
            pw.println("<head>");
            pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            pw.println("</head>");
            pw.println("<body bgcolor=\"#FFF0FF\">");
            pw.println("<img src='thredds.jpg' >");
            pw.println("<h1> Catalog " + catURL + "</h2>");
            pw.println("<h2>ADN records:</h2>");
            ADNWriter adn = new ADNWriter();
            StringBuffer mess = new StringBuffer();
            adn.writeDatasetEntries(catalog, dataDir, mess);
            StringUtil.substitute(mess, "\n", "\n<p>");
            pw.println(mess.toString());
            System.out.println(" ADN ok");
            pw.println("<h2>DIF records:</h2>");
            DIFWriter w = new DIFWriter();
            mess.setLength(0);
            w.writeDatasetEntries(catalog, "C:/temp/dif", mess);
            StringUtil.substitute(mess, "\n", "\n<p>");
            pw.println(mess.toString());
            System.out.println(" DIF ok");
            pw.println("</body></html>");
            pw.flush();
            res.setStatus(200);
            System.out.println(" done");
        }
        catch (Throwable t) {
            t.printStackTrace();
            ServletUtil.handleException(t, res);
        }
    }

    private void doDIF(InvCatalogFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            InvCatalogImpl cat = fac.readXML(url);
            StringBuffer buff = new StringBuffer();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            DIFWriter w = new DIFWriter();
            StringBuffer sbuff = new StringBuffer();
            w.writeDatasetEntries(cat, "C:/temp/dif", sbuff);
            System.out.println(" messages=\n" + sbuff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doADN(InvCatalogFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            InvCatalogImpl cat = fac.readXML(url);
            StringBuffer buff = new StringBuffer();
            boolean isValid = cat.check(buff, false);
            System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            System.out.println(" validation output=\n" + buff);
            ADNWriter w = new ADNWriter();
            StringBuffer sbuff = new StringBuffer();
            w.writeDatasetEntries(cat, "C:/temp/adn", sbuff);
            System.out.println(" messages=\n" + sbuff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showValidationMesssage(String catURL, String mess, PrintWriter pw) {
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title> Catalog Validation</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<h2> Catalog " + catURL + " has validation errors:</h2>");
        pw.println("<b>");
        pw.println(StringUtil.quoteHtmlContent(mess));
        pw.println("</b>");
        pw.println("<hr><pre>");
        String catString = IO.readURLcontents(catURL);
        pw.println(StringUtil.quoteHtmlContent(catString));
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

