/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.servlet.Debug;
import thredds.servlet.Log;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsDefault;
import thredds.servlet.View;
import thredds.util.IO;

public class CatalogAnnotate
extends ThreddsDefault {
    protected static String rootPath;
    protected static String contentPath;
    protected static Log log;
    private static String reletiveDir;
    private static boolean debug;

    public void init() {
        rootPath = ServletUtil.getRootPath(this);
        contentPath = ServletUtil.getContentPath(this);
        log = new Log(((Object)((Object)this)).getClass().getName(), true);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String catURL;
            boolean isDefaultCatalog;
            if (Debug.isSet("showRequest")) {
                System.out.println("**CatalogAnnotate get=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                ServletUtil.showRequestDetail(this, req, System.out);
            }
            boolean bl = isDefaultCatalog = (catURL = req.getParameter("catalog")) == null || catURL.length() == 0;
            if (isDefaultCatalog) {
                String reqBase = ServletUtil.getRequestBase(req);
                URI reqURI = new URI(reqBase);
                URI catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
            }
            log.printIfSet("showCatalog", "CatalogServices: catalog = " + catURL);
            String datasetID = null;
            datasetID = req.getParameter("dataset");
            if (datasetID == null) {
                log.error("CatalogAnnotate: must have dataset query parameter" + ServletUtil.getRequest(req));
                res.sendError(400, "must have dataset query parameter");
                return;
            }
            log.printIfSet("showCatalog", "CatalogServices: dataset = " + datasetID);
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            res.setContentType("text/html");
            pw.println("<html>");
            pw.println("<head>");
            pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
            pw.println("</head>");
            pw.println("<body bgcolor=\"#FFF0FF\">");
            pw.println("<img src='thredds.jpg' >");
            pw.println("<h2> Catalog (" + catURL + ")</h2>");
            pw.println("<h3> Dataset (" + datasetID + ")</h3><ul>");
            List views = View.findViews(catURL, datasetID, "IDV");
            for (int i = 0; i < views.size(); ++i) {
                View v = (View)views.get(i);
                String href = reletiveDir + v.jnlpFilename;
                pw.println("<li> <a href='" + href + "'>" + v.title + "</a> " + v.desc);
            }
            pw.println("</ul></body></html>");
            pw.flush();
            res.setStatus(200);
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            String catURL;
            boolean isDefaultCatalog;
            if (Debug.isSet("showRequest")) {
                System.out.println("**CatalogAnnotate post=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                ServletUtil.showRequestDetail(this, req, System.out);
            }
            boolean bl = isDefaultCatalog = (catURL = req.getParameter("catalog")) == null || catURL.length() == 0;
            if (isDefaultCatalog) {
                String reqBase = ServletUtil.getRequestBase(req);
                URI reqURI = new URI(reqBase);
                URI catURI = reqURI.resolve("catalog.xml");
                catURL = catURI.toString();
            }
            log.printIfSet("showCatalog", "CatalogServices: catalog = " + catURL);
            String datasetID = null;
            datasetID = req.getParameter("dataset");
            if (datasetID == null) {
                log.error("CatalogAnnotate: must have dataset query parameter" + ServletUtil.getRequest(req));
                res.sendError(400, "must have dataset query parameter");
                return;
            }
            log.printIfSet("showCatalog", "CatalogServices: dataset = " + datasetID);
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
            InvCatalogImpl catalog = null;
            try {
                catalog = catFactory.readXML(catURL);
            }
            catch (Exception e) {
                ServletUtil.handleException(e, res);
                return;
            }
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            String jnlpString = req.getParameter("jnlp");
            File dir = new File(contentPath + reletiveDir);
            try {
                File jnlpFile = File.createTempFile("IDV", ".jnlp", dir);
                IO.writeToFile(jnlpString, jnlpFile);
                String title = req.getParameter("title");
                String desc = req.getParameter("description");
                View.add(new View(catURL, datasetID, title, desc, jnlpFile.getName(), "IDV"));
                pw.println("\nOK");
                res.setStatus(200);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                res.sendError(500, "ERROR= " + ioe);
            }
            pw.flush();
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
    }

    static {
        reletiveDir = "views/";
        debug = false;
    }
}

