/*
 * Decompiled with CFR 0.152.
 */
package thredds.datatype;

import java.text.ParseException;
import thredds.datatype.DateType;
import ucar.nc2.units.TimeUnit;

public class TimeDuration {
    private String text;
    private TimeUnit timeUnit;
    private boolean isBlank;

    public TimeDuration(TimeDuration src) {
        this.text = src.getText();
        this.timeUnit = src.getTimeUnit();
        this.isBlank = src.isBlank();
    }

    public TimeDuration(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.text = timeUnit.toString();
    }

    public TimeDuration(String text) throws ParseException {
        this.text = text = text == null ? "" : text.trim();
        if (text.length() == 0) {
            this.isBlank = true;
            return;
        }
        try {
            this.timeUnit = new TimeUnit(text);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public double getSeconds() {
        return this.timeUnit.getSeconds();
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        if (this.isBlank()) {
            return 0;
        }
        return this.timeUnit.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateType)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    private static void doDuration(String s) {
        try {
            System.out.println("start = (" + s + ")");
            TimeDuration d = new TimeDuration(s);
            System.out.println("duration = (" + d.toString() + ")");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TimeDuration.doDuration("3 days");
    }
}

