/*
 * Decompiled with CFR 0.152.
 */
package thredds.datatype;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import thredds.datatype.TimeDuration;
import ucar.nc2.units.DateUnit;

public class DateType {
    private static SimpleDateFormat xsdDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat xsdDateTimeFormat;
    private static SimpleDateFormat stdDateTimeFormat;
    private String text;
    private String format;
    private String type;
    private boolean isPresent;
    private boolean isBlank;
    private Date date;
    private Calendar cal = null;

    public static String hiddenProperties() {
        return "text blank present";
    }

    public DateType(boolean isPresent, Date date) {
        this.isPresent = isPresent;
        this.date = date;
        if (isPresent) {
            this.text = "present";
        }
    }

    public DateType() {
        this.isBlank = true;
    }

    public DateType(DateType src) {
        this.text = src.getText();
        this.format = src.getFormat();
        this.type = src.getType();
        this.isPresent = src.isPresent();
        this.isBlank = src.isBlank();
        this.date = src.getDate();
        if (this.isPresent) {
            this.text = "present";
        }
    }

    public DateType(String text, String format, String type) throws ParseException {
        ParseException p = null;
        this.text = text = text == null ? "" : text.trim();
        this.format = format;
        this.type = type;
        if (text.length() == 0) {
            this.isBlank = true;
            return;
        }
        if (format != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            this.date = dateFormat.parse(text);
            return;
        }
        this.isPresent = text.equalsIgnoreCase("present");
        if (this.isPresent) {
            this.date = new Date();
            return;
        }
        if (text.indexOf("since") > 0) {
            this.date = DateUnit.getStandardDate(text);
            if (this.date == null) {
                throw new ParseException("invalid udunit date unit", 0);
            }
            return;
        }
        try {
            this.date = xsdDateTimeFormat.parse(text);
            return;
        }
        catch (ParseException e) {
            p = e;
            try {
                this.date = xsdDateFormat.parse(text);
                return;
            }
            catch (ParseException e2) {
                p = e2;
                throw p;
            }
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.text = this.toDateTimeString();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.toDateTimeString();
        }
        return this.text;
    }

    public String getFormat() {
        return this.format;
    }

    public String getType() {
        return this.type;
    }

    public boolean before(Date d) {
        if (this.isPresent()) {
            return false;
        }
        return this.date.before(d);
    }

    public boolean after(Date d) {
        if (this.isPresent()) {
            return true;
        }
        return this.date.after(d);
    }

    public String toDateString() {
        return xsdDateFormat.format(this.date);
    }

    public String toDateTimeString() {
        return stdDateTimeFormat.format(this.date);
    }

    public String toDateTimeStringISO() {
        return xsdDateTimeFormat.format(this.date);
    }

    public String toString() {
        return this.getText();
    }

    public int hashCode() {
        if (this.isBlank()) {
            return 0;
        }
        if (this.isPresent()) {
            return 1;
        }
        if (this.date != null) {
            return this.date.hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateType)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public DateType add(TimeDuration d) {
        Date useDate;
        Date date = useDate = this.isPresent ? new Date() : this.date;
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
        }
        this.cal.setTime(useDate);
        this.cal.add(13, (int)d.getSeconds());
        return new DateType(false, (Date)this.cal.getTime().clone());
    }

    public DateType subtract(TimeDuration d) {
        Date useDate;
        Date date = useDate = this.isPresent ? new Date() : this.date;
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
        }
        this.cal.setTime(useDate);
        this.cal.add(13, (int)(-d.getSeconds()));
        return new DateType(false, (Date)this.cal.getTime().clone());
    }

    private static void doOne(String s) {
        try {
            System.out.println("\nStart = (" + s + ")");
            DateType d = new DateType(s, null, null);
            System.out.println("Date = (" + d.toString() + ")");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DateType.doOne("1991-11-16");
        DateType.doOne("1991-11-16T12:00:00");
        DateType.doOne("1991-11-16T16:03:09");
        DateType.doOne("5 hours since 1991-11-16");
        DateType.doOne("3600 secs since 1991-11-16");
        DateType.doOne("36000 secs since 1991-11-16 01:00:00");
        DateType.doOne("5 days since 1991-11-16");
        DateType.doOne("5 days since 1991-11-16T12:00:00");
        DateType.doOne("5 days since 1991-BADDOG!:00");
    }

    static {
        xsdDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        xsdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        xsdDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        stdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        stdDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

