/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.servlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import thredds.cataloggen.CatalogGen;

public class CatGenTimerTask
extends TimerTask
implements Cloneable {
    private static Logger logger = Logger.getLogger((String)CatGenTimerTask.class.getName());
    private String name = null;
    private File configDocPath = null;
    private String configDocName = null;
    private File configDoc = null;
    private URL configDocURL = null;
    private File resultPath = null;
    private String resultFileName = null;
    private File resultFile = null;
    private int periodInMinutes = 0;
    private int delayInMinutes = 0;

    public CatGenTimerTask() {
    }

    public CatGenTimerTask(String name, String configDocName, String resultFileName, int periodInMinutes, int delayInMinutes) {
        this.name = name;
        this.configDocName = configDocName;
        this.resultFileName = resultFileName;
        this.periodInMinutes = periodInMinutes;
        this.delayInMinutes = delayInMinutes;
    }

    public CatGenTimerTask(CatGenTimerTask task) {
        this.name = task.getName();
        this.configDocName = task.getConfigDocName();
        this.resultFileName = task.getResultFileName();
        this.periodInMinutes = task.getPeriodInMinutes();
        this.delayInMinutes = task.getDelayInMinutes();
    }

    public void init(File resultPath, File configDocPath) {
        this.resultPath = resultPath;
        this.configDocPath = configDocPath;
        this.configDoc = new File(this.configDocPath, this.configDocName);
        try {
            URI tmpURI = this.configDoc.toURI();
            this.configDocURL = tmpURI.toURL();
        }
        catch (MalformedURLException e) {
            logger.error((Object)"init(): Config Doc to URL caused MallformedURLException");
            logger.error((Object)e.getMessage());
        }
        this.resultFile = new File(this.resultPath, this.resultFileName);
        if (!this.resultFile.exists() && !this.resultFile.getParentFile().exists()) {
            if (this.resultFile.getParentFile().mkdirs()) {
                logger.info((Object)("init(): Created directory \"" + this.resultFile.getParentFile().getAbsolutePath() + "\"."));
            } else {
                logger.warn((Object)("init(): Could not creat directory \"" + this.resultFile.getParentFile().getAbsolutePath() + "\", result file " + "(" + this.resultFile.getAbsolutePath() + ")invalid."));
            }
        }
        logger.debug((Object)("init(): result path is " + this.resultPath.toString()));
        logger.debug((Object)("init(): config doc path is " + this.configDocPath.toString()));
        logger.debug((Object)("init(): config doc URL is " + this.configDocURL.toString()));
        logger.debug((Object)("init(): config doc is " + this.configDoc.toString()));
        logger.debug((Object)("init(): result file is " + this.resultFile.toString()));
    }

    public boolean isValid(StringBuffer messages) {
        boolean isValid = true;
        String tmpMsg = null;
        logger.debug((Object)("isValid(): Check name <" + this.getName() + "> for validity."));
        if (this.getName() == null) {
            tmpMsg = "Tasks name not set (null).";
            logger.debug((Object)("isValid(): " + tmpMsg));
            messages.append("CatGenTimerTask.isValid(): " + tmpMsg);
            isValid = false;
        }
        if (this.getName().equals("")) {
            tmpMsg = "Task name is empty (\"\").";
            logger.debug((Object)("isValid(): " + tmpMsg));
            messages.append("CatGenTimerTask.isValid(): " + tmpMsg);
            isValid = false;
        }
        logger.debug((Object)("isValid(): If period is not zero <" + this.getPeriodInMinutes() + "> check validity."));
        if (this.getPeriodInMinutes() != 0) {
            CatalogGen catGen = new CatalogGen(this.configDocURL);
            if (!catGen.isValid(messages)) {
                logger.debug((Object)("isValid(): config doc <" + this.configDocURL + "> is not valid."));
                isValid = false;
            }
            if (this.resultFile.exists()) {
                if (!this.resultFile.canWrite()) {
                    messages.append("CatGenTimerTask.isValid() - result file not writeable.");
                    logger.warn((Object)"isValid(): Result file is not writable.");
                    isValid = false;
                }
            } else {
                try {
                    if (!this.resultFile.createNewFile()) {
                        messages.append("CatGenTimerTask.isValid() - result file (" + this.resultFile.getPath() + ") doesn't exist and can't be created (1).");
                        isValid = false;
                    }
                }
                catch (IOException e) {
                    messages.append("CatGenTimerTask.isValid() - result file (" + this.resultFile.getPath() + ") doesn't exist and can't be created (2).");
                    isValid = false;
                }
            }
            if (this.getPeriodInMinutes() < 0) {
                messages.append("CatGenTimerTask.isValid() - period must be zero or above.");
                isValid = false;
            }
            if (this.getDelayInMinutes() < 0) {
                messages.append("CatGenTimerTask.isValid() - delay must be zero or above.");
                isValid = false;
            }
        } else {
            messages.append("CatGenTimerTask.isValid() - period set to zero, skipping all but \"task name\" validity tests.");
        }
        if (isValid) {
            logger.debug((Object)("Config doc valid (" + this.configDoc.toString() + "):"));
            logger.debug((Object)messages.toString());
        } else {
            logger.debug((Object)("Invalid config doc (" + this.configDoc.toString() + "):"));
            logger.debug((Object)messages.toString());
        }
        return isValid;
    }

    public void run() {
        CatalogGen catGen = new CatalogGen(this.configDocURL);
        StringBuffer messages = new StringBuffer();
        if (catGen.isValid(messages)) {
            catGen.expand();
            if (catGen.writeCatalog(this.resultFile.toString())) {
                logger.debug((Object)("run(): Catalog written (" + this.resultFile.toString() + ")."));
            } else {
                logger.debug((Object)("run(): catalog not written (" + this.resultFile.toString() + ")."));
            }
            return;
        }
        logger.error((Object)("run(): Tried running CatalogGen with invalid config doc, " + this.configDocURL.toString() + "\n" + messages.toString()));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setConfigDocName(String configDocName) {
        this.configDocName = configDocName;
    }

    public String getConfigDocName() {
        return this.configDocName;
    }

    public void setResultFileName(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public void setPeriodInMinutes(int periodInMinutes) {
        this.periodInMinutes = periodInMinutes;
    }

    public int getPeriodInMinutes() {
        return this.periodInMinutes;
    }

    public void setDelayInMinutes(int delayInMinutes) {
        this.delayInMinutes = delayInMinutes;
    }

    public int getDelayInMinutes() {
        return this.delayInMinutes;
    }
}

