/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.servlet;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import thredds.cataloggen.servlet.CatGenTimerTask;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class CatGenServletConfig {
    private static Logger logger = Logger.getLogger((String)CatGenServletConfig.class.getName());
    private File resultPath;
    private File configPath;
    private String servletConfigDocName;
    private XMLStore configStore = null;
    private PreferencesExt configPrefs = null;
    private Collection configTasks = null;
    private HashMap configTaskHash = new HashMap();
    private HashMap configTaskHashByConfigDocName = new HashMap();
    private Timer timer = new Timer();

    public CatGenServletConfig(File resultPath, File configPath, String servletConfigDocName) throws IOException {
        this.resultPath = resultPath;
        this.configPath = configPath;
        this.servletConfigDocName = servletConfigDocName;
        if (!this.resultPath.exists() && !this.resultPath.mkdirs()) {
            String tmpMsg = "Creation of results directory failed";
            logger.debug((Object)("CatGenServletConfig(): " + tmpMsg + " <" + this.resultPath.getAbsolutePath() + ">"));
            throw new IOException(tmpMsg);
        }
        if (!this.configPath.exists() && !this.configPath.mkdirs()) {
            String tmpMsg = "Creation of config directory failed";
            logger.debug((Object)("CatGenServletConfig(): " + tmpMsg + " <" + this.configPath.getAbsolutePath() + ">"));
            throw new IOException(tmpMsg);
        }
        File configFile = new File(this.configPath, this.servletConfigDocName);
        if (configFile.createNewFile()) {
            logger.debug((Object)("CatGenServletConfig(): no config file exists, writing empty config file <" + configFile.getAbsolutePath() + ">."));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(configFile));
            XMLStore store = new XMLStore();
            store.save((OutputStream)out);
            ((OutputStream)out).close();
        }
        logger.debug((Object)("CatGenServletConfig(): reading config (" + configFile.toString() + ")"));
        try {
            this.configStore = XMLStore.createFromFile((String)configFile.toString(), null);
        }
        catch (IOException e) {
            logger.error((Object)("CatGenServletConfig(): XMLStore creation failed for " + this.servletConfigDocName));
        }
        this.configPrefs = this.configStore.getPreferences();
        if (this.configPrefs == null) {
            logger.warn((Object)"CatGenServletConfig(): null preferences from the config file (???).");
        }
        this.configTasks = (Collection)this.configPrefs.getBean("config", new ArrayList());
        if (this.configTasks.isEmpty()) {
            logger.debug((Object)"CatGenServletConfig(): task list empty");
        }
        if (!this.configTasks.isEmpty()) {
            logger.debug((Object)"CatGenServletConfig(): at least one task in config file.");
            CatGenTimerTask curTask = null;
            Iterator iter = this.configTasks.iterator();
            while (iter.hasNext()) {
                curTask = (CatGenTimerTask)iter.next();
                curTask.init(this.resultPath, this.configPath);
                this.configTaskHash.put(curTask.getName(), curTask);
                this.configTaskHashByConfigDocName.put(curTask.getConfigDocName(), curTask);
                logger.debug((Object)("CatGenServletConfig(): task name = " + curTask.getName()));
                this.scheduleTask(curTask);
            }
        } else {
            logger.debug((Object)"CatGenServletConfig(): no tasks in config file.");
        }
    }

    public void cancelTimer() {
        this.timer.cancel();
    }

    public String getServletConfigDocName() {
        return this.servletConfigDocName;
    }

    public Iterator getTaskIterator() {
        return this.configTasks.iterator();
    }

    public CatGenTimerTask findTask(String taskName) {
        return (CatGenTimerTask)this.configTaskHash.get(taskName);
    }

    public CatGenTimerTask findTaskByConfigDocName(String configDocName) {
        return (CatGenTimerTask)this.configTaskHashByConfigDocName.get(configDocName);
    }

    public boolean addTask(CatGenTimerTask task) throws IOException {
        logger.debug((Object)"addTask(): start.");
        if (task == null) {
            logger.debug((Object)"addTask(): task to add is null.");
            return false;
        }
        if (this.findTask(task.getName()) != null) {
            logger.debug((Object)("addTask(): task with same name alread exists (" + task.getName() + ")."));
            return false;
        }
        if (this.findTaskByConfigDocName(task.getConfigDocName()) != null) {
            logger.debug((Object)("addTask(): task with same config doc alread exists (" + task.getConfigDocName() + ")."));
            return false;
        }
        task.init(this.resultPath, this.configPath);
        this.configTasks.add(task);
        this.configTaskHash.put(task.getName(), task);
        this.configTaskHashByConfigDocName.put(task.getConfigDocName(), task);
        this.writeConfig();
        this.scheduleTask(task);
        logger.debug((Object)("addTask(): task added (" + task.getName() + ")."));
        return true;
    }

    public boolean removeTask(CatGenTimerTask task) throws IOException {
        logger.debug((Object)"removeTask(): start.");
        if (this.findTask(task.getName()) != null) {
            this.unScheduleTask(task);
            this.configTaskHashByConfigDocName.remove(task.getConfigDocName());
            this.configTaskHash.remove(task.getName());
            this.configTasks.remove(task);
            this.writeConfig();
            logger.debug((Object)("removeTask(): task removed (" + task.getName() + ")."));
            return true;
        }
        logger.debug((Object)"removeTask(): task not in list.");
        return false;
    }

    public boolean removeTask(String taskName) throws IOException {
        return this.removeTask(this.findTask(taskName));
    }

    public void notifyNewConfigDoc(String configDocName) {
        logger.debug((Object)"notifyNewConfigDoc(): start.");
        CatGenTimerTask task = this.findTaskByConfigDocName(configDocName);
        if (task != null) {
            this.unScheduleTask(task);
            CatGenTimerTask newTask = new CatGenTimerTask(task);
            newTask.init(this.resultPath, this.configPath);
            this.scheduleTask(newTask);
            logger.debug((Object)"notifyNewConfigDoc(): done.");
        }
    }

    private boolean scheduleTask(CatGenTimerTask task) {
        logger.debug((Object)"scheduleTask(): start.");
        if (task == null) {
            return false;
        }
        logger.debug((Object)("scheduleTask(): start (" + task.getName() + ")."));
        int periodInMillis = task.getPeriodInMinutes() * 60 * 1000;
        int delayInMins = task.getDelayInMinutes();
        logger.debug((Object)("periodInMillis=" + periodInMillis + " - delayInMins=" + delayInMins + ""));
        if (periodInMillis == 0) {
            logger.debug((Object)"scheduleTask(): period set to zero, do not schedule.");
            return false;
        }
        logger.debug((Object)"scheduleTask(): scheduling task.");
        Calendar cal = Calendar.getInstance();
        if (delayInMins != 0) {
            cal.add(12, delayInMins);
        }
        Date date = cal.getTime();
        this.timer.scheduleAtFixedRate((TimerTask)task, date, (long)periodInMillis);
        logger.debug((Object)"scheduleTask(): task scheduled.");
        return true;
    }

    private boolean unScheduleTask(CatGenTimerTask task) {
        logger.debug((Object)("unScheduleTask(): start: (" + task.getName() + ")."));
        return task.cancel();
    }

    public void writeConfig() throws IOException {
        logger.debug((Object)"writeConfig(): start.");
        this.configPrefs.putBeanCollection("config", this.configTasks);
        this.configStore.save();
    }

    public void writeConfig(OutputStream os) throws IOException {
        logger.debug((Object)"writeConfig(): writing config to XMLStore (OutputStream).");
        this.configPrefs.putBeanCollection("config", this.configTasks);
        this.configStore.save(os);
    }

    public String toHtml() {
        StringBuffer tmpString = new StringBuffer();
        logger.debug((Object)"toHtml(): start.");
        tmpString.append("<html>");
        tmpString.append("<head><title>Catalog Generator Servlet Config</title></head>");
        tmpString.append("<body>");
        tmpString.append("<h1>Catalog Generator Servlet Config</h1>");
        tmpString.append("<hr>");
        tmpString.append("<h2>Currently Scheduled Tasks</h2>");
        tmpString.append("<table border=\"1\">");
        tmpString.append("<tr>");
        tmpString.append("<th> Task Name</th>");
        tmpString.append("<th> Config Filename</th>");
        tmpString.append("<th>");
        tmpString.append("Results Filename");
        tmpString.append("</th>");
        tmpString.append("<th> Period (minutes)</th>");
        tmpString.append("<th> Initial Delay (minutes)</th>");
        tmpString.append("<th> Edit/Delete Task</th>");
        tmpString.append("</tr>");
        CatGenTimerTask curTask = null;
        Iterator iter = this.configTasks.iterator();
        while (iter.hasNext()) {
            curTask = (CatGenTimerTask)iter.next();
            tmpString.append("<tr>");
            tmpString.append("<td>" + curTask.getName() + "</td>");
            tmpString.append("<td> <a href=\"./" + curTask.getConfigDocName() + "\">" + curTask.getConfigDocName() + "</a></td>");
            tmpString.append("<td>");
            tmpString.append(curTask.getResultFileName());
            tmpString.append("</td>");
            tmpString.append("<td>" + curTask.getPeriodInMinutes() + "</td>");
            tmpString.append("<td>" + curTask.getDelayInMinutes() + "</td>");
            tmpString.append("<td>");
            tmpString.append("[<a href=\"./editTask-" + curTask.getConfigDocName() + "\">Edit</a>]");
            tmpString.append("[<a href=\"./deleteTask-" + curTask.getConfigDocName() + "\">Delete</a>]");
            tmpString.append("</td>");
            tmpString.append("</tr>");
        }
        tmpString.append("</table>");
        tmpString.append("<a href=\"./addTask\">Add a new task</a>");
        tmpString.append("<hr>");
        tmpString.append("</body>");
        tmpString.append("</html>");
        logger.debug((Object)"toHtml(): start.");
        return tmpString.toString();
    }
}

