/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import thredds.cataloggen.servlet.CatGenServletConfig;
import thredds.cataloggen.servlet.CatGenTimerTask;
import thredds.servlet.ServletUtil;

public class CatGenServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger((String)CatGenServlet.class.getName());
    private String configFileName;
    private File rootPath;
    private File contentPath;
    private File catGenContentPath;
    private File catGenConfigPath;
    private File catGenResultPath;
    private File catGenStaticContentPath;
    private String catGenServletName = "cataloggen";
    private String catGenDocDirName = "doc";
    private String catGenConfigDirName = "config";
    private String catGenResultCatalogsDirName = "catalogs";
    private String adminPath = "/admin";
    private String adminAddTaskPath = "/admin/addTask";
    private String adminEditTaskPath = "/admin/editTask-";
    private String adminDeleteTaskPath = "/admin/deleteTask-";
    private String adminDoAddTaskPath = "/admin/doAddTask";
    private String adminDoEditTaskPath = "/admin/doEditTask-";
    private String adminDoDeleteTaskPath = "/admin/doDeleteTask-";
    private CatGenServletConfig mainConfig = null;

    public void init() throws ServletException {
        ServletUtil.initLogging(this);
        this.rootPath = new File(ServletUtil.getRootPath(this));
        this.catGenStaticContentPath = new File(this.rootPath, this.catGenServletName);
        this.contentPath = new File(ServletUtil.getContentPath(this));
        this.catGenContentPath = new File(this.contentPath, this.catGenServletName);
        this.catGenConfigPath = new File(this.catGenContentPath, this.catGenConfigDirName);
        this.catGenResultPath = new File(this.catGenContentPath, this.catGenResultCatalogsDirName);
        this.configFileName = this.getInitParameter("configFile");
        logger.debug((Object)("init(): root path = " + this.rootPath.toString()));
        logger.debug((Object)("init(): CatGen static content path = " + this.catGenStaticContentPath.toString()));
        logger.debug((Object)("init(): content path = " + this.contentPath.toString()));
        logger.debug((Object)("init(): CatGen content path = " + this.catGenContentPath.toString()));
        logger.debug((Object)("init(): CatGen config path = " + this.catGenConfigPath.toString()));
        logger.debug((Object)("init(): CatGenServlet config file = " + this.configFileName));
        logger.debug((Object)("init(): CatGen result path = " + this.catGenResultPath.toString()));
        String initialContentPath = ServletUtil.getInitialContentPath(this);
        try {
            ServletUtil.copyDir(initialContentPath, this.contentPath.getAbsolutePath());
            logger.debug((Object)("init(): copied initial content directory <" + initialContentPath + "> to the content directory <" + this.contentPath + ">."));
        }
        catch (IOException ioe) {
            String tmpMsg = "Failed to copy " + initialContentPath + " to " + this.contentPath;
            logger.error((Object)("init(): " + tmpMsg), (Throwable)ioe);
            throw new ServletException(tmpMsg + ": " + ioe.getMessage(), (Throwable)ioe);
        }
        try {
            this.mainConfig = new CatGenServletConfig(this.catGenResultPath, this.catGenConfigPath, this.configFileName);
        }
        catch (IOException e) {
            String tmpMsg = "Reading config file failed";
            logger.error((Object)("init(): " + tmpMsg), (Throwable)e);
            throw new ServletException(tmpMsg + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        logger.debug((Object)"destroy()");
        this.mainConfig.cancelTimer();
        super.destroy();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        logger.info((Object)("doGet(): path = " + path));
        PrintWriter out = null;
        if (path == null) {
            res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + req.getServletPath() + "/"));
            return;
        }
        if (path.equals("/")) {
            out = res.getWriter();
            res.setContentType("text/html");
            out.print(this.getHtmlRootRequest(req));
            res.setStatus(200);
            return;
        }
        if (path.startsWith("/" + this.catGenDocDirName + "/") || path.startsWith("/" + this.catGenConfigDirName + "/") || path.startsWith("/" + this.catGenResultCatalogsDirName + "/")) {
            this.doGetFiles(path, res);
        } else if (path.startsWith(this.adminPath)) {
            this.doGetHtmlUI(path, req, res);
        } else {
            String tmpMsg = "Request not understood(" + path + ").";
            logger.debug((Object)("doGet(): " + tmpMsg));
            out = res.getWriter();
            res.setContentType("text/html");
            out.print(this.getHtmlReturnMessage(req, tmpMsg));
            res.setStatus(200);
            return;
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        File tmpFile = null;
        String tmpMsg = null;
        String reqPath = req.getPathInfo();
        logger.info((Object)("doPut(): reqPath = " + reqPath));
        if (reqPath != null) {
            if (reqPath.startsWith("/" + this.catGenConfigDirName + "/")) {
                tmpFile = new File(this.catGenContentPath, reqPath);
                logger.debug((Object)("doPut(): putting CatGenConfig file - " + reqPath));
                if (reqPath.equals("/" + this.catGenConfigDirName + "/" + this.configFileName)) {
                    if (ServletUtil.saveFile(this, this.catGenContentPath.getAbsolutePath(), reqPath, req, res)) {
                        this.mainConfig.cancelTimer();
                        try {
                            this.mainConfig = new CatGenServletConfig(this.catGenResultPath, this.catGenConfigPath, this.configFileName);
                            res.setStatus(200);
                            return;
                        }
                        catch (IOException e) {
                            tmpMsg = "Reading config file failed";
                            logger.error((Object)("doPut(): " + tmpMsg), (Throwable)e);
                            res.sendError(202, tmpMsg + ": " + e.getMessage());
                            return;
                        }
                    }
                    tmpMsg = "File not saved <" + reqPath + ">";
                    logger.error((Object)("doPut(): " + tmpMsg));
                    res.sendError(202, tmpMsg);
                    return;
                }
                boolean creatingNewFile = true;
                if (tmpFile.exists()) {
                    creatingNewFile = false;
                }
                if (ServletUtil.saveFile(this, this.catGenContentPath.getAbsolutePath(), reqPath, req, res)) {
                    logger.debug((Object)("doPut(): file saved <" + reqPath + ">."));
                    this.mainConfig.notifyNewConfigDoc(tmpFile.getName());
                    if (creatingNewFile) {
                        res.setStatus(201);
                    } else {
                        res.setStatus(200);
                    }
                    return;
                }
                tmpMsg = "File not saved <" + reqPath + ">";
                logger.error((Object)("doPut(): " + tmpMsg));
                res.sendError(202, tmpMsg);
                return;
            }
            tmpMsg = "Cannot PUT a document outside the " + this.catGenConfigDirName + "directory";
            logger.warn((Object)("doPut(): " + tmpMsg));
            res.sendError(404, tmpMsg);
            return;
        }
        tmpMsg = "Cannot PUT a document here (empty request path)";
        logger.warn((Object)("doPut(): " + tmpMsg));
        res.sendError(404, tmpMsg);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        PrintWriter out = null;
        logger.info((Object)("CatGenServlet.doPost(): path = " + path));
        if (path != null) {
            if (path.equals(this.adminDoAddTaskPath)) {
                logger.debug((Object)"doPost(): adding Task.");
                CatGenTimerTask newTask = new CatGenTimerTask();
                newTask.setName(req.getParameter("taskName"));
                newTask.setConfigDocName(req.getParameter("fileName"));
                newTask.setResultFileName(req.getParameter("resultFileName"));
                newTask.setPeriodInMinutes(Integer.parseInt(req.getParameter("period")));
                newTask.setDelayInMinutes(Integer.parseInt(req.getParameter("delay")));
                newTask.init(this.catGenResultPath, this.catGenConfigPath);
                StringBuffer messages = new StringBuffer();
                if (newTask.isValid(messages)) {
                    logger.debug((Object)("doPost():     task is valid - " + messages.toString()));
                    if (this.mainConfig.addTask(newTask)) {
                        logger.debug((Object)"doPost():     task added.");
                        out = res.getWriter();
                        res.setContentType("text/html");
                        out.print(this.getHtmlAddTaskResultSuccess(req, newTask, messages));
                        res.setStatus(200);
                        return;
                    }
                    logger.debug((Object)"doPost():     duplicate task.");
                    out = res.getWriter();
                    res.setContentType("text/html");
                    out.print(this.getHtmlAddTaskResultDuplicate(req, newTask, messages));
                    res.setStatus(200);
                    return;
                }
                logger.debug((Object)("doPost():     task is invalid - " + messages.toString()));
                out = res.getWriter();
                res.setContentType("text/html");
                out.print(this.getHtmlAddTaskResultInvalid(req, newTask, messages));
                res.setStatus(200);
                return;
            }
            if (path.startsWith(this.adminDoEditTaskPath)) {
                String taskIdConfigDocName = path.substring(path.indexOf(this.adminDoEditTaskPath) + this.adminDoEditTaskPath.length());
                logger.debug((Object)("doPost(): editing Task - " + taskIdConfigDocName));
                CatGenTimerTask oldTask = this.mainConfig.findTaskByConfigDocName(taskIdConfigDocName);
                this.mainConfig.removeTask(oldTask);
                CatGenTimerTask newTask = new CatGenTimerTask();
                newTask.setName(req.getParameter("taskName"));
                newTask.setConfigDocName(req.getParameter("fileName"));
                newTask.setResultFileName(req.getParameter("resultFileName"));
                newTask.setPeriodInMinutes(Integer.parseInt(req.getParameter("period")));
                newTask.setDelayInMinutes(Integer.parseInt(req.getParameter("delay")));
                newTask.init(this.catGenResultPath, this.catGenConfigPath);
                StringBuffer messages = new StringBuffer();
                if (newTask.isValid(messages)) {
                    if (this.mainConfig.addTask(newTask)) {
                        logger.debug((Object)("doPost(): task added (" + newTask.getName() + ")."));
                        out = res.getWriter();
                        res.setContentType("text/html");
                        out.print(this.getHtmlEditTaskResultSuccess(req, oldTask, newTask, messages));
                        res.setStatus(200);
                        return;
                    }
                    logger.debug((Object)("doPost(): no task added, duplicate (" + newTask.getName() + ")."));
                    out = res.getWriter();
                    res.setContentType("text/html");
                    out.print(this.getHtmlEditTaskResultDuplicate(req, oldTask, newTask, messages));
                    res.setStatus(200);
                    return;
                }
                logger.debug((Object)("doPost(): no task added, invalid (" + newTask.getName() + ")."));
                out = res.getWriter();
                res.setContentType("text/html");
                out.print(this.getHtmlEditTaskResultInvalid(req, oldTask, newTask, messages));
                res.setStatus(200);
                return;
            }
            if (path.startsWith(this.adminDoDeleteTaskPath)) {
                String fileName = path.substring(path.indexOf(this.adminDoDeleteTaskPath) + this.adminDoDeleteTaskPath.length());
                logger.debug((Object)("doPost(): deleteing Task - " + fileName));
                CatGenTimerTask oldTask = this.mainConfig.findTaskByConfigDocName(fileName);
                if (oldTask == null) {
                    logger.debug((Object)("doPost(): task to delete not in list (" + fileName + ")."));
                    out = res.getWriter();
                    res.setContentType("text/html");
                    out.print(this.getHtmlReturnMessage(req, "Task to delete not in list (" + fileName + ")"));
                    res.setStatus(200);
                    return;
                }
                if (this.mainConfig.removeTask(oldTask)) {
                    logger.debug((Object)("doPost(): task deleted (" + oldTask.getName() + ")."));
                    out = res.getWriter();
                    res.setContentType("text/html");
                    out.print(this.getHtmlDeleteTaskResultSuccess(req, oldTask));
                    res.setStatus(200);
                    return;
                }
                logger.debug((Object)("doPost(): failed to delete task (" + oldTask.getName() + ")."));
                out = res.getWriter();
                res.setContentType("text/html");
                out.print(this.getHtmlDeleteTaskResultFail(req, oldTask));
                res.setStatus(200);
                return;
            }
        }
        logger.debug((Object)"doPost(): no path given for POST.");
        out = res.getWriter();
        res.setContentType("text/html");
        out.print(this.getHtmlReturnMessage(req, "No path given for POST action."));
        res.setStatus(200);
    }

    private void doGetFiles(String path, HttpServletResponse res) throws IOException {
        String tmpMsg = null;
        File tmpFile = null;
        String fileType = null;
        if (path.startsWith("/" + this.catGenDocDirName + "/")) {
            tmpFile = new File(this.catGenStaticContentPath, path);
        } else if (path.startsWith("/" + this.catGenConfigDirName + "/")) {
            tmpFile = new File(this.catGenContentPath, path);
        } else if (path.startsWith("/" + this.catGenResultCatalogsDirName + "/")) {
            tmpFile = new File(this.catGenContentPath, path);
        } else {
            tmpMsg = "Illegal request <" + path + "> (doGet() should not have passed in the request).";
            logger.debug((Object)("doGetFiles(): " + tmpMsg));
            res.sendError(400, tmpMsg);
            return;
        }
        if (tmpFile.exists() && tmpFile.isFile()) {
            if (path.endsWith(".xml")) {
                fileType = "text/xml";
            } else if (path.endsWith(".html")) {
                fileType = "text/html";
            }
            logger.debug((Object)("doGetFiles(): sending file <" + tmpFile.getName() + "> in directory <" + tmpFile.getParent() + "> to returnFile()"));
            ServletUtil.returnFile(this, tmpFile.getParent(), tmpFile.getName(), res, fileType);
            return;
        }
        tmpMsg = "doGetFiles(): Requested file does not exist or is a directory <" + path + ">";
        logger.debug((Object)tmpMsg);
        res.sendError(404, tmpMsg);
    }

    private void doGetHtmlUI(String path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrintWriter out = null;
        if (path.equals(this.adminPath + "/")) {
            logger.debug((Object)"doGetHtmlUI(): listing all tasks");
            out = res.getWriter();
            res.setContentType("text/html");
            out.print(this.getHtmlListTasks(req, this.mainConfig));
            res.setStatus(200);
            return;
        }
        if (!path.equals(this.adminPath)) {
            if (path.startsWith(this.adminEditTaskPath)) {
                String fileName = path.substring(path.indexOf(this.adminEditTaskPath) + this.adminEditTaskPath.length());
                logger.debug((Object)("doGetHtmlUI(): edit task - " + fileName));
                CatGenTimerTask task = this.mainConfig.findTaskByConfigDocName(fileName);
                out = res.getWriter();
                res.setContentType("text/html");
                out.print(this.getHtmlEditTask(req, task));
                res.setStatus(200);
                return;
            }
            if (path.equals(this.adminAddTaskPath)) {
                logger.debug((Object)"doGetHtmlUI(): add task");
                out = res.getWriter();
                res.setContentType("text/html");
                out.print(this.getHtmlAddTask(req));
                res.setStatus(200);
                return;
            }
            if (path.startsWith(this.adminDeleteTaskPath)) {
                String fileName = path.substring(path.indexOf(this.adminDeleteTaskPath) + this.adminDeleteTaskPath.length());
                logger.debug((Object)("doGetHtmlUI(): delete task - " + fileName));
                CatGenTimerTask task = this.mainConfig.findTaskByConfigDocName(fileName);
                logger.debug((Object)("doGetHtmlUI(): return form for editing task - \"" + task.getName() + "\"."));
                out = res.getWriter();
                res.setContentType("text/html");
                out.print(this.getHtmlDeleteTask(req, task));
                res.setStatus(200);
                return;
            }
            String tmpMsg = "Request <" + path + "> not understood";
            logger.error((Object)("doGetHtmlUI(): " + tmpMsg));
            res.sendError(404, tmpMsg);
            return;
        }
        res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + req.getServletPath() + this.adminPath + "/"));
    }

    private String getHtmlRootRequest(HttpServletRequest req) {
        logger.debug((Object)"htmlRootRequest(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet</h1>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/" + "\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlReturnMessage(HttpServletRequest req, String message) {
        logger.debug((Object)("getHtmlReturnMessage(): start (" + message + ")"));
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet</h1>\n");
        retValue.append("<p>\n");
        retValue.append(message);
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/" + "\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlListTasks(HttpServletRequest req, CatGenServletConfig config) {
        logger.debug((Object)"htmlListTasks(): starting");
        StringBuffer retVal = new StringBuffer();
        retVal.append("<html>\n");
        retVal.append("<head><title>Catalog Generator Servlet Config</title></head>\n");
        retVal.append("<body>\n");
        retVal.append("<h1>Catalog Generator Servlet Config</h1>\n");
        retVal.append("<hr>\n");
        retVal.append("<h2>Currently Scheduled Tasks</h2>\n");
        retVal.append("<table border=\"1\">\n");
        retVal.append("<tr>\n");
        retVal.append("<th> Task Name</th>\n");
        retVal.append("<th> Configuration Document</th>\n");
        retVal.append("<th>\n");
        retVal.append("Resulting Catalog\n");
        retVal.append("</th>\n");
        retVal.append("<th> Period (minutes)</th>\n");
        retVal.append("<th> Initial Delay (minutes)</th>\n");
        retVal.append("<th> Edit/Delete Task</th>\n");
        retVal.append("</tr>\n");
        CatGenTimerTask curTask = null;
        Iterator iter = config.getTaskIterator();
        while (iter.hasNext()) {
            curTask = (CatGenTimerTask)iter.next();
            retVal.append("<tr>\n");
            retVal.append("<td>" + curTask.getName() + "</td>\n");
            retVal.append("<td> <a href=\"" + req.getContextPath() + req.getServletPath() + "/" + this.catGenConfigDirName + "/" + curTask.getConfigDocName() + "\">" + curTask.getConfigDocName() + "</a></td>\n");
            retVal.append("<td> <a href=\"" + req.getContextPath() + req.getServletPath() + "/" + this.catGenResultCatalogsDirName + "/" + curTask.getResultFileName() + "\">" + curTask.getResultFileName() + "</a></td>\n");
            retVal.append("</td>\n");
            retVal.append("<td>" + curTask.getPeriodInMinutes() + "</td>\n");
            retVal.append("<td>" + curTask.getDelayInMinutes() + "</td>\n");
            retVal.append("<td>\n");
            retVal.append("[<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminEditTaskPath + curTask.getConfigDocName() + "\">Edit</a>]" + "[<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminDeleteTaskPath + curTask.getConfigDocName() + "\">Delete</a>]\n");
            retVal.append("</td>\n");
            retVal.append("</tr>\n");
        }
        retVal.append("</table>\n");
        retVal.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminAddTaskPath + "\">Add a new task</a>\n");
        retVal.append("<hr>\n");
        retVal.append("<p>Note: If period is zero (0), the task will not be scheduled to run.</p>\n");
        retVal.append("<hr>\n");
        retVal.append("</body>\n");
        retVal.append("</html>");
        return retVal.toString();
    }

    private String getHtmlEditTask(HttpServletRequest req, CatGenTimerTask task) {
        logger.debug((Object)"htmlEditTask(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Edit Task</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Edit Task</h1>\n");
        retValue.append("<hr>\n");
        retValue.append(this.getHtmlEditForm(req, task));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTask(HttpServletRequest req) {
        logger.debug((Object)"htmlAddTask(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Add Task</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Add Task</h1>\n");
        retValue.append("<hr>\n");
        retValue.append(this.getHtmlAddForm(req, null));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlDeleteTask(HttpServletRequest req, CatGenTimerTask task) {
        logger.debug((Object)"getHtmlDeleteTask(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Delete Task</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Delete Task</h1>\n");
        retValue.append("<hr>\n");
        retValue.append("<form method=\"POST\" action=\"" + req.getContextPath() + req.getServletPath() + this.adminDoDeleteTaskPath + task.getConfigDocName() + "\">\n");
        retValue.append("<h2>Task to Delete</h2>\n");
        retValue.append(this.getHtmlListTable(task));
        retValue.append("<p>\n");
        retValue.append("To delete this task, click on the \"Submit\" button.\n");
        retValue.append("To stop this task but not delete it, <a href=\"" + req.getContextPath() + req.getServletPath() + this.adminDoDeleteTaskPath + task.getConfigDocName() + "\">edit the task</a> and set \n");
        retValue.append("the value of \"Period\" to zero.\n");
        retValue.append("</p>\n");
        retValue.append("<input type=\"submit\" value=\"Submit\">\n");
        retValue.append("</form>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlEditTaskResultDuplicate(HttpServletRequest req, CatGenTimerTask oldTask, CatGenTimerTask newTask, StringBuffer messages) {
        logger.debug((Object)"htmlEditTaskResultDuplicate(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Edit Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Edit Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Resulting task is duplicate (in name and/or config doc name)\n");
        retValue.append("of a different existing task. Change the task below and\n");
        retValue.append("try adding again, or go back to the\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/" + "\">list of tasks (minus this task)</a>.\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlEditTaskResultInvalid(HttpServletRequest req, CatGenTimerTask oldTask, CatGenTimerTask newTask, StringBuffer messages) {
        logger.debug((Object)"htmlEditTaskResultInvalid(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Edit Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Edit Results</h1>\n");
        retValue.append("<p>Resulting task is invalid.</p>\n");
        retValue.append("<p>Message: " + messages.toString() + "</p>\n");
        retValue.append("<p>\n");
        retValue.append("Change the task below and");
        retValue.append("try adding it again, or go back to the");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/" + "\">list of tasks (minus this task)</a>.\n");
        retValue.append("To keep this task and edit the configuration, change the period to zero (0).\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>\n");
        return retValue.toString();
    }

    private String getHtmlEditTaskResultSuccess(HttpServletRequest req, CatGenTimerTask oldTask, CatGenTimerTask newTask, StringBuffer messages) {
        logger.debug((Object)"htmlEditTaskResultSuccess(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Edit Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Edit Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Task Successfully edited.\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/" + "\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTaskResultDuplicate(HttpServletRequest req, CatGenTimerTask newTask, StringBuffer messages) {
        logger.debug((Object)"htmlAddTaskResultDuplicate(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Add Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Add Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Resulting task is a duplicate (in name and/or config doc name)\n");
        retValue.append("of a different existing task. Change the task below and\n");
        retValue.append("try adding it again, or go back to the\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/\">list of current tasks</a>.\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTaskResultInvalid(HttpServletRequest req, CatGenTimerTask newTask, StringBuffer messages) {
        logger.debug((Object)"htmlAddTaskResultInvalid(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Add Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Add Results</h1>\n");
        retValue.append("<p>Resulting task is invalid.</p>\n");
        retValue.append("<p>Message: " + messages.toString() + "</p>\n");
        retValue.append("<p>\n");
        retValue.append("Change the task below and\n");
        retValue.append("try adding it again, or go back to the\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/\">list of tasks (minus this task)</a>.\n");
        retValue.append("To keep this task and edit the configuration, change the period to zero (0).\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTaskResultSuccess(HttpServletRequest req, CatGenTimerTask newTask, StringBuffer messages) {
        logger.debug((Object)"htmlAddTaskResultSuccess(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Add Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Add Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Task Successfully added.\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlDeleteTaskResultFail(HttpServletRequest req, CatGenTimerTask oldTask) {
        logger.debug((Object)"htmlDeleteTaskResultFail(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Delete Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Delete Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Deletion of task failed. (This shouldn't happen! We found\n");
        retValue.append("the task in the list so we should be able to remove it)\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlDeleteTaskResultSuccess(HttpServletRequest req, CatGenTimerTask oldTask) {
        logger.debug((Object)"htmlDeleteTaskResultSuccess(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append("<html>\n");
        retValue.append("<head><title>Catalog Generator Servlet - Task Delete Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Delete Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Task Successfully deleted.\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"" + req.getContextPath() + req.getServletPath() + this.adminPath + "/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddForm(HttpServletRequest req, CatGenTimerTask task) {
        StringBuffer buf = new StringBuffer();
        logger.debug((Object)"getHtmlAddForm(): start");
        String taskName = "";
        String taskConfigDocName = "";
        String taskResultFileName = "";
        String taskPeriodInMinutes = "";
        String taskDelayInMinutes = "";
        if (task != null) {
            taskName = task.getName();
            taskConfigDocName = task.getConfigDocName();
            taskResultFileName = task.getResultFileName();
            taskPeriodInMinutes = Integer.toString(task.getPeriodInMinutes());
            taskDelayInMinutes = Integer.toString(task.getDelayInMinutes());
        }
        buf.append("<form method=\"POST\" action=\"" + req.getContextPath() + req.getServletPath() + this.adminDoAddTaskPath + "\">" + "\n");
        buf.append("<h2>Task to Add</h2>\n");
        buf.append("<table border=\"1\">\n");
        buf.append("<tr>\n");
        buf.append("<th> Task Name</th>\n");
        buf.append("<td> <input name=\"taskName\" size=\"40\" value=\"" + taskName + "\"></td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Configuration Document</th>\n");
        buf.append("<td> <input name=\"fileName\" size=\"40\" value=\"" + taskConfigDocName + "\"></td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th>Resulting Catalog</th>\n");
        buf.append("<td> <input name=\"resultFileName\" size=\"80\" value=\"" + taskResultFileName + "\"></td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Period (minutes)</th>\n");
        buf.append("<td> <input name=\"period\" size=\"10\" value=\"" + taskPeriodInMinutes + "\"></td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Initial Delay (minutes)</th>\n");
        buf.append("<td> <input name=\"delay\" size=\"10\" value=\"" + taskDelayInMinutes + "\"></td>" + "\n");
        buf.append("</tr>\n");
        buf.append("</table>\n");
        buf.append("<input type=\"submit\" value=\"Submit\">\n");
        buf.append("<input type=\"reset\" value=\"Reset Values\">\n");
        buf.append("</form>\n");
        return buf.toString();
    }

    private String getHtmlEditForm(HttpServletRequest req, CatGenTimerTask task) {
        StringBuffer buf = new StringBuffer();
        logger.debug((Object)"getHtmlEditForm(): start");
        buf.append("<form method=\"POST\" action=\"" + req.getContextPath() + req.getServletPath() + this.adminDoEditTaskPath + task.getConfigDocName() + "\">\n");
        buf.append("<h2>Task to Edit</h2>\n");
        buf.append("<table border=\"1\">\n");
        buf.append("<tr>\n");
        buf.append("<th> Task Name</th>\n");
        buf.append("<td> <input name=\"taskName\" size=\"40\" value=\"" + task.getName() + "\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Configuration Document</th>\n");
        buf.append("<td> <input name=\"fileName\" size=\"40\" value=\"" + task.getConfigDocName() + "\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th>Resultin Catalog</th>\n");
        buf.append("<td> <input name=\"resultFileName\" size=\"80\" value=\"" + task.getResultFileName() + "\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Period (minutes)</th>\n");
        buf.append("<td> <input name=\"period\" size=\"10\" value=\"" + task.getPeriodInMinutes() + "\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Initial Delay (minutes)</th>\n");
        buf.append("<td> <input name=\"delay\" size=\"10\" value=\"" + task.getDelayInMinutes() + "\"></td>\n");
        buf.append("</tr>\n");
        buf.append("</table>\n");
        buf.append("<input type=\"submit\" value=\"Submit\">\n");
        buf.append("<input type=\"reset\" value=\"Reset Values\">\n");
        buf.append("</form>\n");
        return buf.toString();
    }

    private String getHtmlListTable(CatGenTimerTask task) {
        StringBuffer buf = new StringBuffer();
        logger.debug((Object)"getHtmlListTable(): start");
        buf.append("<table border=\"1\">\n");
        buf.append("<tr>\n");
        buf.append("<th> Task Name</th>\n");
        buf.append("<td>" + task.getName() + "</td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Configuration Document</th>\n");
        buf.append("<td>" + task.getConfigDocName() + "</td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th>Resulting Catalog</th>\n");
        buf.append("<td>" + task.getResultFileName() + "</td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Period (minutes)</th>\n");
        buf.append("<td>" + task.getPeriodInMinutes() + "</td>" + "\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Initial Delay (minutes)</th>\n");
        buf.append("<td>" + task.getDelayInMinutes() + "</td>" + "\n");
        buf.append("</tr>\n");
        buf.append("</table>\n");
        return buf.toString();
    }
}

