/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceType;

public class LocalDatasetSource
extends DatasetSource {
    private static Logger logger = Logger.getLogger((String)LocalDatasetSource.class.getName());
    private URI accessPointHeaderUri = null;

    LocalDatasetSource() {
        this.type = DatasetSourceType.getType("Local");
    }

    protected InvDataset getTopLevelDataset() {
        this.accessPointHeaderUri = new File(this.getResultService().getAccessPointHeader()).toURI();
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, null);
        InvService service = new InvService(this.getResultService().getName(), this.getResultService().getServiceType().toString(), this.getResultService().getBase(), this.getResultService().getSuffix(), this.getResultService().getDescription());
        Iterator it = this.getResultService().getProperties().iterator();
        while (it.hasNext()) {
            service.addProperty((InvProperty)it.next());
        }
        it = this.getResultService().getServices().iterator();
        while (it.hasNext()) {
            service.addService((InvService)it.next());
        }
        catalog.addService(service);
        LocalInvDataset topDs = new LocalInvDataset(null, new File(this.getAccessPoint()));
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(service.getName());
        InvMetadata md = new InvMetadata(topDs, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        topDs.setLocalMetadata(tm2);
        if (!topDs.isDirectory()) {
            String tmpMsg = "The DatasetSource \"" + this.getName() + "\" could not be expanded. Its accessPoint (" + this.getAccessPoint() + ") is not a directory.";
            logger.warn((Object)("getTopLevelDataset(): " + tmpMsg));
            topDs = new LocalInvDataset(null, tmpMsg, this.getAccessPoint());
        }
        catalog.addDataset(topDs);
        catalog.finish();
        return topDs;
    }

    protected boolean isCollection(InvDataset dataset) {
        return ((LocalInvDataset)dataset).isDirectory();
    }

    protected List expandThisLevel(InvDataset dataset) {
        if (!this.isCollection(dataset)) {
            throw new IllegalArgumentException("Dataset \"" + dataset.getName() + "\" is not a collection dataset.");
        }
        File theDir = new File(((LocalInvDataset)dataset).getLocalPath());
        File[] allFiles = theDir.listFiles();
        LocalInvDataset curDs = null;
        ArrayList<LocalInvDataset> list = new ArrayList<LocalInvDataset>();
        for (int i = 0; i < allFiles.length; ++i) {
            curDs = new LocalInvDataset(dataset, allFiles[i]);
            list.add(curDs);
        }
        return list;
    }

    protected void expandThisType(InvDatasetImpl parent, String givenLocation) {
        File theDir;
        String givenLocationAsURI;
        logger.debug((Object)("expandThisType(): expand the given location (" + givenLocation + ")."));
        InvDatasetImpl curDs = null;
        String accessPointHeader = this.getResultService().getAccessPointHeader();
        File accessPointHeaderFile = new File(accessPointHeader);
        URI accessPointHeaderUri = accessPointHeaderFile.toURI();
        logger.debug((Object)"expandThisType(): Test whether the access point header is a directory.");
        if (!accessPointHeaderFile.isDirectory()) {
            String tmpMsg = "The DatasetSource \"" + this.getName() + "\" could not be expanded. The accessPointHeader (" + accessPointHeader + ") is not a directory.";
            logger.warn((Object)("expandThisType(): " + tmpMsg));
            InvDatasetImpl tmpDs = new InvDatasetImpl(null, tmpMsg);
            parent.addDataset(tmpDs);
            return;
        }
        logger.debug((Object)("expandThisType(): Check if given location (" + givenLocation + ") string is URI compliant."));
        if (givenLocation.startsWith("file:")) {
            logger.debug((Object)"expandThisType(): given location starts with \"file:\".");
            givenLocationAsURI = givenLocation;
        } else {
            logger.debug((Object)"expandThisType(): given location does not start with \"file:\".");
            File tmpFile = new File(givenLocation);
            logger.debug((Object)("expandThisType():     tmpFile name - \"" + tmpFile.getPath() + "\"."));
            givenLocationAsURI = tmpFile.toURI().toString();
            logger.debug((Object)("expandThisType():     tmpFileURI name - \"" + givenLocationAsURI + "\"."));
        }
        try {
            logger.debug((Object)("expandThisType(): Given location is \"" + givenLocation + "\"."));
            URI theDirURI = new URI(givenLocationAsURI);
            logger.debug((Object)("expandThisType(): Given location as URI is \"" + theDirURI.toString() + "\" (" + theDirURI.getScheme() + ")."));
            theDir = new File(theDirURI);
            logger.debug((Object)("expandThisType(): Given location as File is \"" + theDir.getAbsolutePath() + "\"."));
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("expandThisType(): The DatasetSource \"" + this.getName() + "\" could not be expanded. The given location (" + givenLocation + ")" + " resulted in a URISyntaxException."));
            InvDatasetImpl tmpDs = null;
            tmpDs = new InvDatasetImpl(null, "The DatasetSource \"" + this.getName() + "\" could not be expanded. The given location (" + givenLocation + ")" + " resulted in a URISyntaxException.");
            parent.addDataset(tmpDs);
            return;
        }
        logger.debug((Object)"expandThisType(): Check that the given location is actually a directory.");
        if (!theDir.isDirectory()) {
            logger.warn((Object)("expandThisType(): The DatasetSource \"" + this.getName() + "\" could not be expanded. The given location (" + givenLocation + " - " + theDir.getAbsolutePath() + ")" + " is not a directory."));
            InvDatasetImpl tmpDs = null;
            tmpDs = new InvDatasetImpl(null, "The DatasetSource \"" + this.getName() + "\" could not be expanded. The given location (" + givenLocation + " - " + theDir.getAbsolutePath() + ")" + " is not a directory.");
            parent.addDataset(tmpDs);
            return;
        }
        File[] allFiles = theDir.listFiles();
        logger.debug((Object)("expandThisType(): Deal with all files in this directory (" + allFiles.length + ")."));
        block2: for (int i = 0; i < allFiles.length; ++i) {
            File curFile = allFiles[i];
            URI curUri = curFile.toURI();
            String curDsAbsolutePath = curUri.toString();
            logger.debug((Object)("expandThisType(): handling current file ([" + i + "] " + curDsAbsolutePath + ")"));
            if (!curDsAbsolutePath.startsWith(accessPointHeaderUri.toString())) {
                logger.warn((Object)("expandThisType(): current path (" + curDsAbsolutePath + ") not accessible" + " from the ResultService (" + this.getResultService().getName() + " - " + accessPointHeader + "). THIS SHOULDN'T HAPPEN!"));
                continue;
            }
            String curDsRelativePath = curDsAbsolutePath.substring(accessPointHeaderUri.toString().length());
            if (curFile.isDirectory()) {
                logger.debug((Object)("expandThisType(): current file is directory, expand (" + curDsAbsolutePath + ")."));
                if (!this.isFlatten()) {
                    logger.debug((Object)"expandThisType(): add level in directory tree");
                    curDs = new InvDatasetImpl(null, curDsRelativePath, null, null, null);
                    this.expandThisType(curDs, curDsAbsolutePath);
                    parent.addDataset(curDs);
                    continue;
                }
                this.expandThisType(parent, curDsAbsolutePath);
                continue;
            }
            curDs = new InvDatasetImpl(null, "", null, null, curDsRelativePath);
            if (!this.getDatasetFilterList().isEmpty()) {
                DatasetFilter curFilter = null;
                for (int j = 0; j < this.getDatasetFilterList().size(); ++j) {
                    curFilter = (DatasetFilter)this.getDatasetFilterList().get(j);
                    if (!curFilter.accept(curDs)) continue;
                    logger.debug((Object)("expandThisType(): the current dataset (" + curDs.getUrlPath() + ") was" + " accepted by the filter \"" + curFilter.getName() + "\""));
                    parent.addDataset(curDs);
                    continue block2;
                }
                continue;
            }
            parent.addDataset(curDs);
        }
    }

    private class LocalInvDataset
    extends InvDatasetImpl {
        private String localPath;
        private boolean directory;

        LocalInvDataset(InvDataset parent, File file) {
            super((InvDatasetImpl)parent, null, null, null, null);
            this.localPath = null;
            this.directory = false;
            this.localPath = file.getAbsolutePath();
            this.directory = file.isDirectory();
            String dsAbsolutePath = file.toURI().toString();
            String dsRelativePath = null;
            if (dsAbsolutePath.startsWith(LocalDatasetSource.this.accessPointHeaderUri.toString())) {
                dsRelativePath = dsAbsolutePath.substring(LocalDatasetSource.this.accessPointHeaderUri.toString().length());
            }
            if (!this.directory) {
                this.setUrlPath(dsRelativePath);
            }
            this.setName(dsRelativePath);
        }

        LocalInvDataset(InvDataset parent, String name, String localPath) {
            super(parent, name);
            this.localPath = null;
            this.directory = false;
            this.localPath = localPath;
            this.directory = new File(this.localPath).isDirectory();
        }

        String getLocalPath() {
            return this.localPath;
        }

        void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        boolean isDirectory() {
            return this.directory;
        }
    }
}

