/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.DodsURLExtractor;

public class DodsDirDatasetSource
extends DatasetSource {
    private static Logger logger = Logger.getLogger((String)DodsDirDatasetSource.class.getName());
    private DodsURLExtractor urlExtractor = null;

    public DodsDirDatasetSource() {
        this.type = DatasetSourceType.getType("DodsDir");
        this.urlExtractor = new DodsURLExtractor();
    }

    public void expandThisType(InvDatasetImpl parent, String givenLocation) {
        String resultContent;
        logger.debug((Object)("expandThisType(): expand the given location (" + givenLocation + ")."));
        ArrayList possibleDsList = new ArrayList();
        InvDatasetImpl curDs = null;
        String curDsAbsolutePath = null;
        String curDsRelativePath = null;
        String accessPointHeader = null;
        String verUrlString = givenLocation.endsWith("/") ? givenLocation + "version" : givenLocation + "/version";
        try {
            logger.debug((Object)("expandThisType(): checking that given location (" + givenLocation + ") is an OPeNDAP server by checking version."));
            resultContent = this.urlExtractor.getTextContent(verUrlString);
        }
        catch (IOException e) {
            logger.debug((Object)"expandThisType(): IoException while checking that given location is an OPeNDAP server.");
            InvDatasetImpl tmpDs = null;
            tmpDs = new InvDatasetImpl(null, "Could not expand the DatasetSource \"" + this.getName() + "\" at this location \"" + givenLocation + "\". IoException while checking that the" + " location references an OPeNDAP server.");
            parent.addDataset(tmpDs);
            return;
        }
        if (resultContent.indexOf("DODS") == -1 && resultContent.indexOf("OPeNDAP") == -1 && resultContent.indexOf("DAP") == -1) {
            logger.warn((Object)("expandThisType(): location does not reference an OPeNDAP server, bad version info (leaving expandThisLevel()):" + resultContent));
            InvDatasetImpl tmpDs = null;
            tmpDs = new InvDatasetImpl(null, "Could not expand the DatasetSource \"" + this.getName() + "\" at this location \"" + givenLocation + "\". IoException while checking" + " that location references an OPeNDAP server.");
            parent.addDataset(tmpDs);
            return;
        }
        logger.debug((Object)("expandThisType(): location is an OPeNDAP server (version info contains \"DODS\", \"OPeNDAP\",  or \"DAP\"): " + resultContent));
        try {
            logger.debug((Object)"expandThisType(): getting all URLs at given locatoin.");
            possibleDsList = this.urlExtractor.extract(givenLocation);
        }
        catch (IOException e) {
            logger.warn((Object)("expandThisType(): ioexception while expanding given OPeNDAP directory (" + givenLocation + ")"));
            InvDatasetImpl tmpDs = null;
            tmpDs = new InvDatasetImpl(null, "Could not expand the DatasetSource \"" + this.getName() + "\" for this OPeNDAP directory \"" + givenLocation + "\". IoException while expanding" + " the location.");
            parent.addDataset(tmpDs);
            return;
        }
        try {
            accessPointHeader = new URI(this.getResultService().getAccessPointHeader()).toString();
            logger.debug((Object)("expandThisType(): get and encode access point header (" + accessPointHeader.toString() + ")."));
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("expandThisType(): Could not expand the DatasetSource \"" + this.getName() + "\". Creating a URI with accessPointHeader (" + this.getResultService() + ") caused a URISyntaxException."));
            InvDatasetImpl tmpDs = null;
            tmpDs = new InvDatasetImpl(null, "Could not expand the DatasetSource \"" + this.getName() + "\". Creating a URI with accessPointHeader (" + this.getResultService() + ") caused a URISyntaxException.");
            parent.addDataset(tmpDs);
            return;
        }
        Iterator iter = possibleDsList.iterator();
        block6: while (iter.hasNext()) {
            curDsAbsolutePath = (String)iter.next();
            logger.debug((Object)("expandThisType(): handle dataset (" + curDsAbsolutePath + ")"));
            if (!curDsAbsolutePath.endsWith(".html")) {
                logger.debug((Object)("expandThisType(): current path (" + curDsAbsolutePath + ") is not an OPeNDAP dataset" + " because it does not end with \".html\"."));
                continue;
            }
            curDsAbsolutePath = curDsAbsolutePath.substring(0, curDsAbsolutePath.length() - 5);
            if (!curDsAbsolutePath.startsWith(accessPointHeader)) {
                logger.debug((Object)("expandThisType(): current path (" + curDsAbsolutePath + ") not accessible" + " from the ResultService (" + this.getResultService().getName() + " - " + accessPointHeader + "). THIS SHOULDN'T HAPPEN!"));
                continue;
            }
            curDsRelativePath = curDsAbsolutePath.substring(accessPointHeader.length());
            if (!curDsAbsolutePath.startsWith(givenLocation)) {
                logger.debug((Object)("expandThisType(): current path (" + curDsAbsolutePath + ") not child of given" + " location (" + givenLocation + ")."));
                continue;
            }
            if (curDsAbsolutePath.endsWith("/")) {
                logger.debug((Object)"expandThisType(): current dataset is directory.");
                if (!this.isFlatten()) {
                    curDs = new InvDatasetImpl(null, curDsRelativePath, null, null, null);
                    this.expandThisType(curDs, curDsAbsolutePath);
                    parent.addDataset(curDs);
                    continue;
                }
                this.expandThisType(parent, curDsAbsolutePath);
                continue;
            }
            logger.debug((Object)"expandThisType(): current dataset is directory.");
            curDs = new InvDatasetImpl(null, "", null, null, curDsRelativePath);
            if (!this.getDatasetFilterList().isEmpty()) {
                DatasetFilter curFilter = null;
                for (int j = 0; j < this.getDatasetFilterList().size(); ++j) {
                    curFilter = (DatasetFilter)this.getDatasetFilterList().get(j);
                    logger.debug((Object)("expandThisType(): check dataset against filter (" + curFilter.getName() + ")."));
                    if (!curFilter.accept(curDs)) continue;
                    logger.debug((Object)("expandThisType(): the current dataset (" + curDs.getUrlPath() + ") was" + " accepted by the filter \"" + curFilter.getName() + "\""));
                    parent.addDataset(curDs);
                    continue block6;
                }
                continue;
            }
            parent.addDataset(curDs);
        }
    }

    protected InvDataset getTopLevelDataset() {
        return null;
    }

    protected boolean isCollection(InvDataset dataset) {
        return false;
    }

    protected List expandThisLevel(InvDataset collectionDataset) {
        return null;
    }
}

