/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.config.BadDatasetSource;
import thredds.cataloggen.config.CatalogRefExpander;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetNamer;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.DodsDirDatasetSource;
import thredds.cataloggen.config.DodsFileServerDatasetSource;
import thredds.cataloggen.config.GrADSDataServerDatasetSource;
import thredds.cataloggen.config.LocalDatasetSource;
import thredds.cataloggen.config.ResultService;

public abstract class DatasetSource {
    private static Logger logger = Logger.getLogger((String)DatasetSource.class.getName());
    protected InvCatalog resultingCatalog = null;
    protected HashMap resultingCatalogList = null;
    protected InvDatasetImpl parentDataset = null;
    protected InvDataset accessPointDataset = null;
    protected DatasetSource parentDatasetSource = null;
    private String name = null;
    protected DatasetSourceType type = null;
    private DatasetSourceStructure structure = null;
    private boolean flatten = false;
    private String accessPoint = null;
    private ResultService resultService = null;
    protected List datasetNamerList = new ArrayList();
    protected List datasetFilterList = new ArrayList();
    protected List catalogRefExpanderList = new ArrayList();
    protected boolean isValid = true;
    protected StringBuffer log = new StringBuffer();

    public static final DatasetSource newDatasetSource(InvDatasetImpl parentDs, DatasetSource parentDsSource, String name, DatasetSourceType type, DatasetSourceStructure structure, String accessPoint, ResultService resultService) {
        DatasetSource tmpDsSource = null;
        tmpDsSource = type == DatasetSourceType.getType("Local") ? new LocalDatasetSource() : (type == DatasetSourceType.getType("DodsDir") ? new DodsDirDatasetSource() : (type == DatasetSourceType.getType("DodsFileServer") ? new DodsFileServerDatasetSource() : (type == DatasetSourceType.getType("GrADSDataServer") ? new GrADSDataServerDatasetSource() : new BadDatasetSource())));
        tmpDsSource.setParentDataset(parentDs);
        tmpDsSource.setParentDatasetSource(parentDsSource);
        tmpDsSource.setName(name);
        tmpDsSource.setStructure(structure);
        tmpDsSource.setAccessPoint(accessPoint);
        tmpDsSource.setResultService(resultService);
        logger.debug((Object)"DatasetSource(): constructor done.");
        StringBuffer log = new StringBuffer();
        if (tmpDsSource.validate(log)) {
            logger.debug((Object)("DatasetSource(): new DatasetSource is valid: " + log.toString()));
        } else {
            logger.debug((Object)("DatasetSource(): new DatasetSource is invalid: " + log.toString()));
        }
        return tmpDsSource;
    }

    public InvDatasetImpl getParentDataset() {
        return this.parentDataset;
    }

    public void setParentDataset(InvDatasetImpl parentDataset) {
        this.parentDataset = parentDataset;
    }

    public DatasetSource getParentDatasetSource() {
        return this.parentDatasetSource;
    }

    public void setParentDatasetSource(DatasetSource parent) {
        this.parentDatasetSource = parent;
    }

    public InvCatalog getResultingCatalog() {
        return this.resultingCatalog;
    }

    public HashMap getResultingCatalogList() {
        if (this.resultingCatalogList != null) {
            return this.resultingCatalogList;
        }
        if (this.parentDatasetSource != null) {
            return this.parentDatasetSource.getResultingCatalogList();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DatasetSourceType getType() {
        return this.type;
    }

    public DatasetSourceStructure getStructure() {
        return this.structure;
    }

    public void setStructure(DatasetSourceStructure structure) {
        this.structure = structure;
        this.flatten = this.structure == DatasetSourceStructure.FLAT;
    }

    public void setStructure(String structureName) {
        DatasetSourceStructure tmp = DatasetSourceStructure.getStructure(structureName);
        if (tmp == null) {
            this.isValid = false;
            this.log.append(" ** DatasetSource (4): invalid structure =(" + structureName + ").");
        }
        this.setStructure(tmp);
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public String getAccessPoint() {
        return this.accessPoint;
    }

    public void setAccessPoint(String accessPoint) {
        this.accessPoint = accessPoint;
    }

    public ResultService getResultService() {
        return this.resultService;
    }

    public void setResultService(ResultService resultService) {
        this.resultService = resultService;
    }

    public List getDatasetNamerList() {
        return this.datasetNamerList;
    }

    public void addDatasetNamer(DatasetNamer datasetNamer) {
        this.datasetNamerList.add(datasetNamer);
    }

    public List getDatasetFilterList() {
        return this.datasetFilterList;
    }

    public void addDatasetFilter(DatasetFilter datasetFilter) {
        this.datasetFilterList.add(datasetFilter);
    }

    public List getCatalogRefExpanderList() {
        return this.catalogRefExpanderList;
    }

    public void addCatalogRefExpander(CatalogRefExpander catRefExpander) {
        this.catalogRefExpanderList.add(catRefExpander);
    }

    public boolean validate(StringBuffer out) {
        this.isValid = true;
        if (this.log.length() > 0) {
            out.append(this.log);
        }
        if (this.getName() == null) {
            this.isValid = false;
            out.append(" ** DatasetSource (5): null value for name is not valid.");
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** DatasetSource (6): null value for type is not valid (set with bad string?).");
        }
        if (this.getStructure() == null) {
            this.isValid = false;
            out.append(" ** DatasetSource (7): null value for structure is not valid (set with bad string?).");
        }
        if (this.getResultService() != null) {
            this.isValid &= this.getResultService().validate(out);
        }
        Iterator dsnIter = this.getDatasetNamerList().iterator();
        while (dsnIter.hasNext()) {
            this.isValid &= ((DatasetNamer)dsnIter.next()).validate(out);
        }
        Iterator dsfIter = this.getDatasetFilterList().iterator();
        while (dsfIter.hasNext()) {
            this.isValid &= ((DatasetFilter)dsfIter.next()).validate(out);
        }
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("DatasetSource[name:<" + this.getName() + "> type:<" + this.getType() + "> structure:<" + this.getStructure() + "> accessPoint:<" + this.getAccessPoint() + "> and children - " + "ResultService(" + this.getResultService().getName() + ") - " + "DatasetNamer(" + this.getDatasetNamerList().size() + ") - " + "DatasetFilter(" + this.getDatasetFilterList().size() + ")]");
        return tmp.toString();
    }

    public InvDataset expand() {
        this.accessPointDataset = this.getTopLevelDataset();
        if (!this.isCollection(this.accessPointDataset)) {
            logger.warn((Object)("expand(): " + this.accessPointDataset.getName()));
            return this.accessPointDataset;
        }
        this.expandRecursive(this.accessPointDataset);
        ((InvCatalogImpl)this.accessPointDataset.getParentCatalog()).finish();
        return this.accessPointDataset;
    }

    private void expandRecursive(InvDataset dataset) {
        List listAllDatasets = this.expandThisLevel(dataset);
        InvDataset curDs = null;
        Iterator i = listAllDatasets.iterator();
        while (i.hasNext()) {
            curDs = (InvDataset)i.next();
            if (!this.acceptDataset(curDs)) continue;
            if (this.isCollection(curDs)) {
                if (!this.isFlatten()) {
                    ((InvDatasetImpl)dataset).addDataset((InvDatasetImpl)curDs);
                }
                this.expandRecursive(curDs);
                continue;
            }
            if (!this.isFlatten()) {
                ((InvDatasetImpl)dataset).addDataset((InvDatasetImpl)curDs);
                continue;
            }
            ((InvDatasetImpl)this.accessPointDataset).addDataset((InvDatasetImpl)curDs);
        }
    }

    private boolean acceptDataset(InvDataset curDs) {
        if (this.getDatasetFilterList().isEmpty()) {
            return true;
        }
        DatasetFilter curFilter = null;
        Iterator it = this.getDatasetFilterList().iterator();
        while (it.hasNext()) {
            curFilter = (DatasetFilter)it.next();
            if (!curFilter.accept((InvDatasetImpl)curDs)) continue;
            return true;
        }
        return false;
    }

    public InvCatalog fullExpand() {
        logger.info((Object)("fullExpand(): expanding DatasetSource named \"" + this.getName() + "\""));
        InvDataset topDs = this.expand();
        InvCatalog generatedCat = topDs.getParentCatalog();
        logger.debug((Object)"fullExpand(): naming the datasets.");
        this.nameDatasets((InvDatasetImpl)topDs);
        logger.debug((Object)"expand(): sorting the datasets.");
        Comparator dsComparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                InvDataset ds1 = (InvDataset)obj1;
                InvDataset ds2 = (InvDataset)obj2;
                return -ds1.getName().compareTo(ds2.getName());
            }
        };
        this.sortDatasets(topDs, dsComparator);
        if (this.parentDataset == null) {
            ((InvCatalogImpl)generatedCat).finish();
            return generatedCat;
        }
        Iterator it = generatedCat.getServices().iterator();
        while (it.hasNext()) {
            ((InvCatalogImpl)this.parentDataset.getParentCatalog()).addService((InvService)it.next());
        }
        if (!this.isFlatten()) {
            this.parentDataset.addDataset((InvDatasetImpl)topDs);
        } else {
            boolean addLevel = false;
            DatasetNamer curDsNamer = null;
            Iterator it2 = this.getDatasetNamerList().iterator();
            while (it2.hasNext()) {
                curDsNamer = (DatasetNamer)it2.next();
                addLevel |= curDsNamer.getAddLevel();
            }
            InvDatasetImpl curDataset = null;
            Iterator it3 = topDs.getDatasets().iterator();
            while (it3.hasNext()) {
                curDataset = (InvDatasetImpl)it3.next();
                if (addLevel) {
                    ThreddsMetadata tm = new ThreddsMetadata(false);
                    tm.setServiceName(topDs.getServiceDefault().getName());
                    InvMetadata md = new InvMetadata(topDs, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, tm);
                    curDataset.getLocalMetadata().addMetadata(md);
                } else {
                    curDataset.getLocalMetadata().setServiceName(topDs.getServiceDefault().getName());
                }
                this.parentDataset.addDataset(curDataset);
            }
        }
        this.parentDataset.finish();
        return this.parentDataset.getParentCatalog();
    }

    protected abstract void expandThisType(InvDatasetImpl var1, String var2);

    protected abstract InvDataset getTopLevelDataset();

    protected abstract boolean isCollection(InvDataset var1);

    protected abstract List expandThisLevel(InvDataset var1);

    private void nameDatasets(InvDatasetImpl datasetContainer) {
        if (this.isFlatten()) {
            logger.debug((Object)"nameDatasets(): structure is FLAT calling nameDatasetList()");
            this.nameDatasetList(datasetContainer);
        } else {
            logger.debug((Object)"nameDatasets(): structure is DIRECTORY_TREE calling nameDatasetTree() on each dataset in dataset container");
            InvDatasetImpl curDs = null;
            for (int j = 0; j < datasetContainer.getDatasets().size(); ++j) {
                curDs = (InvDatasetImpl)datasetContainer.getDatasets().get(j);
                this.nameDatasetTree(curDs);
            }
        }
    }

    private void nameDatasetList(InvDatasetImpl dataset) {
        int i;
        InvDatasetImpl namedDs = new InvDatasetImpl(dataset, "nameDatastList() temp dataset", null, null, null);
        dataset.addDataset(namedDs);
        DatasetNamer curNamer = null;
        for (i = 0; i < this.datasetNamerList.size(); ++i) {
            curNamer = (DatasetNamer)this.datasetNamerList.get(i);
            logger.debug((Object)("nameDatasetList(): trying namer (" + curNamer.getName() + ")"));
            InvDatasetImpl addLevelDs = null;
            if (curNamer.getAddLevel()) {
                addLevelDs = new InvDatasetImpl(null, curNamer.getName(), null, null, null);
            }
            InvDatasetImpl curDs = null;
            Iterator dsIter = dataset.getDatasets().iterator();
            while (dsIter.hasNext()) {
                curDs = (InvDatasetImpl)dsIter.next();
                logger.debug((Object)("nameDatasetList(): try namer on this ds (" + curDs.getName() + " - " + curDs.getUrlPath() + ")"));
                if (!curNamer.nameDataset(curDs)) continue;
                logger.debug((Object)("nameDatasetList(): ds named (" + curDs.getName() + ")"));
                if (curNamer.getAddLevel()) {
                    addLevelDs.addDataset(curDs);
                } else {
                    namedDs.addDataset(curDs);
                }
                dsIter.remove();
            }
            if (!curNamer.getAddLevel() || !addLevelDs.hasNestedDatasets()) continue;
            namedDs.addDataset(addLevelDs);
        }
        namedDs.finish();
        logger.debug((Object)("nameDatasetList(): number of unnamed datasets is " + dataset.getDatasets().size() + "."));
        logger.debug((Object)"nameDatasetList(): add named datasets back to container.");
        for (i = 0; i < namedDs.getDatasets().size(); ++i) {
            dataset.addDataset((InvDatasetImpl)namedDs.getDatasets().get(i));
        }
        dataset.removeDataset(namedDs);
    }

    private void nameDatasetTree(InvDatasetImpl dataset) {
        if (dataset.getName().equals("") || !dataset.hasAccess()) {
            logger.debug((Object)("nameDatasetTree(): naming dataset (" + dataset.getUrlPath() + ") ..."));
            DatasetNamer dsN = null;
            for (int i = 0; i < this.datasetNamerList.size(); ++i) {
                dsN = (DatasetNamer)this.datasetNamerList.get(i);
                if (!dsN.nameDataset(dataset)) continue;
                logger.debug((Object)("nameDatasetTree(): ... used namer (" + dsN.getName() + ")"));
                break;
            }
        }
        InvDatasetImpl curDs = null;
        for (int j = 0; j < dataset.getDatasets().size(); ++j) {
            curDs = (InvDatasetImpl)dataset.getDatasets().get(j);
            logger.debug((Object)("nameDatasetTree(): recurse to name child dataset (" + curDs.getUrlPath() + ")"));
            this.nameDatasetTree(curDs);
        }
    }

    private void sortDatasets(InvDataset dataset, Comparator theComparator) {
        InvDataset curDs = null;
        Iterator dsIter = dataset.getDatasets().iterator();
        while (dsIter.hasNext()) {
            curDs = (InvDataset)dsIter.next();
            this.sortDatasets(curDs, theComparator);
        }
        logger.debug((Object)("sortDatasets(): sort the datasets contained by dataset (" + dataset.getName() + ")"));
        Collections.sort(dataset.getDatasets(), theComparator);
    }

    private void addNewDatasetToParent(InvDataset container) {
    }
}

