/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import thredds.catalog.InvDataset;

public class CatalogRefExpander {
    private static Logger logger = Logger.getLogger((String)CatalogRefExpander.class.getName());
    private String name;
    private String directoryMatchPattern;
    private String catalogTitleSubstitutionPattern;
    private String catalogFilenameSubstitutionPattern;
    private boolean expand = true;
    private boolean flattenCatalog = false;
    private Pattern pattern;
    private Matcher matcher;

    public CatalogRefExpander(String name, String directoryMatchPattern, String catalogTitleSubstitutionPattern, String catalogFilenameSubstitutionPattern, boolean expand, boolean flattenCatalog) {
        this.name = name;
        this.directoryMatchPattern = directoryMatchPattern;
        this.catalogTitleSubstitutionPattern = catalogTitleSubstitutionPattern;
        this.catalogFilenameSubstitutionPattern = catalogFilenameSubstitutionPattern;
        this.expand = expand;
        this.flattenCatalog = flattenCatalog;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        CatalogRefExpander.logger = logger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDirectoryMatchPattern() {
        return this.directoryMatchPattern;
    }

    public void setDirectoryMatchPattern(String directoryMatchPattern) {
        this.directoryMatchPattern = directoryMatchPattern;
    }

    public String getCatalogTitleSubstitutionPattern() {
        return this.catalogTitleSubstitutionPattern;
    }

    public void setCatalogTitleSubstitutionPattern(String catalogTitleSubstitutionPattern) {
        this.catalogTitleSubstitutionPattern = catalogTitleSubstitutionPattern;
    }

    public String getCatalogFilenameSubstitutionPattern() {
        return this.catalogFilenameSubstitutionPattern;
    }

    public void setCatalogFilenameSubstitutionPattern(String catalogFilenameSubstitutionPattern) {
        this.catalogFilenameSubstitutionPattern = catalogFilenameSubstitutionPattern;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setExpand(boolean expand) {
        this.expand = expand;
    }

    public boolean isFlattenCatalog() {
        return this.flattenCatalog;
    }

    public void setFlattenCatalog(boolean flattenCatalog) {
        this.flattenCatalog = flattenCatalog;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatalogRefExpander)) {
            return false;
        }
        CatalogRefExpander catalogRefExpander = (CatalogRefExpander)o;
        if (this.flattenCatalog != catalogRefExpander.flattenCatalog) {
            return false;
        }
        if (this.expand != catalogRefExpander.expand) {
            return false;
        }
        if (this.catalogFilenameSubstitutionPattern != null ? !this.catalogFilenameSubstitutionPattern.equals(catalogRefExpander.catalogFilenameSubstitutionPattern) : catalogRefExpander.catalogFilenameSubstitutionPattern != null) {
            return false;
        }
        if (this.catalogTitleSubstitutionPattern != null ? !this.catalogTitleSubstitutionPattern.equals(catalogRefExpander.catalogTitleSubstitutionPattern) : catalogRefExpander.catalogTitleSubstitutionPattern != null) {
            return false;
        }
        if (this.directoryMatchPattern != null ? !this.directoryMatchPattern.equals(catalogRefExpander.directoryMatchPattern) : catalogRefExpander.directoryMatchPattern != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(catalogRefExpander.name) : catalogRefExpander.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.directoryMatchPattern != null ? this.directoryMatchPattern.hashCode() : 0);
        result = 29 * result + (this.catalogTitleSubstitutionPattern != null ? this.catalogTitleSubstitutionPattern.hashCode() : 0);
        result = 29 * result + (this.catalogFilenameSubstitutionPattern != null ? this.catalogFilenameSubstitutionPattern.hashCode() : 0);
        result = 29 * result + (this.expand ? 1 : 0);
        result = 29 * result + (this.flattenCatalog ? 1 : 0);
        return result;
    }

    public boolean makeCatalogRef(InvDataset dataset) {
        this.pattern = Pattern.compile(this.directoryMatchPattern);
        this.matcher = this.pattern.matcher(dataset.getName());
        return this.matcher.matches();
    }

    public String catalogRefTitle() {
        StringBuffer val = new StringBuffer();
        this.matcher.appendReplacement(val, this.catalogTitleSubstitutionPattern);
        return val.toString();
    }

    public String catalogRefFilename() {
        StringBuffer val = new StringBuffer();
        this.matcher.appendReplacement(val, this.catalogFilenameSubstitutionPattern);
        return val.toString();
    }
}

