/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.ServiceType;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.ResultService;

public class DirectoryScanner {
    private static Logger logger = Logger.getLogger((String)DirectoryScanner.class.getName());
    private String serviceId;
    private ServiceType serviceType;
    private String serviceBaseUrl;
    private File serviceRootDir;
    private ResultService service;

    public DirectoryScanner(String serviceId, String serviceType, String serviceBaseUrl, File serviceRootDir) {
        this.serviceId = serviceId;
        this.serviceType = ServiceType.getType(serviceType);
        if (this.serviceType == null) {
            throw new IllegalArgumentException("Invalid service type <" + serviceType + ">.");
        }
        this.serviceBaseUrl = serviceBaseUrl;
        this.serviceRootDir = serviceRootDir;
        if (!this.serviceRootDir.isDirectory()) {
            throw new IllegalArgumentException("Root directory is not a directory <" + serviceRootDir.getAbsolutePath() + ">.");
        }
        this.service = new ResultService(this.serviceId, this.serviceType.toString(), this.serviceBaseUrl, null, this.serviceRootDir.getAbsolutePath());
    }

    public InvCatalog getDirCatalog(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Given directory is not a directory <" + directory.getAbsolutePath() + ">.");
        }
        DatasetSource dsSource = DatasetSource.newDatasetSource(null, null, directory.getName(), DatasetSourceType.LOCAL, DatasetSourceStructure.DIRECTORY_TREE, directory.getAbsolutePath(), this.service);
        return dsSource.expand().getParentCatalog();
    }

    public String getDirCatalogAsString(File directory) {
        String results = null;
        InvCatalogFactory catFactory = new InvCatalogFactory("default", true);
        try {
            results = catFactory.writeXML((InvCatalogImpl)this.getDirCatalog(directory));
        }
        catch (IOException e) {
            logger.warn((Object)("IOException while writing catalog to string: " + e.getMessage()));
            return null;
        }
        return results;
    }
}

