/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import thredds.catalog.InvCatalog;

public class CatalogRefGroup
implements Map {
    private static Logger logger = Logger.getLogger((String)CatalogRefGroup.class.getName());
    private HashMap map = new HashMap();
    private String topCatalogName = null;

    public void setTopCatalogName(String topCatName) {
        if (topCatName == null) {
            throw new NullPointerException("Given name is null");
        }
        this.topCatalogName = topCatName;
    }

    public String getTopCatalogName() {
        return this.topCatalogName;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Null map key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Map key not a String");
        }
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException("Null map value");
        }
        if (!(value instanceof InvCatalog)) {
            throw new ClassCastException("Map value not a InvCatalog");
        }
        return this.map.containsValue(value);
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("Null map key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Map key not a String");
        }
        return this.map.get(key);
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Null map key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Map key not a String");
        }
        return this.map.remove(key);
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("Map key or value null");
        }
        if (key instanceof String) {
            throw new ClassCastException("Map key not a String");
        }
        if (value instanceof InvCatalog) {
            throw new ClassCastException("Map value not an InvCatalog");
        }
        if (this.map.containsKey(key)) {
            throw new IllegalArgumentException("Map key <" + key + "> already mapped");
        }
        Object shouldBeNull = this.map.put(key, value);
        return shouldBeNull;
    }

    public void putAll(Map t) {
        if (t == null) {
            throw new NullPointerException("Null map");
        }
        if (!(t instanceof CatalogRefGroup)) {
            throw new IllegalArgumentException("Given map not a CatalogRefGroup");
        }
        Iterator i = t.keySet().iterator();
        while (i.hasNext()) {
            String curKey = (String)i.next();
            this.map.put(curKey, t.get(curKey));
        }
    }
}

