/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.MetadataType;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.config.CatGenConfigMetadataFactory;
import thredds.cataloggen.config.CatalogGenConfig;
import thredds.cataloggen.config.DatasetSource;

public class CatalogGen {
    private static Logger logger = Logger.getLogger((String)CatalogGen.class.getName());
    private URL configDocURL = null;
    private InvCatalog catalog = null;
    private InvCatalogFactory catFactory = null;

    public CatalogGen(URL configDocURL) {
        logger.debug((Object)"CatalogGen(URL): create catalog and CatalogGenConfig converter.");
        this.catFactory = new InvCatalogFactory("default", true);
        this.catFactory.registerMetadataConverter(MetadataType.CATALOG_GEN_CONFIG.toString(), new CatGenConfigMetadataFactory());
        this.configDocURL = configDocURL;
        logger.debug((Object)("CatalogGen(URL): reading the config doc <" + this.configDocURL.toString() + ">."));
        this.catalog = this.catFactory.readXML(this.configDocURL.toString());
        logger.debug((Object)"CatalogGen(URL): done.");
    }

    public CatalogGen(InputStream configDocInputStream, URL configDocURL) {
        logger.debug((Object)"CatalogGen(InputStream): create catalog and CatalogGenConfig converter.");
        this.catFactory = new InvCatalogFactory("default", true);
        this.catFactory.registerMetadataConverter(MetadataType.CATALOG_GEN_CONFIG.toString(), new CatGenConfigMetadataFactory());
        this.configDocURL = configDocURL;
        logger.debug((Object)("CatalogGen(InputStream): reading the config doc <" + configDocURL.toString() + ">."));
        this.catalog = this.catFactory.readXML(configDocInputStream, URI.create(configDocURL.toExternalForm()));
        logger.debug((Object)("CatalogGen(InputStream): CatalogGenConfig doc <" + this.catalog.getName() + "> read."));
    }

    public boolean isValid(StringBuffer out) {
        logger.debug((Object)"isValid(): start");
        return this.catalog.check(out);
    }

    public void expand() {
        CatalogGenConfig tmpCgc = null;
        List cgcList = null;
        Object dssList = null;
        DatasetSource dss = null;
        logger.debug((Object)"expand(): find all CatGenConfigMetadata elements.");
        List mdataList = this.findCatGenConfigMdata(this.catalog.getDatasets());
        for (int i = 0; i < mdataList.size(); ++i) {
            InvMetadata mdata = (InvMetadata)mdataList.get(i);
            logger.debug((Object)("expand(): <# " + i + "> metadata element of type CatalogGenConfig."));
            cgcList = (List)mdata.getContentObject();
            for (int j = 0; j < cgcList.size(); ++j) {
                tmpCgc = (CatalogGenConfig)cgcList.get(j);
                logger.debug((Object)("expand(): <# " + j + "> catalogGenConfig element."));
                dss = tmpCgc.getDatasetSource();
                dss.fullExpand();
            }
            logger.debug((Object)("expand(): Remove metadata record CGCM(" + i + ")."));
            ((InvDatasetImpl)mdata.getParentDataset()).removeLocalMetadata(mdata);
            ((InvCatalogImpl)this.catalog).finish();
        }
    }

    public boolean writeCatalog(String outFileName) {
        logger.debug((Object)("writeCatalog(): writing catalog to " + outFileName + "."));
        String invCatDTD = "http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd";
        logger.debug((Object)("writeCatalog(): set the catalogs DTD (" + invCatDTD + ")."));
        ((InvCatalogImpl)this.catalog).setDTDid(invCatDTD);
        if (outFileName == null) {
            try {
                logger.debug((Object)"writeCatalog(): write catalog to System.out.");
                this.catFactory.writeXML((InvCatalogImpl)this.catalog, System.out);
            }
            catch (IOException e) {
                logger.debug((Object)("writeCatalog(): exception when writing to stdout.\n" + e.toString()));
                return false;
            }
            return true;
        }
        logger.debug((Object)("writeCatalog(): try writing catalog to the output file (" + outFileName + ")."));
        if (this.catFactory.writeXML((InvCatalogImpl)this.catalog, outFileName)) {
            logger.debug((Object)("writeCatalog(): catalog written to " + outFileName + "."));
            return true;
        }
        logger.debug((Object)("writeCatalog(): catalog not written to " + outFileName + "."));
        return false;
    }

    protected boolean compareCatalog(InvCatalogImpl expectedCatalog) {
        return ((InvCatalogImpl)this.catalog).equals(expectedCatalog);
    }

    InvCatalog getCatalog() {
        return this.catalog;
    }

    private List findCatGenConfigMdata(List datasets) {
        ArrayList<InvMetadata> mdataList = new ArrayList<InvMetadata>();
        if (datasets == null) {
            return mdataList;
        }
        Iterator it = datasets.iterator();
        InvDataset curDataset = null;
        while (it.hasNext()) {
            curDataset = (InvDataset)it.next();
            ThreddsMetadata tm = ((InvDatasetImpl)curDataset).getLocalMetadata();
            Iterator itMdata = tm.getMetadata().iterator();
            InvMetadata curMetadata = null;
            while (itMdata.hasNext()) {
                curMetadata = (InvMetadata)itMdata.next();
                if (curMetadata.getMetadataType() != null && curMetadata.getMetadataType().equals(MetadataType.CATALOG_GEN_CONFIG.toString())) {
                    mdataList.add(curMetadata);
                    continue;
                }
                if (curMetadata.getNamespaceURI() == null || !curMetadata.getNamespaceURI().equals("http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5")) continue;
                mdataList.add(curMetadata);
            }
            mdataList.addAll(this.findCatGenConfigMdata(curDataset.getDatasets()));
        }
        return mdataList;
    }

    public static void main(String[] args) {
        String configFileName = null;
        File configFile = null;
        URL configDocURL = null;
        String logFileName = null;
        File logFile = null;
        String logLevelName = null;
        Level logLevel = null;
        PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd HH:mm:ss.SSS} [%10r] %-5p - %c - %m%n");
        ConsoleAppender appender = null;
        Logger catGenLogger = null;
        String outFileName = null;
        CatalogGen catGen = null;
        StringBuffer log = new StringBuffer();
        if (args.length == 1) {
            if (args[0].equals("-help")) {
                CatalogGen.usage(System.out);
                System.exit(0);
            } else {
                configFileName = args[0];
            }
        } else if (args.length == 2) {
            configFileName = args[0];
            outFileName = args[1];
        } else if (args.length == 4 || args.length == 5) {
            if (args[0].equals("-log")) {
                logFileName = args[1];
                logLevelName = args[2];
                configFileName = args[3];
                if (args.length == 5) {
                    outFileName = args[4];
                }
                logLevel = Level.toLevel((String)logLevelName);
                logFile = new File(logFileName);
                try {
                    appender = new RollingFileAppender((Layout)layout, logFile.toString(), false);
                }
                catch (IOException e) {
                    System.err.println("CatalogGen: Error - log file creation got IOException (" + logFile.toString() + ")");
                    System.err.println("    " + e.getMessage());
                    System.exit(1);
                }
            } else {
                System.err.println("CatalogGen: Did not understand your request (1).");
                CatalogGen.usage(System.err);
                System.exit(1);
            }
        } else {
            System.err.println("CatalogGen: Did not understand your request (2).");
            CatalogGen.usage(System.err);
            System.exit(1);
        }
        if (appender == null) {
            appender = new ConsoleAppender((Layout)layout);
            logLevel = Level.toLevel((String)"OFF");
        }
        catGenLogger = Logger.getLogger((String)"thredds.cataloggen");
        catGenLogger.setLevel(logLevel);
        catGenLogger.addAppender((Appender)appender);
        try {
            URI tmpURI;
            if (!configFileName.startsWith("http:") && !configFileName.startsWith("file:")) {
                configFile = new File(configFileName);
                if (!configFile.canRead()) {
                    logger.error((Object)("CatalogGen: config file is not readable (" + configFile.toString() + ")"));
                    System.err.println("CatalogGen: config file is not readable (" + configFile.toString() + ")");
                    System.exit(1);
                }
                tmpURI = configFile.toURI();
            } else {
                tmpURI = new URI(configFileName);
            }
            configDocURL = tmpURI.toURL();
        }
        catch (MalformedURLException e) {
            logger.error((Object)("CatalogGen: The config doc path is not a valid URL (" + e.getMessage() + ")."));
            System.err.println("CatalogGen: The config doc path is not a valid URL.");
            CatalogGen.usage(System.err);
            System.exit(1);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("CatalogGen: The config doc path is not a valid URI (" + e.getMessage() + ")."));
            System.err.println("CatalogGen: The config doc path is not a valid URI.");
            CatalogGen.usage(System.err);
            System.exit(1);
        }
        catGen = new CatalogGen(configDocURL);
        if (catGen.isValid(log)) {
            catGen.expand();
            if (catGen.writeCatalog(outFileName)) {
                logger.debug((Object)("CatalogGen: the catalog was written to " + outFileName + "."));
                System.out.println("CatalogGen: the catalog was written to " + outFileName + ".");
                System.exit(0);
            } else {
                logger.error((Object)("CatalogGen: the catalog was not written to " + outFileName + "."));
                System.err.println("CatalogGen: the catalog was not written to " + outFileName + ".");
                System.exit(1);
            }
        } else {
            logger.error((Object)("CatalogGen: Invalid config file (" + configFileName + "):\n" + log.toString()));
            System.err.println("CatalogGen: Invalid config file (" + configFileName + "):");
            System.err.println(log.toString());
            System.exit(1);
        }
    }

    private static void usage(PrintStream ps) {
        ps.println("Usage:");
        ps.println("  CatalogGen [options] <configDocName> [<outFileName>]\n    Given a CatalogGenConfig 0.5 document, produce a completed\n    InvCatalog 0.6 document. NOTE: the configuration document may\n    be specified as a local file name or as a URL.");
        ps.println("Options:\n  -help\n      Print this usage message.\n  -log <logFileName> <logLevel>\n      Write a log file at the given log level (OFF, FATAL, WARN, INFO, DEBUG, ALL).\n");
    }
}

